/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DescriptorWithParentObject;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiExpression;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u000f\u001a\u00020\u000e*\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/render/GetterDescriptor;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "Lcom/intellij/debugger/ui/tree/DescriptorWithParentObject;", "parentObject", "Lcom/sun/jdi/ObjectReference;", "getter", "Lcom/sun/jdi/Method;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/sun/jdi/ObjectReference;Lcom/sun/jdi/Method;Lcom/intellij/openapi/project/Project;)V", "getGetter", "()Lcom/sun/jdi/Method;", "name", "", "removeGetterPrefix", "getObject", "getDescriptorEvaluation", "Lcom/intellij/psi/PsiExpression;", "context", "Lcom/intellij/debugger/DebuggerContext;", "getName", "getType", "Lcom/sun/jdi/Type;", "getRenderer", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/debugger/ui/tree/render/NodeRenderer;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "calcValue", "Lcom/sun/jdi/Value;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Companion", "kotlin.jvm-debugger.core"})
public final class GetterDescriptor
extends ValueDescriptorImpl
implements DescriptorWithParentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectReference parentObject;
    @NotNull
    private final Method getter;
    @NotNull
    private final String name;
    @NotNull
    private static final String[] GETTER_PREFIXES;

    public GetterDescriptor(@NotNull ObjectReference parentObject, @NotNull Method getter, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)parentObject, (String)"parentObject");
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.parentObject = parentObject;
        this.getter = getter;
        String string = this.getter.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        this.name = StringsKt.decapitalize((String)this.removeGetterPrefix(string));
        OnDemandRenderer.ON_DEMAND_CALCULATED.set((UserDataHolder)this, (Object)false);
        String returnTypeName = this.getter.returnTypeName();
        this.setOnDemandPresentationProvider(arg_0 -> GetterDescriptor._init_$lambda$0(this, returnTypeName, arg_0));
    }

    @NotNull
    public final Method getGetter() {
        return this.getter;
    }

    private final String removeGetterPrefix(String $this$removeGetterPrefix) {
        if (StringsKt.startsWith$default((String)$this$removeGetterPrefix, (String)"get", (boolean)false, (int)2, null)) {
            return StringsKt.drop((String)$this$removeGetterPrefix, (int)3);
        }
        return $this$removeGetterPrefix;
    }

    @NotNull
    public ObjectReference getObject() {
        return this.parentObject;
    }

    @NotNull
    public PsiExpression getDescriptorEvaluation(@NotNull DebuggerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new EvaluateException("Getter evaluation is not supported");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Type getType() {
        return SafeUtilKt.safeReturnType(this.getter);
    }

    @NotNull
    public CompletableFuture<NodeRenderer> getRenderer(@Nullable DebugProcessImpl debugProcess) {
        CompletableFuture completableFuture = this.getRenderer(this.getType(), debugProcess);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"getRenderer(...)");
        return completableFuture;
    }

    @Nullable
    public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
        EvaluationContextImpl evaluationContextImpl = evaluationContext;
        return evaluationContextImpl != null && (evaluationContextImpl = evaluationContextImpl.getDebugProcess()) != null ? evaluationContextImpl.invokeMethod((EvaluationContext)evaluationContext, this.parentObject, this.getter, CollectionsKt.emptyList()) : null;
    }

    private static final void _init_$lambda$0(GetterDescriptor this$0, String $returnTypeName, XValueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.setFullValueEvaluator(OnDemandRenderer.createFullValueEvaluator((XValueNode)node, (ValueDescriptor)((ValueDescriptor)this$0), (String)KotlinDebuggerCoreBundle.message("message.variables.property.get", new Object[0])));
        node.setPresentation(IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property), (XValuePresentation)new XRegularValuePresentation("", $returnTypeName, " "), false);
    }

    static {
        String[] stringArray = new String[]{"get", "is"};
        GETTER_PREFIXES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/render/GetterDescriptor$Companion;", "", "<init>", "()V", "GETTER_PREFIXES", "", "", "getGETTER_PREFIXES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getGETTER_PREFIXES() {
            return GETTER_PREFIXES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

