/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.coverage;

import com.intellij.coverage.ConditionCoverageExpression;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.SwitchCoverageExpression;
import com.intellij.coverage.analysis.JavaCoverageAnnotator;
import com.intellij.coverage.analysis.JavaCoverageClassesEnumerator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.coverage.data.LineData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.coverage.KtCoveragePsiUtilsKt;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0016J3\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J:\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000fH\u0016J@\u0010$\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020/H\u0016\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension;", "Lcom/intellij/coverage/JavaCoverageEngineExtension;", "<init>", "()V", "isApplicableTo", "", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "suggestQualifiedName", "sourceFile", "Lcom/intellij/psi/PsiFile;", "classes", "", "Lcom/intellij/psi/PsiClass;", "names", "", "", "(Lcom/intellij/psi/PsiFile;[Lcom/intellij/psi/PsiClass;Ljava/util/Set;)Z", "getSummaryCoverageInfo", "Lcom/intellij/coverage/analysis/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/analysis/JavaCoverageAnnotator;", "element", "Lcom/intellij/psi/PsiNamedElement;", "keepCoverageInfoForClassWithoutSource", "bundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "classFile", "Ljava/io/File;", "collectOutputFiles", "srcFile", "output", "Lcom/intellij/openapi/vfs/VirtualFile;", "testoutput", "suite", "classFiles", "generateBriefReport", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "lineNumber", "", "startOffset", "endOffset", "lineData", "Lcom/intellij/rt/coverage/data/LineData;", "getModuleWithOutput", "Lcom/intellij/openapi/module/Module;", "module", "Companion", "kotlin.coverage"})
@SourceDebugExtension(value={"SMAP\nKotlinCoverageExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCoverageExtension.kt\norg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n295#2,2:202\n1628#2,3:204\n*S KotlinDebug\n*F\n+ 1 KotlinCoverageExtension.kt\norg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension\n*L\n61#1:202,2\n94#1:204,3\n*E\n"})
public final class KotlinCoverageExtension
extends JavaCoverageEngineExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean isApplicableTo(@Nullable RunConfigurationBase<?> conf) {
        return conf instanceof KotlinRunConfiguration;
    }

    public boolean suggestQualifiedName(@NotNull PsiFile sourceFile, @NotNull PsiClass[] classes, @NotNull Set<String> names) {
        List qNames;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)classes, (String)"classes");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (sourceFile instanceof KtFile && !((collection = (Collection)(qNames = KotlinCoverageExtension.Companion.collectGeneratedClassQualifiedNames((KtFile)sourceFile))) == null || collection.isEmpty())) {
            names.addAll(qNames);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PackageAnnotator.ClassCoverageInfo getSummaryCoverageInfo(@NotNull JavaCoverageAnnotator coverageAnnotator, @NotNull PsiNamedElement element) {
        Intrinsics.checkNotNullParameter((Object)coverageAnnotator, (String)"coverageAnnotator");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtClassOrObject) {
            Object v2;
            Project project;
            block7: {
                void $this$firstOrNull$iv;
                Project project2 = ((KtClassOrObject)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                Collection collection = CoverageDataManager.getInstance((Project)project).activeSuites();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"activeSuites(...)");
                Iterable iterable = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CoverageSuitesBundle it = (CoverageSuitesBundle)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getAnnotator(project).getClass(), coverageAnnotator.getClass())) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            CoverageSuitesBundle coverageSuitesBundle = v2;
            if (coverageSuitesBundle == null) {
                return null;
            }
            CoverageSuitesBundle bundle = coverageSuitesBundle;
            GlobalSearchScope globalSearchScope = bundle.getSearchScope(project);
            if (globalSearchScope == null) {
                return null;
            }
            GlobalSearchScope searchScope = globalSearchScope;
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element));
            if (virtualFile == null) {
                return null;
            }
            VirtualFile vFile = virtualFile;
            if (!searchScope.contains(vFile)) {
                return null;
            }
            FqName fqName2 = ((KtClassOrObject)element).getFqName();
            return coverageAnnotator.getClassCoverageInfo(fqName2 != null ? fqName2.asString() : null);
        }
        if (!(element instanceof KtFile)) {
            return null;
        }
        LOG.debug("Retrieving coverage for " + ((KtFile)element).getName());
        List qualifiedNames = KotlinCoverageExtension.Companion.collectGeneratedClassQualifiedNames((KtFile)element);
        Collection collection = qualifiedNames;
        return collection == null || collection.isEmpty() ? null : KotlinCoverageExtension.Companion.totalCoverageForQualifiedNames(coverageAnnotator, qualifiedNames);
    }

    public boolean keepCoverageInfoForClassWithoutSource(@NotNull CoverageSuitesBundle bundle, @NotNull File classFile) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean collectOutputFiles(@NotNull PsiFile srcFile, @Nullable VirtualFile output, @Nullable VirtualFile testoutput, @NotNull CoverageSuitesBundle suite, @NotNull Set<File> classFiles) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter(classFiles, (String)"classFiles");
        if (srcFile instanceof KtFile) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)((KtFile)srcFile).getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            if (((Boolean)ActionsKt.runReadAction(() -> KotlinCoverageExtension.collectOutputFiles$lambda$1(fileIndex, srcFile))).booleanValue()) {
                return false;
            }
            List existingClassFiles = KotlinCoverageExtension.Companion.getClassesGeneratedFromFile((KtFile)srcFile);
            Iterable $this$mapTo$iv = existingClassFiles;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv;
                Collection collection = classFiles;
                boolean bl = false;
                collection.add(new File(it.getPath()));
            }
            return !((Collection)existingClassFiles).isEmpty();
        }
        return false;
    }

    @Nullable
    public String generateBriefReport(@Nullable Editor editor, @Nullable PsiFile file, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (!(file instanceof KtFile) || lineData == null) {
            return super.generateBriefReport(editor, file, lineNumber, startOffset, endOffset, lineData);
        }
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range2 = textRange;
        List<ConditionCoverageExpression> conditions = KtCoveragePsiUtilsKt.getConditions(file, range2);
        List<SwitchCoverageExpression> switches = KtCoveragePsiUtilsKt.getSwitches(file, range2);
        return JavaCoverageEngine.createBriefReport((LineData)lineData, conditions, switches);
    }

    @Nullable
    public Module getModuleWithOutput(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return KotlinCoverageExtension.Companion.findJvmModule(module);
    }

    private static final boolean collectOutputFiles$lambda$1(ProjectFileIndex $fileIndex, PsiFile $srcFile) {
        return $fileIndex.isInLibraryClasses(((KtFile)$srcFile).getVirtualFile()) || $fileIndex.isInLibrarySource(((KtFile)$srcFile).getVirtualFile());
    }

    static {
        Logger logger = Logger.getInstance(KotlinCoverageExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "collectGeneratedClassQualifiedNames", "", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "outputRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "totalCoverageForQualifiedNames", "Lcom/intellij/coverage/analysis/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/analysis/JavaCoverageAnnotator;", "qualifiedNames", "getClassesGeneratedFromFile", "findOutputRoots", "", "(Lorg/jetbrains/kotlin/psi/KtFile;)[Lcom/intellij/openapi/vfs/VirtualFile;", "findJvmModule", "Lcom/intellij/openapi/module/Module;", "module", "collectClassFilePrefixes", "", "kotlin.coverage"})
    @SourceDebugExtension(value={"SMAP\nKotlinCoverageExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCoverageExtension.kt\norg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n10065#2:202\n10487#2,5:203\n10065#2:214\n10487#2,5:215\n3829#2:220\n4344#2:221\n4345#2:225\n4135#2,11:229\n1557#3:208\n1628#3,3:209\n1863#3,2:212\n1755#3,3:222\n295#3,2:227\n1611#3,9:240\n1863#3:249\n1864#3:251\n1620#3:252\n1#4:226\n1#4:250\n*S KotlinDebug\n*F\n+ 1 KotlinCoverageExtension.kt\norg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension$Companion\n*L\n121#1:202\n121#1:203,5\n160#1:214\n160#1:215,5\n168#1:220\n168#1:221\n168#1:225\n195#1:229,11\n129#1:208\n129#1:209,3\n141#1:212,2\n169#1:222,3\n189#1:227,2\n195#1:240,9\n195#1:249\n195#1:251\n195#1:252\n195#1:250\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> collectGeneratedClassQualifiedNames(KtFile file) {
            List list2;
            VirtualFile[] virtualFileArray = this.findOutputRoots(file);
            if (virtualFileArray != null) {
                void $this$flatMapTo$iv$iv;
                VirtualFile[] $this$flatMap$iv = virtualFileArray;
                boolean $i$f$flatMap = false;
                VirtualFile[] virtualFileArray2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                int n = ((void)$this$flatMapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
                    boolean bl = false;
                    List list3 = Companion.collectGeneratedClassQualifiedNames((VirtualFile)it, file);
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list3;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> collectGeneratedClassQualifiedNames(@Nullable VirtualFile outputRoot, @NotNull KtFile file) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            List<VirtualFile> existingClassFiles = this.getClassesGeneratedFromFile(outputRoot, file);
            if (existingClassFiles.isEmpty()) {
                return null;
            }
            LOG.debug("ClassFiles: [" + CollectionsKt.joinToString$default((Iterable)existingClassFiles, null, null, null, (int)0, null, Companion::collectGeneratedClassQualifiedNames$lambda$1, (int)31, null) + "]");
            Iterable $this$map$iv = existingClassFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String relativePath;
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = outputRoot;
                Intrinsics.checkNotNull((Object)virtualFile2);
                Intrinsics.checkNotNull((Object)VfsUtilCore.getRelativePath((VirtualFile)it, (VirtualFile)virtualFile2));
                collection.add(StringsKt.replace$default((String)StringsKt.removeSuffix((String)relativePath, (CharSequence)".class"), (String)"/", (String)".", (boolean)false, (int)4, null));
            }
            return (List)destination$iv$iv;
        }

        private final PackageAnnotator.ClassCoverageInfo totalCoverageForQualifiedNames(JavaCoverageAnnotator coverageAnnotator, List<String> qualifiedNames) {
            PackageAnnotator.ClassCoverageInfo result2 = new PackageAnnotator.ClassCoverageInfo();
            result2.totalClassCount = 0;
            Iterable $this$forEach$iv = qualifiedNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                PackageAnnotator.ClassCoverageInfo classInfo = coverageAnnotator.getClassCoverageInfo(it);
                if (classInfo != null) {
                    result2.totalClassCount += classInfo.totalClassCount;
                    result2.coveredClassCount += classInfo.coveredClassCount;
                    result2.totalMethodCount += classInfo.totalMethodCount;
                    result2.coveredMethodCount += classInfo.coveredMethodCount;
                    result2.totalLineCount += classInfo.totalLineCount;
                    result2.fullyCoveredLineCount += classInfo.fullyCoveredLineCount;
                    result2.partiallyCoveredLineCount += classInfo.partiallyCoveredLineCount;
                    continue;
                }
                LOG.debug("Found no coverage for " + it);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getClassesGeneratedFromFile(KtFile file) {
            List list2;
            VirtualFile[] virtualFileArray = this.findOutputRoots(file);
            if (virtualFileArray != null) {
                void $this$flatMapTo$iv$iv;
                VirtualFile[] $this$flatMap$iv = virtualFileArray;
                boolean $i$f$flatMap = false;
                VirtualFile[] virtualFileArray2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                int n = ((void)$this$flatMapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
                    boolean bl = false;
                    Iterable list$iv$iv = (Iterable)ActionsKt.runReadAction(() -> Companion.getClassesGeneratedFromFile$lambda$5$lambda$4((VirtualFile)it, file));
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getClassesGeneratedFromFile(VirtualFile outputRoot, KtFile file) {
            void $this$filterTo$iv$iv;
            String relativePath = StringsKt.replace$default((String)file.getPackageFqName().asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
            VirtualFile virtualFile = outputRoot;
            if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(relativePath)) == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile packageOutputDir = virtualFile;
            Collection<String> prefixes = this.collectClassFilePrefixes(file);
            LOG.debug("ClassFile prefixes: [" + CollectionsKt.joinToString$default((Iterable)prefixes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]");
            VirtualFile[] virtualFileArray = packageOutputDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block5: {
                    VirtualFile packageFile = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = prefixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            String string = packageFile.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            if (!(StringsKt.startsWith$default((String)string, (String)(it + "$"), (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)packageFile.getName()), (Object)"class") || Intrinsics.areEqual((Object)packageFile.getName(), (Object)(it + ".class")))) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final VirtualFile[] findOutputRoots(KtFile file) {
            VirtualFile[] virtualFileArray;
            Module module = (Module)ActionsKt.runReadAction(() -> Companion.findOutputRoots$lambda$8(file));
            if (module == null) {
                return null;
            }
            Module module2 = module;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            boolean inTests = Intrinsics.areEqual((Object)ActionsKt.runReadAction(() -> Companion.findOutputRoots$lambda$9(fileIndex, file)), (Object)TestSourceKotlinRootType.INSTANCE);
            CoverageDataManager manager = CoverageDataManager.getInstance((Project)file.getProject());
            VirtualFile[] it = JavaCoverageClassesEnumerator.getRoots((CoverageDataManager)manager, (Module)module2, (boolean)inTests);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(it.length == 0)) {
                return it;
            }
            Module module3 = this.findJvmModule(module2);
            if (module3 != null) {
                Module candidate = module3;
                boolean bl2 = false;
                virtualFileArray = JavaCoverageClassesEnumerator.getRoots((CoverageDataManager)manager, (Module)candidate, (boolean)inTests);
            } else {
                virtualFileArray = null;
            }
            return virtualFileArray;
        }

        private final Module findJvmModule(Module module) {
            if (KotlinFacetUtils.isMultiPlatformModule(module)) {
                Object v0;
                block2: {
                    Iterable $this$firstOrNull$iv = KotlinFacetUtils.getImplementingModules(module);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Module it = (Module)element$iv;
                        boolean bl = false;
                        if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform(it))) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                return v0;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> collectClassFilePrefixes(KtFile file) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = file.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClassOrObject)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            FqName packagePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file).getFileClassFqName();
            Object[] objectArray2 = new String[]{packagePartFqName.shortName().asString()};
            return CollectionsKt.union((Iterable)result2, (Iterable)CollectionsKt.arrayListOf((Object[])objectArray2));
        }

        private static final CharSequence collectGeneratedClassQualifiedNames$lambda$1(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        private static final List getClassesGeneratedFromFile$lambda$5$lambda$4(VirtualFile $it, KtFile $file) {
            return Companion.getClassesGeneratedFromFile($it, $file);
        }

        private static final Module findOutputRoots$lambda$8(KtFile $file) {
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$file));
        }

        private static final KotlinSourceRootType findOutputRoots$lambda$9(ProjectFileIndex $fileIndex, KtFile $file) {
            VirtualFile virtualFile = $file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return KotlinProjectStructureUtils.getKotlinSourceRootType($fileIndex, virtualFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

