/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationBundle;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProjectFUSCollector;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a%\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00060\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a%\u0010\r\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00060\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"showMigrationNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "appendBr", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "Lkotlin/text/StringBuilder;", "line", "", "(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;", "appendIndentBr", "kotlin.migration"})
public final class MigrationNotificationKt {
    public static final void showMigrationNotification(@NotNull Project project, @NotNull MigrationInfo migrationInfo) {
        Object[] objectArray;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        StringBuilder $this$showMigrationNotification_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        MigrationNotificationKt.appendBr($this$showMigrationNotification_u24lambda_u240, KotlinMigrationBundle.message("configuration.migration.text.detected.migration", new Object[0]));
        if (migrationInfo.getOldLanguageVersion() != migrationInfo.getNewLanguageVersion()) {
            objectArray = new Object[]{migrationInfo.getOldLanguageVersion(), migrationInfo.getNewLanguageVersion()};
            MigrationNotificationKt.appendIndentBr($this$showMigrationNotification_u24lambda_u240, KotlinMigrationBundle.message("configuration.migration.text.language.version", objectArray));
        }
        if (!Intrinsics.areEqual((Object)migrationInfo.getOldApiVersion(), (Object)migrationInfo.getNewApiVersion())) {
            objectArray = new Object[]{migrationInfo.getOldApiVersion(), migrationInfo.getNewApiVersion()};
            MigrationNotificationKt.appendIndentBr($this$showMigrationNotification_u24lambda_u240, KotlinMigrationBundle.message("configuration.migration.text.api.version", objectArray));
        }
        String detectedChangeMessage = stringBuilder.toString();
        KotlinMigrationProjectFUSCollector.INSTANCE.logNotification(migrationInfo);
        NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Migration").createNotification(KotlinMigrationBundle.message("configuration.migration.title.kotlin.migration", new Object[0]), KotlinMigrationBundle.message("configuration.migration.text.update.your.code.to.replace.deprecated", new Object[0]) + "<br/><br/>" + detectedChangeMessage, NotificationType.WARNING).setSuggestionType(true).addAction((AnAction)NotificationAction.createExpiring((String)KotlinMigrationBundle.message("configuration.migration.text.scan.for.deprecations", new Object[0]), (arg_0, arg_1) -> MigrationNotificationKt.showMigrationNotification$lambda$2(MigrationNotificationKt::showMigrationNotification$lambda$1, arg_0, arg_1))).setImportant(true).setIcon(KotlinIcons.SMALL_LOGO).notify(project);
    }

    private static final StringBuilder appendBr(StringBuilder $this$appendBr, String line) {
        return $this$appendBr.append(line + "<br/>");
    }

    private static final StringBuilder appendIndentBr(StringBuilder $this$appendIndentBr, String line) {
        return MigrationNotificationKt.appendBr($this$appendIndentBr, "&nbsp;&nbsp;" + line);
    }

    private static final Unit showMigrationNotification$lambda$1(AnActionEvent notificationAction, Notification notification) {
        Project project = notificationAction.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project notificationProject = project;
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)notificationProject);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getProjectContext(...)");
        DataContext projectContext = dataContext;
        AnAction migrationAction = ActionManager.getInstance().getAction("KotlinCodeMigration");
        Notification.fire((Notification)notification, (AnAction)migrationAction, (DataContext)projectContext);
        KotlinMigrationProjectFUSCollector.INSTANCE.logRun();
        return Unit.INSTANCE;
    }

    private static final void showMigrationNotification$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

