/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ1\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\r2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSingleNotificationManager;", "T", "Lcom/intellij/notification/Notification;", "", "notify", "", "project", "Lcom/intellij/openapi/project/Project;", "notification", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notification/Notification;)V", "expireOldNotifications", "", "notificationClass", "Lkotlin/reflect/KClass;", "(Lcom/intellij/openapi/project/Project;Lkotlin/reflect/KClass;Lcom/intellij/notification/Notification;)Z", "kotlin.project-configuration"})
public interface KotlinSingleNotificationManager<T extends Notification> {
    default public void notify(@NotNull Project project, @NotNull T notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(notification, (String)"notification");
        if (!this.expireOldNotifications(project, Reflection.getOrCreateKotlinClass(notification.getClass()), notification)) {
            notification.notify(project);
        }
    }

    default public boolean expireOldNotifications(@NotNull Project project, @NotNull KClass<? extends T> notificationClass, @Nullable T notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(notificationClass, (String)"notificationClass");
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        boolean isNotificationExists = false;
        Notification[] notificationArray = notificationsManager.getNotificationsOfType(JvmClassMappingKt.getJavaClass(notificationClass), project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        for (Notification oldNotification : notificationArray) {
            if (Intrinsics.areEqual((Object)oldNotification, notification)) {
                isNotificationExists = true;
                continue;
            }
            Notification notification2 = oldNotification;
            if (notification2 == null) continue;
            notification2.expire();
        }
        return isNotificationExists;
    }

    public static /* synthetic */ boolean expireOldNotifications$default(KotlinSingleNotificationManager kotlinSingleNotificationManager, Project project, KClass kClass, Notification notification, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: expireOldNotifications");
        }
        if ((n & 4) != 0) {
            notification = null;
        }
        return kotlinSingleNotificationManager.expireOldNotifications(project, kClass, notification);
    }
}

