/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.base.util.UiUtils;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerService;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinNotConfiguredSuppressedModulesState;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "kotlin.project-configuration"})
public final class KotlinSetupEnvironmentNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.Companion.is("kotlin.not.configured.show.notification")) {
            return null;
        }
        if (!FileUtils.isKotlinFileType(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile psiFile2 = ktFile2;
        if (psiFile2.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        if (IncompleteModelUtil.isIncompleteModel((PsiElement)((PsiElement)psiFile2))) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (!KotlinProjectConfigurationService.Companion.getInstance(project).shouldShowNotConfiguredDialog(module2)) {
            return null;
        }
        if (!ModuleRootManager.getInstance((Module)module2).getFileIndex().isInSourceContent(file)) {
            return null;
        }
        if (ModuleRootManager.getInstance((Module)module2).getSdk() == null && JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile2))) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createSetupSdkPanel(project, (PsiFile)psiFile2);
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinConfigurationCheckerService configurationChecker = KotlinConfigurationCheckerService.Companion.getInstance(project2);
        if (!configurationChecker.isSyncing() && ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(ModuleSourceRootGroupUtils.toModuleGroup(module2)) && !ConfigureKotlinInProjectUtilsKt.hasKotlinPluginEnabled(module2) && !ConfigureKotlinInProjectUtilsKt.isStdlibModule(module2) && KotlinRuntimeLibraryUtilKt.getLibraryRootsWithIncompatibleAbi(module2).isEmpty()) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createKotlinNotConfiguredPanel(module2, CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(module2)));
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00130\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider$Companion;", "", "<init>", "()V", "createSetupSdkPanel", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "createKotlinNotConfiguredPanel", "module", "Lcom/intellij/openapi/module/Module;", "configurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "apply", "", "createConfiguratorsPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "onConfiguratorApplied", "Lkotlin/Function1;", "kotlin.project-configuration"})
    public static final class Companion {
        private Companion() {
        }

        private final Function<? super FileEditor, ? extends JComponent> createSetupSdkPanel(Project project, PsiFile file) {
            return arg_0 -> Companion.createSetupSdkPanel$lambda$3(project, file, arg_0);
        }

        private final Function<? super FileEditor, ? extends JComponent> createKotlinNotConfiguredPanel(Module module, List<? extends KotlinProjectConfigurator> configurators) {
            return arg_0 -> Companion.createKotlinNotConfiguredPanel$lambda$7(module, configurators, arg_0);
        }

        private final void apply(KotlinProjectConfigurator $this$apply, Project project) {
            $this$apply.configure(project, CollectionsKt.emptyList());
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(project);
        }

        @NotNull
        public final ListPopup createConfiguratorsPopup(@NotNull Project project, @NotNull List<? extends KotlinProjectConfigurator> configurators, @NotNull Function1<? super KotlinProjectConfigurator, Unit> onConfiguratorApplied) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
            Intrinsics.checkNotNullParameter(onConfiguratorApplied, (String)"onConfiguratorApplied");
            String string = KotlinProjectConfigurationBundle.message("title.choose.configurator", new Object[0]);
            BaseListPopupStep<KotlinProjectConfigurator> step2 = new BaseListPopupStep<KotlinProjectConfigurator>(configurators, project, onConfiguratorApplied, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ Function1<KotlinProjectConfigurator, Unit> $onConfiguratorApplied;
                {
                    this.$project = $project;
                    this.$onConfiguratorApplied = $onConfiguratorApplied;
                    super($super_call_param$1, $configurators);
                }

                public String getTextFor(KotlinProjectConfigurator value) {
                    Object object = value;
                    if (object == null || (object = object.getPresentableText()) == null) {
                        object = "<none>";
                    }
                    return object;
                }

                public PopupStep<?> onChosen(KotlinProjectConfigurator selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> createConfiguratorsPopup.step.1.onChosen$lambda$0(selectedValue, this.$project, this.$onConfiguratorApplied));
                }

                private static final void onChosen$lambda$0(KotlinProjectConfigurator $selectedValue, Project $project, Function1 $onConfiguratorApplied) {
                    if ($selectedValue == null) {
                        return;
                    }
                    org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.access$apply(KotlinSetupEnvironmentNotificationProvider.Companion, $selectedValue, $project);
                    $onConfiguratorApplied.invoke((Object)$selectedValue);
                }
            };
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
            return listPopup;
        }

        public static /* synthetic */ ListPopup createConfiguratorsPopup$default(Companion companion, Project project, List list2, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = Companion::createConfiguratorsPopup$lambda$8;
            }
            return companion.createConfiguratorsPopup(project, list2, (Function1<? super KotlinProjectConfigurator, Unit>)function1);
        }

        private static final Unit createSetupSdkPanel$lambda$3$lambda$2$lambda$1$lambda$0(PsiFile $file) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$file));
            if (module != null) {
                ModuleRootModificationUtil.setSdkInherited((Module)module);
            }
            return Unit.INSTANCE;
        }

        private static final void createSetupSdkPanel$lambda$3$lambda$2$lambda$1(Project $project, PsiFile $file) {
            if (ProjectSettingsService.getInstance((Project)$project).chooseAndSetSdk() == null) {
                return;
            }
            ActionsKt.runWriteAction(() -> Companion.createSetupSdkPanel$lambda$3$lambda$2$lambda$1$lambda$0($file));
        }

        private static final EditorNotificationPanel createSetupSdkPanel$lambda$3(Project $project, PsiFile $file, FileEditor fileEditor) {
            EditorNotificationPanel editorNotificationPanel;
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            EditorNotificationPanel $this$createSetupSdkPanel_u24lambda_u243_u24lambda_u242 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            boolean bl = false;
            $this$createSetupSdkPanel_u24lambda_u243_u24lambda_u242.setText(JavaUiBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
            $this$createSetupSdkPanel_u24lambda_u243_u24lambda_u242.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), () -> Companion.createSetupSdkPanel$lambda$3$lambda$2$lambda$1($project, $file));
            return editorNotificationPanel;
        }

        private static final Unit createKotlinNotConfiguredPanel$lambda$7$lambda$6$lambda$4(List $configurators, Project $project, HyperlinkLabel label2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            KotlinProjectConfigurator singleConfigurator = (KotlinProjectConfigurator)CollectionsKt.singleOrNull((List)$configurators);
            if (singleConfigurator != null) {
                Companion.apply(singleConfigurator, $project);
            } else {
                ListPopup configuratorsPopup = org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.createConfiguratorsPopup$default(Companion, $project, $configurators, null, 4, null);
                configuratorsPopup.showUnderneathOf((Component)label2);
            }
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logClickConfigureKtNotification($project);
            return Unit.INSTANCE;
        }

        private static final void createKotlinNotConfiguredPanel$lambda$7$lambda$6$lambda$5(Module $module, Project $project) {
            KotlinNotConfiguredSuppressedModulesState.Companion.suppressConfiguration$kotlin_project_configuration($module);
            EditorNotifications.getInstance((Project)$project).updateAllNotifications();
        }

        private static final EditorNotificationPanel createKotlinNotConfiguredPanel$lambda$7(Module $module, List $configurators, FileEditor fileEditor) {
            EditorNotificationPanel editorNotificationPanel;
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Project project = $module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logShowConfigureKtPanel(project);
            EditorNotificationPanel $this$createKotlinNotConfiguredPanel_u24lambda_u247_u24lambda_u246 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            boolean bl = false;
            $this$createKotlinNotConfiguredPanel_u24lambda_u247_u24lambda_u246.setText(KotlinProjectConfigurationBundle.message("kotlin.not.configured", new Object[0]));
            if (!((Collection)$configurators).isEmpty()) {
                Project project2 = $module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                Project project3 = project2;
                UiUtils.createComponentActionLabel($this$createKotlinNotConfiguredPanel_u24lambda_u247_u24lambda_u246, KotlinProjectConfigurationBundle.message("action.text.configure", new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)arg_0 -> Companion.createKotlinNotConfiguredPanel$lambda$7$lambda$6$lambda$4($configurators, project3, arg_0)));
                $this$createKotlinNotConfiguredPanel_u24lambda_u247_u24lambda_u246.createActionLabel(KotlinProjectConfigurationBundle.message("action.text.ignore", new Object[0]), () -> Companion.createKotlinNotConfiguredPanel$lambda$7$lambda$6$lambda$5($module, project3));
            }
            return editorNotificationPanel;
        }

        private static final Unit createConfiguratorsPopup$lambda$8(KotlinProjectConfigurator it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$apply(Companion $this, KotlinProjectConfigurator $receiver, Project project) {
            $this.apply($receiver, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

