/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaNamedSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\rH\u0002J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/OperatorToFunctionConverter;", "", "<init>", "()V", "replaceExplicitInvokeCallWithImplicit", "Lorg/jetbrains/kotlin/psi/KtExpression;", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "convertUnary", "element", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "convertUnaryWithAssignFix", "convertBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isOfNullableType", "", "expression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/lang/Boolean;", "getCalledFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "convertArrayAccess", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "isAssignmentLeftSide", "convertCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "convert", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "findCallName", "result", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nOperatorToFunctionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorToFunctionConverter.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/OperatorToFunctionConverter\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 4 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 5 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 6 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n123#2:293\n123#2:295\n123#2:383\n25#3:294\n25#3:296\n29#3,7:297\n29#3,7:304\n41#4,2:311\n102#4,2:313\n105#4,5:330\n44#4,3:335\n102#4,8:338\n48#4:346\n41#4,2:347\n102#4,2:349\n105#4,5:366\n44#4,3:371\n102#4,8:374\n48#4:382\n30#5,2:315\n30#5,2:351\n35#6,13:317\n35#6,13:353\n1863#7,2:384\n1#8:386\n*S KotlinDebug\n*F\n+ 1 OperatorToFunctionConverter.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/OperatorToFunctionConverter\n*L\n42#1:293\n45#1:295\n201#1:383\n42#1:294\n47#1:296\n49#1:297,7\n59#1:304,7\n144#1:311,2\n146#1:313,2\n146#1:330,5\n144#1:335,3\n146#1:338,8\n144#1:346\n154#1:347,2\n156#1:349,2\n156#1:366,5\n154#1:371,3\n156#1:374,8\n154#1:382\n147#1:315,2\n157#1:351,2\n147#1:317,13\n157#1:353,13\n224#1:384,2\n*E\n"})
public final class OperatorToFunctionConverter {
    @NotNull
    public static final OperatorToFunctionConverter INSTANCE = new OperatorToFunctionConverter();

    private OperatorToFunctionConverter() {
    }

    @Nullable
    public final KtExpression replaceExplicitInvokeCallWithImplicit(@NotNull KtDotQualifiedExpression qualifiedExpression) {
        KtExpression ktExpression;
        KtExpression selectorInReceiver;
        KtExpression receiverExpression;
        KtCallExpression ktCallExpression;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
                KtExpression $this$safeAs$iv = qualifiedExpression.getSelectorExpression();
                boolean $i$f$safeAs = false;
                KtExpression ktExpression2 = $this$safeAs$iv;
                if (!(ktExpression2 instanceof KtCallExpression)) {
                    ktExpression2 = null;
                }
                if ((ktCallExpression = (KtCallExpression)ktExpression2) == null) break block19;
                PsiElement $this$copied$iv = (PsiElement)ktCallExpression;
                boolean $i$f$copied = false;
                PsiElement psiElement = $this$copied$iv.copy();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                }
                ktCallExpression = (KtCallExpression)((PsiElement)((KtCallExpression)psiElement));
                if (ktCallExpression != null) break block20;
            }
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression3 = callExpression.getCalleeExpression();
        Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        KtNameReferenceExpression calleExpression = (KtNameReferenceExpression)ktExpression3;
        KtExpression $this$safeAs$iv = receiverExpression = qualifiedExpression.getReceiverExpression();
        boolean $i$f$safeAs = false;
        KtExpression ktExpression4 = $this$safeAs$iv;
        if (!(ktExpression4 instanceof KtDotQualifiedExpression)) {
            ktExpression4 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression4;
        Object object = selectorInReceiver = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
        if (selectorInReceiver instanceof KtNameReferenceExpression) {
            PsiElement psiElement;
            PsiElement $this$copied$iv = (PsiElement)selectorInReceiver;
            boolean $i$f$copied = false;
            PsiElement psiElement2 = $this$copied$iv.copy();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
            }
            calleExpression.rawReplace((PsiElement)((KtNameReferenceExpression)psiElement2));
            ((KtNameReferenceExpression)selectorInReceiver).rawReplace((PsiElement)callExpression);
            PsiElement $this$replaced$iv = (PsiElement)qualifiedExpression;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)receiverExpression))) {
                psiElement = (PsiElement)receiverExpression;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)receiverExpression);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression5 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression5;
                }
            }
            ktExpression = (KtExpression)psiElement;
        } else {
            PsiElement psiElement;
            PsiElement psiElement3 = (receiverExpression instanceof KtCallExpression || receiverExpression instanceof KtDotQualifiedExpression) && callExpression.getValueArgumentList() == null && callExpression.getTypeArgumentList() == null ? calleExpression.replace((PsiElement)receiverExpression) : calleExpression.rawReplace((PsiElement)receiverExpression);
            PsiElement $this$replaced$iv = (PsiElement)qualifiedExpression;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)callExpression))) {
                psiElement = (PsiElement)callExpression;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)callExpression);
                if (result$iv instanceof KtCallExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression6 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                    }
                    psiElement = (PsiElement)((KtCallExpression)ktExpression6);
                }
            }
            ktExpression = (KtExpression)psiElement;
        }
        return ktExpression;
    }

    private final KtExpression convertUnary(KtUnaryExpression element) {
        Name name2;
        IElementType iElementType = element.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS)) {
            return this.convertUnaryWithAssignFix(element);
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS)) {
            name2 = OperatorNameConventions.UNARY_PLUS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS)) {
            name2 = OperatorNameConventions.UNARY_MINUS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCL)) {
            name2 = OperatorNameConventions.NOT;
        } else {
            return (KtExpression)element;
        }
        Name operatorName = name2;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)element.getBaseExpression());
        objectArray[1] = operatorName;
        KtExpression transformed = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0.$1()", (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement psiElement = element.replace((PsiElement)transformed);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return (KtExpression)psiElement;
    }

    private final KtExpression convertUnaryWithAssignFix(KtUnaryExpression element) {
        Name name2;
        IElementType iElementType = element.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS)) {
            name2 = OperatorNameConventions.INC;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS)) {
            name2 = OperatorNameConventions.DEC;
        } else {
            return (KtExpression)element;
        }
        Name operatorName = name2;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)element.getBaseExpression());
        objectArray[1] = operatorName;
        KtExpression transformed = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 = $0.$1()", (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement psiElement = element.replace((PsiElement)transformed);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return (KtExpression)psiElement;
    }

    private final KtExpression convertBinary(KtBinaryExpression element) {
        String string;
        IElementType op = element.getOperationReference().getReferencedNameElementType();
        KtExpression ktExpression = element.getLeft();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = element.getRight();
        Intrinsics.checkNotNull((Object)ktExpression2);
        KtExpression right = ktExpression2;
        if (Intrinsics.areEqual((Object)op, (Object)KtTokens.EQ)) {
            if (left instanceof KtArrayAccessExpression) {
                this.convertArrayAccess((KtArrayAccessExpression)left);
            }
            return (KtExpression)element;
        }
        Name name2 = this.getCalledFunctionName(element);
        String functionName = name2 != null ? name2.asString() : null;
        Boolean receiverIsNullable = this.isOfNullableType(left);
        IElementType iElementType = op;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS)) {
            string = "$0.plus($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS)) {
            string = "$0.minus($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL)) {
            string = "$0.times($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIV)) {
            string = "$0.div($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERC)) {
            string = "$0.rem($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE)) {
            string = "$0.rangeTo($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE_UNTIL)) {
            string = "$0.rangeUntil($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD)) {
            string = "$1.contains($0)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN)) {
            string = "!$1.contains($0)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            string = Intrinsics.areEqual((Object)functionName, (Object)"plusAssign") ? "$0.plusAssign($1)" : "$0 = $0.plus($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            string = Intrinsics.areEqual((Object)functionName, (Object)"minusAssign") ? "$0.minusAssign($1)" : "$0 = $0.minus($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            string = Intrinsics.areEqual((Object)functionName, (Object)"timesAssign") ? "$0.timesAssign($1)" : "$0 = $0.times($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            string = Intrinsics.areEqual((Object)functionName, (Object)"divAssign") ? "$0.divAssign($1)" : "$0 = $0.div($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            boolean remSupported = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element).supportsFeature(LanguageFeature.OperatorRem);
            string = remSupported && Intrinsics.areEqual((Object)functionName, (Object)"remAssign") ? "$0.remAssign($1)" : (Intrinsics.areEqual((Object)functionName, (Object)"modAssign") ? "$0.modAssign($1)" : (remSupported ? "$0 = $0.rem($1)" : "$0 = $0.mod($1)"));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            string = !Intrinsics.areEqual((Object)receiverIsNullable, (Object)false) ? "$0?.equals($1) ?: ($1 == null)" : "$0.equals($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            string = !Intrinsics.areEqual((Object)receiverIsNullable, (Object)false) ? "!($0?.equals($1) ?: ($1 == null))" : "!$0.equals($1)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            string = "$0.compareTo($1) > 0";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            string = "$0.compareTo($1) < 0";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            string = "$0.compareTo($1) >= 0";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            string = "$0.compareTo($1) <= 0";
        } else {
            return (KtExpression)element;
        }
        String pattern2 = string;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{left, right};
        KtExpression transformed = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)pattern2, (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement psiElement = element.replace((PsiElement)transformed);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return (KtExpression)psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Boolean isOfNullableType(KtExpression expression) {
        Object object;
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            boolean $i$f$allowAnalysisFromWriteAction = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv2 = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv2.isAnalysisAllowedInWriteAction()) {
                Object lock$iv$iv;
                void this_$iv$iv;
                boolean bl2 = false;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
                try {
                    Boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22;
                    Object object2 = lock$iv$iv = new Object();
                    synchronized (object2) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22 = false;
                        KaSession $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                        boolean bl3 = false;
                        KaType kaType = $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.getExpressionType(expression);
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22 = kaType != null ? Boolean.valueOf($this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.isMarkedNullable(kaType)) : null;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                }
                object = lock$iv$iv;
                return object;
            }
            permissionRegistry$iv2.setAnalysisAllowedInWriteAction(true);
            try {
                Object lock$iv$iv;
                boolean $i$a$-allowAnalysisFromWriteAction-OperatorToFunctionConverter$isOfNullableType$1$22 = false;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze3 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
                try {
                    Boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32;
                    Object object3 = lock$iv$iv = new Object();
                    synchronized (object3) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32 = false;
                        KaSession $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                        boolean bl4 = false;
                        KaType kaType = $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.getExpressionType(expression);
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32 = kaType != null ? Boolean.valueOf($this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.isMarkedNullable(kaType)) : null;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                }
                Object $i$a$-allowAnalysisFromWriteAction-OperatorToFunctionConverter$isOfNullableType$1$22 = lock$iv$iv;
                object = $i$a$-allowAnalysisFromWriteAction-OperatorToFunctionConverter$isOfNullableType$1$22;
                return object;
            }
            finally {
                permissionRegistry$iv2.setAnalysisAllowedInWriteAction(false);
            }
        }
        permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
        try {
            Object object4;
            boolean bl = false;
            boolean $i$f$allowAnalysisFromWriteAction = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv3 = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv3.isAnalysisAllowedInWriteAction()) {
                Object lock$iv$iv;
                boolean bl5 = false;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze4 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
                try {
                    Boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42;
                    Object object5 = lock$iv$iv = new Object();
                    synchronized (object5) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42 = false;
                        KaSession $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                        boolean bl6 = false;
                        KaType kaType = $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.getExpressionType(expression);
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42 = kaType != null ? Boolean.valueOf($this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.isMarkedNullable(kaType)) : null;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                }
                object4 = lock$iv$iv;
            } else {
                permissionRegistry$iv3.setAnalysisAllowedInWriteAction(true);
                try {
                    Boolean bl7;
                    boolean bl8 = false;
                    boolean $i$f$analyze = false;
                    Project project = ((KtElement)expression).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                    boolean $i$f$analyze5 = false;
                    KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
                    this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
                    try {
                        Boolean bl9;
                        Object lock$iv$iv;
                        Object object6 = lock$iv$iv = new Object();
                        synchronized (object6) {
                            boolean bl10 = false;
                            KaSession $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl11 = false;
                            KaType kaType = $this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.getExpressionType(expression);
                            bl9 = kaType != null ? Boolean.valueOf($this$isOfNullableType_u24lambda_u242_u24lambda_u241_u24lambda_u240.isMarkedNullable(kaType)) : null;
                        }
                        bl7 = bl9;
                    }
                    finally {
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                    }
                    Boolean bl12 = bl7;
                    object4 = bl12;
                }
                finally {
                    permissionRegistry$iv3.setAnalysisAllowedInWriteAction(false);
                }
            }
            Object object7 = object4;
            object = object7;
            return object;
        }
        finally {
            permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Name getCalledFunctionName(KtBinaryExpression element) {
        Object object;
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            boolean $i$f$allowAnalysisFromWriteAction = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv2 = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv2.isAnalysisAllowedInWriteAction()) {
                Object lock$iv$iv;
                void this_$iv$iv;
                boolean bl2 = false;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)element);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)element);
                try {
                    Name $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22;
                    Object object2 = lock$iv$iv = new Object();
                    synchronized (object2) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22 = false;
                        KaSession $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243 = analysisSession$iv$iv;
                        boolean bl3 = false;
                        KaCallInfo kaCallInfo = $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243.resolveToCall((KtElement)element);
                        KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.singleFunctionCallOrNull(kaCallInfo) : null;
                        KaFunctionCall<?> kaFunctionCall2 = kaFunctionCall;
                        KaFunctionSymbol targetSymbol = kaFunctionCall2 != null && (kaFunctionCall2 = kaFunctionCall2.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaFunctionCall2) : null;
                        KaNamedSymbol kaNamedSymbol = targetSymbol instanceof KaNamedSymbol ? (KaNamedSymbol)((Object)targetSymbol) : null;
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22 = kaNamedSymbol != null ? kaNamedSymbol.getName() : null;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)element);
                }
                object = lock$iv$iv;
                return object;
            }
            permissionRegistry$iv2.setAnalysisAllowedInWriteAction(true);
            try {
                Object lock$iv$iv;
                boolean $i$a$-allowAnalysisFromWriteAction-OperatorToFunctionConverter$getCalledFunctionName$1$22 = false;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze3 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)element);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)element);
                try {
                    Name $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32;
                    Object object3 = lock$iv$iv = new Object();
                    synchronized (object3) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32 = false;
                        KaSession $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243 = analysisSession$iv$iv;
                        boolean bl4 = false;
                        KaCallInfo kaCallInfo = $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243.resolveToCall((KtElement)element);
                        KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.singleFunctionCallOrNull(kaCallInfo) : null;
                        KaFunctionCall<?> kaFunctionCall3 = kaFunctionCall;
                        KaFunctionSymbol targetSymbol = kaFunctionCall3 != null && (kaFunctionCall3 = kaFunctionCall3.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaFunctionCall3) : null;
                        KaNamedSymbol kaNamedSymbol = targetSymbol instanceof KaNamedSymbol ? (KaNamedSymbol)((Object)targetSymbol) : null;
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32 = kaNamedSymbol != null ? kaNamedSymbol.getName() : null;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv32;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)element);
                }
                Object $i$a$-allowAnalysisFromWriteAction-OperatorToFunctionConverter$getCalledFunctionName$1$22 = lock$iv$iv;
                object = $i$a$-allowAnalysisFromWriteAction-OperatorToFunctionConverter$getCalledFunctionName$1$22;
                return object;
            }
            finally {
                permissionRegistry$iv2.setAnalysisAllowedInWriteAction(false);
            }
        }
        permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
        try {
            Object object4;
            boolean bl = false;
            boolean $i$f$allowAnalysisFromWriteAction = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv3 = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv3.isAnalysisAllowedInWriteAction()) {
                Object lock$iv$iv;
                boolean bl5 = false;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze4 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)element);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)element);
                try {
                    Name $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42;
                    Object object5 = lock$iv$iv = new Object();
                    synchronized (object5) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42 = false;
                        KaSession $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243 = analysisSession$iv$iv;
                        boolean bl6 = false;
                        KaCallInfo kaCallInfo = $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243.resolveToCall((KtElement)element);
                        KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.singleFunctionCallOrNull(kaCallInfo) : null;
                        KaFunctionCall<?> kaFunctionCall4 = kaFunctionCall;
                        KaFunctionSymbol targetSymbol = kaFunctionCall4 != null && (kaFunctionCall4 = kaFunctionCall4.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaFunctionCall4) : null;
                        KaNamedSymbol kaNamedSymbol = targetSymbol instanceof KaNamedSymbol ? (KaNamedSymbol)((Object)targetSymbol) : null;
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42 = kaNamedSymbol != null ? kaNamedSymbol.getName() : null;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv42;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)element);
                }
                object4 = lock$iv$iv;
            } else {
                permissionRegistry$iv3.setAnalysisAllowedInWriteAction(true);
                try {
                    Name name2;
                    boolean bl7 = false;
                    boolean $i$f$analyze = false;
                    Project project = ((KtElement)element).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                    boolean $i$f$analyze5 = false;
                    KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)element);
                    this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)element);
                    try {
                        Name name3;
                        Object lock$iv$iv;
                        Object object6 = lock$iv$iv = new Object();
                        synchronized (object6) {
                            boolean bl8 = false;
                            KaSession $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243 = analysisSession$iv$iv;
                            boolean bl9 = false;
                            KaCallInfo kaCallInfo = $this$getCalledFunctionName_u24lambda_u245_u24lambda_u244_u24lambda_u243.resolveToCall((KtElement)element);
                            KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.singleFunctionCallOrNull(kaCallInfo) : null;
                            KaFunctionCall<?> kaFunctionCall5 = kaFunctionCall;
                            KaFunctionSymbol targetSymbol = kaFunctionCall5 != null && (kaFunctionCall5 = kaFunctionCall5.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaFunctionCall5) : null;
                            KaNamedSymbol kaNamedSymbol = targetSymbol instanceof KaNamedSymbol ? (KaNamedSymbol)((Object)targetSymbol) : null;
                            name3 = kaNamedSymbol != null ? kaNamedSymbol.getName() : null;
                        }
                        name2 = name3;
                    }
                    finally {
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)element);
                    }
                    Name name4 = name2;
                    object4 = name4;
                }
                finally {
                    permissionRegistry$iv3.setAnalysisAllowedInWriteAction(false);
                }
            }
            Object object7 = object4;
            object = object7;
            return object;
        }
        finally {
            permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
        }
    }

    private final KtExpression convertArrayAccess(KtArrayAccessExpression element) {
        Ref.ObjectRef expressionToReplace = new Ref.ObjectRef();
        expressionToReplace.element = element;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression transformed = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> OperatorToFunctionConverter.convertArrayAccess$lambda$6(element, expressionToReplace, arg_0), (int)1, null);
        PsiElement psiElement = ((KtExpression)expressionToReplace.element).replace((PsiElement)transformed);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return (KtExpression)psiElement;
    }

    private final boolean isAssignmentLeftSide(KtArrayAccessExpression element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationReference().getReferencedNameElementType(), (Object)KtTokens.EQ) && Intrinsics.areEqual((Object)element, (Object)((KtBinaryExpression)parent2).getLeft());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtExpression convertCall(KtCallExpression element) {
        v0 = element.getCalleeExpression();
        Intrinsics.checkNotNull((Object)v0);
        callee = v0;
        v1 = element.getParent();
        if (v1 == null) ** GOTO lbl-1000
        $this$safeAs$iv = v1;
        $i$f$safeAs = false;
        v2 = $this$safeAs$iv;
        if (!(v2 instanceof KtQualifiedExpression)) {
            v2 = null;
        }
        if ((v1 = (KtQualifiedExpression)v2) != null) {
            v3 = v1.getReceiverExpression();
        } else lbl-1000:
        // 2 sources

        {
            v3 = receiver = null;
        }
        if (receiver == null) ** GOTO lbl-1000
        $this$safeAs$iv = KotlinPsiUtils.safeDeparenthesize(callee);
        v4 = $this$safeAs$iv instanceof KtNamedFunction != false ? (KtNamedFunction)$this$safeAs$iv : null;
        if ((v4 != null ? v4.getReceiverTypeReference() : null) != null) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        isAnonymousFunctionWithReceiver = v5;
        isLambdaWithReceiver = receiver != null && KotlinPsiUtils.safeDeparenthesize(callee) instanceof KtLambdaExpression != false;
        argumentsList = element.getValueArgumentList();
        v6 /* !! */  = argumentsList;
        if (v6 /* !! */  == null || (v6 /* !! */  = v6 /* !! */ .getText()) == null || (v6 /* !! */  = StringsKt.removeSurrounding((String)v6 /* !! */ , (CharSequence)"(", (CharSequence)")")) == null) {
            v6 /* !! */  = argumentString /* !! */  = "";
        }
        if (isAnonymousFunctionWithReceiver) {
            v7 = receiver.getText();
            if (v7 == null) {
                v7 = "";
            }
            delimiter = ((CharSequence)(receiverText = v7)).length() > 0 != false && ((CharSequence)argumentString /* !! */ ).length() > 0 != false ? ", " : "";
            v8 /* !! */  = receiverText + delimiter + (String)argumentString /* !! */ ;
        } else {
            v8 /* !! */  = argumentString /* !! */ ;
        }
        argumentsWithReceiverIfNeeded /* !! */  = v8 /* !! */ ;
        v9 = element.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getLambdaArguments(...)");
        funcLitArgs = v9;
        calleeText = callee.getText();
        transformation = calleeText + "." + OperatorNameConventions.INVOKE.asString() + "(" + (String)argumentsWithReceiverIfNeeded /* !! */  + ")";
        v10 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getProject(...)");
        factory = new KtPsiFactory(v10, false, 2, null);
        transformed = factory.createExpression(transformation);
        v11 = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)transformed));
        var15_15 = v11 != null ? v11.getParent() : null;
        v12 = callExpression = var15_15 instanceof KtCallExpression != false ? (KtCallExpression)var15_15 : null;
        if (callExpression != null && ((Collection)funcLitArgs).isEmpty() == false) {
            $this$forEach$iv = funcLitArgs;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (KtLambdaArgument)element$iv;
                $i$a$-forEach-OperatorToFunctionConverter$convertCall$1 = false;
                callExpression.add((PsiElement)it);
            }
            if (((CharSequence)argumentsWithReceiverIfNeeded /* !! */ ).length() == 0) {
                v13 = callExpression.getValueArgumentList();
                if (v13 != null) {
                    v13.delete();
                }
            }
        }
        parent = element.getParent();
        if (!isAnonymousFunctionWithReceiver && !isLambdaWithReceiver && parent instanceof KtDotQualifiedExpression) {
            v14 = ((KtDotQualifiedExpression)parent).replace((PsiElement)factory.createExpression(((KtDotQualifiedExpression)parent).getReceiverExpression().getText() + "." + transformed.getText()));
            Intrinsics.checkNotNull((Object)v14, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            dotExpression = (KtDotQualifiedExpression)v14;
            v15 = dotExpression.getSelectorExpression();
            Intrinsics.checkNotNull((Object)v15, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            return v15;
        }
        elementToReplace = isAnonymousFunctionWithReceiver != false || isLambdaWithReceiver != false ? element.getParent() : (PsiElement)element;
        v16 = elementToReplace.replace((PsiElement)transformed);
        Intrinsics.checkNotNull((Object)v16, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return (KtExpression)v16;
    }

    @NotNull
    public final Pair<KtExpression, KtSimpleNameExpression> convert(@NotNull KtExpression element) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression elementToBeReplaced = element;
        if (element instanceof KtArrayAccessExpression && this.isAssignmentLeftSide((KtArrayAccessExpression)element)) {
            PsiElement psiElement = ((KtArrayAccessExpression)element).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            elementToBeReplaced = (KtExpression)psiElement;
        }
        CommentSaver commentSaver = new CommentSaver((PsiElement)elementToBeReplaced, true);
        KtExpression ktExpression2 = element;
        if (ktExpression2 instanceof KtUnaryExpression) {
            ktExpression = this.convertUnary((KtUnaryExpression)element);
        } else if (ktExpression2 instanceof KtBinaryExpression) {
            ktExpression = this.convertBinary((KtBinaryExpression)element);
        } else if (ktExpression2 instanceof KtArrayAccessExpression) {
            ktExpression = this.convertArrayAccess((KtArrayAccessExpression)element);
        } else if (ktExpression2 instanceof KtCallExpression) {
            ktExpression = this.convertCall((KtCallExpression)element);
        } else {
            throw new IllegalArgumentException(element.toString());
        }
        KtExpression result2 = ktExpression;
        CommentSaver.restore$default(commentSaver, (PsiElement)result2, false, 2, null);
        KtSimpleNameExpression ktSimpleNameExpression = this.findCallName(result2);
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(("No call name found in " + result2.getText()).toString());
        }
        KtSimpleNameExpression callName = ktSimpleNameExpression;
        return TuplesKt.to((Object)result2, (Object)callName);
    }

    private final KtSimpleNameExpression findCallName(KtExpression result2) {
        KtSimpleNameExpression ktSimpleNameExpression;
        KtExpression ktExpression = result2;
        if (ktExpression instanceof KtBinaryExpression) {
            if (KtPsiUtil.isAssignment((PsiElement)((PsiElement)result2))) {
                KtExpression ktExpression2 = ((KtBinaryExpression)result2).getRight();
                Intrinsics.checkNotNull((Object)ktExpression2);
                ktSimpleNameExpression = this.findCallName(ktExpression2);
            } else {
                KtExpression ktExpression3 = ((KtBinaryExpression)result2).getLeft();
                Intrinsics.checkNotNull((Object)ktExpression3);
                ktSimpleNameExpression = this.findCallName(ktExpression3);
            }
        } else if (ktExpression instanceof KtUnaryExpression) {
            KtExpression ktExpression4 = ((KtUnaryExpression)result2).getBaseExpression();
            if (ktExpression4 != null) {
                KtExpression it = ktExpression4;
                boolean bl = false;
                ktSimpleNameExpression = INSTANCE.findCallName(it);
            } else {
                ktSimpleNameExpression = null;
            }
        } else if (ktExpression instanceof KtParenthesizedExpression) {
            KtExpression ktExpression5 = ((KtParenthesizedExpression)result2).getExpression();
            if (ktExpression5 != null) {
                KtExpression it = ktExpression5;
                boolean bl = false;
                ktSimpleNameExpression = INSTANCE.findCallName(it);
            } else {
                ktSimpleNameExpression = null;
            }
        } else {
            ktSimpleNameExpression = (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)result2));
        }
        return ktSimpleNameExpression;
    }

    private static final Unit convertArrayAccess$lambda$6(KtArrayAccessExpression $element, Ref.ObjectRef $expressionToReplace, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        $this$buildExpression.appendExpression($element.getArrayExpression());
        $this$buildExpression.appendFixedText(".");
        if (INSTANCE.isAssignmentLeftSide($element)) {
            PsiElement parent2 = $element.getParent();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            $expressionToReplace.element = (KtBinaryExpression)parent2;
            $this$buildExpression.appendFixedText("set(");
            List list2 = $element.getIndexExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIndexExpressions(...)");
            BuilderByPattern.appendExpressions$default((BuilderByPattern)$this$buildExpression, (Iterable)list2, null, (int)2, null);
            $this$buildExpression.appendFixedText(",");
            v1 = $this$buildExpression.appendExpression(((KtBinaryExpression)parent2).getRight());
        } else {
            $this$buildExpression.appendFixedText("get(");
            List list3 = $element.getIndexExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getIndexExpressions(...)");
            v1 = BuilderByPattern.appendExpressions$default((BuilderByPattern)$this$buildExpression, (Iterable)list3, null, (int)2, null);
        }
        $this$buildExpression.appendFixedText(")");
        return Unit.INSTANCE;
    }
}

