/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.ApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.OperatorToFunctionConverter;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.references.ReferenceAccess;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001b\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000fH\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0014H\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0019H\u0002J\u0019\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u001bH\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J-\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0014\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/OperatorToFunctionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "<init>", "()V", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lkotlin/Unit;", "isApplicableUnary", "", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtUnaryExpression;)Z", "isUsedAsExpression", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "parentIsUsedAsExpression", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiElement;)Z", "isApplicableBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isApplicableArrayAccess", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "isApplicableCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Z", "getFamilyName", "", "invoke", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nOperatorToFunctionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorToFunctionIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/OperatorToFunctionIntention\n+ 2 ApplicabilityRange.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicators/ApplicabilityRange\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ContextProvider.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicable/ContextProviderKt\n*L\n1#1,127:1\n28#2:128\n1557#3:129\n1628#3,3:130\n2632#3,3:134\n45#4:133\n*S KotlinDebug\n*F\n+ 1 OperatorToFunctionIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/OperatorToFunctionIntention\n*L\n25#1:128\n25#1:129\n25#1:130,3\n97#1:134,3\n59#1:133\n*E\n"})
public final class OperatorToFunctionIntention
extends KotlinApplicableModCommandAction<KtExpression, Unit> {
    public OperatorToFunctionIntention() {
        super(Reflection.getOrCreateKotlinClass(KtExpression.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtExpression element) {
        void $this$mapTo$iv$iv$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ApplicabilityRange this_$iv = ApplicabilityRange.INSTANCE;
        boolean $i$f$multiple = false;
        KtExpression expression = (KtExpression)((PsiElement)element);
        boolean bl = false;
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtUnaryExpression) {
            list2 = CollectionsKt.listOf((Object)((KtUnaryExpression)expression).getOperationReference());
        } else if (ktExpression instanceof KtBinaryExpression) {
            list2 = CollectionsKt.listOf((Object)((KtBinaryExpression)expression).getOperationReference());
        } else if (ktExpression instanceof KtArrayAccessExpression) {
            lbrace = ((KtArrayAccessExpression)expression).getLeftBracket();
            PsiElement rbrace = ((KtArrayAccessExpression)expression).getRightBracket();
            if (lbrace == null || rbrace == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                Object[] objectArray = new PsiElement[]{lbrace, rbrace};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (ktExpression instanceof KtCallExpression) {
            UserDataHolder userDataHolder;
            KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression).getValueArgumentList();
            if (ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.getLeftParenthesis()) != null) {
                userDataHolder = (UserDataHolder)ktValueArgumentList;
            } else {
                List list3 = ((KtCallExpression)expression).getLambdaArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getLambdaArguments(...)");
                KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list3);
                userDataHolder = (UserDataHolder)(ktLambdaArgument != null && (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) != null ? ktLambdaArgument.getLeftCurlyBrace() : null);
            }
            lbrace = userDataHolder;
            list2 = CollectionsKt.listOfNotNull((Object)lbrace);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            PsiElement psiElement = (PsiElement)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl2 = false;
            collection.add(TextRangeUtilsKt.textRangeIn((PsiElement)it$iv, (PsiElement)element));
        }
        return (List)destination$iv$iv$iv;
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element;
        boolean $this$asUnit$iv = ktExpression instanceof KtUnaryExpression ? this.isApplicableUnary($this$prepareContext, (KtUnaryExpression)element) : (ktExpression instanceof KtBinaryExpression ? this.isApplicableBinary((KtBinaryExpression)element) : (ktExpression instanceof KtArrayAccessExpression ? this.isApplicableArrayAccess((KtArrayAccessExpression)element) : (ktExpression instanceof KtCallExpression ? this.isApplicableCall($this$prepareContext, (KtCallExpression)element) : false)));
        boolean $i$f$getAsUnit = false;
        return $this$asUnit$iv ? Unit.INSTANCE : null;
    }

    private final boolean isApplicableUnary(KaSession $context_receiver_0, KtUnaryExpression element) {
        if (element.getBaseExpression() == null) {
            return false;
        }
        KtSimpleNameExpression ktSimpleNameExpression = element.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
        KtSimpleNameExpression opRef = ktSimpleNameExpression;
        IElementType iElementType = opRef.getReferencedNameElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCL) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS) ? !this.isUsedAsExpression($context_receiver_0, (KtExpression)element) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUsedAsExpression(KaSession $context_receiver_0, KtExpression element) {
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof KtBlockExpression) {
            if (!Intrinsics.areEqual((Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)parent2)), (Object)element)) return false;
            PsiElement psiElement = ((KtBlockExpression)parent2).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            if (!this.parentIsUsedAsExpression($context_receiver_0, psiElement)) return false;
            return true;
        }
        Intrinsics.checkNotNull((Object)parent2);
        boolean bl = this.parentIsUsedAsExpression($context_receiver_0, parent2);
        return bl;
    }

    private final boolean parentIsUsedAsExpression(KaSession $context_receiver_0, PsiElement element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof KtLoopExpression || parent2 instanceof KtFile ? false : (parent2 instanceof KtIfExpression || parent2 instanceof KtWhenExpression ? $context_receiver_0.isUsedAsExpression((KtExpression)parent2) : true);
    }

    private final boolean isApplicableBinary(KtBinaryExpression element) {
        boolean bl;
        block8: {
            if (element.getLeft() == null || element.getRight() == null) {
                return false;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
            KtOperationReferenceExpression opRef = ktOperationReferenceExpression;
            IElementType iElementType = opRef.getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERC) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE_UNTIL) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                Object[] objectArray = new KtExpression[]{element.getLeft(), element.getRight()};
                Iterable $this$none$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtExpression it = (KtExpression)element$iv;
                        boolean bl2 = false;
                        KtExpression ktExpression = it;
                        if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ktExpression.getNode()) != null ? ktExpression.getElementType() : null), (Object)KtNodeTypes.NULL)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            } else {
                bl = Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ) ? element.getLeft() instanceof KtArrayAccessExpression : false;
            }
        }
        return bl;
    }

    private final boolean isApplicableArrayAccess(KtArrayAccessExpression element) {
        ReferenceAccess access = ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)element), (boolean)true);
        return access != ReferenceAccess.READ_WRITE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicableCall(KaSession $context_receiver_0, KtCallExpression element) {
        if (!Intrinsics.areEqual((Object)AnalysisUtilsKt.isImplicitInvokeCall($context_receiver_0, element), (Object)true)) return false;
        if (element.getValueArgumentList() != null) return true;
        List list2 = element.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        if (((Collection)list2).isEmpty()) return false;
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.overloaded.operator.with.function.call", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtExpression element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        OperatorToFunctionConverter.INSTANCE.convert(element);
    }
}

