/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.RemoveRedundantBackticksQuickFix;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.utils.RedundantBackticksCheckerKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveRedundantBackticksInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "registerProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.code-insight.inspections.shared"})
public final class RemoveRedundantBackticksInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(this, holder2){
            final /* synthetic */ RemoveRedundantBackticksInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitKtElement(KtElement element) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitKtElement(element);
                ASTNode[] aSTNodeArray = SharedImplUtil.getChildrenOfType((ASTNode)element.getNode(), (IElementType)((IElementType)KtTokens.IDENTIFIER));
                Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildrenOfType(...)");
                Object[] objectArray = aSTNodeArray;
                RemoveRedundantBackticksInspection removeRedundantBackticksInspection = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!RedundantBackticksCheckerKt.isRedundantBackticks(it)) continue;
                    PsiElement psiElement = it.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                    RemoveRedundantBackticksInspection.access$registerProblem(removeRedundantBackticksInspection, problemsHolder, psiElement);
                }
            }
        };
    }

    private final void registerProblem(ProblemsHolder holder2, PsiElement element) {
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveRedundantBackticksQuickFix()};
        holder2.registerProblem(element, KotlinBundle.message((String)"remove.redundant.backticks.quick.fix.text", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
    }

    public static final /* synthetic */ void access$registerProblem(RemoveRedundantBackticksInspection $this, ProblemsHolder holder2, PsiElement element) {
        $this.registerProblem(holder2, element);
    }
}

