/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleSourceInfoBase;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KaSourceModuleKind;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinModificationTrackerProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoKt;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@K1ModeProjectStructureApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010&\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/TrackableModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/ModuleSourceInfoBase;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "expectedBy", "", "getExpectedBy", "()Ljava/util/List;", "displayedName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayedName", "()Ljava/lang/String;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "checkValidity", "", "sourceModuleKind", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KaSourceModuleKind;", "getSourceModuleKind", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/KaSourceModuleKind;", "kotlin.base.project-structure"})
public interface ModuleSourceInfo
extends org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo,
IdeaModuleInfo,
TrackableModuleInfo,
ModuleSourceInfoBase {
    @Override
    @NotNull
    public Module getModule();

    @NotNull
    public List<ModuleSourceInfo> getExpectedBy();

    @NotNull
    default public String getDisplayedName() {
        String string = this.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    default public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.MODULE;
    }

    @Override
    @NotNull
    default public Project getProject() {
        Project project = this.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @NotNull
    default public TargetPlatform getPlatform() {
        return TargetPlatformDetectorUtils.getPlatform(this.getModule());
    }

    @NotNull
    default public PlatformDependentAnalyzerServices getAnalyzerServices() {
        TargetPlatform targetPlatform = this.getPlatform();
        Project project = this.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return PlatformAnalyzerServicesUtils.findAnalyzerServices(targetPlatform, project);
    }

    @NotNull
    default public ModificationTracker createModificationTracker() {
        Project project = this.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KotlinModificationTrackerProvider.Companion.getInstance(project).createModuleModificationTracker(this.getModule());
    }

    @Override
    default public void checkValidity() {
        ModuleSourceInfoKt.checkValidity(this.getModule());
    }

    @NotNull
    public KaSourceModuleKind getSourceModuleKind();
}

