/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.CombinableSourceAndClassRootsScope;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.PoweredLibraryScopeBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0013\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryWithoutSourceScope;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/PoweredLibraryScopeBase;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/CombinableSourceAndClassRootsScope;", "project", "Lcom/intellij/openapi/project/Project;", "topPackageNames", "", "", "entriesVirtualFileSystems", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;Lcom/intellij/openapi/roots/libraries/Library;)V", "getFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "roots", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "getRoots", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "modules", "Lcom/intellij/openapi/module/Module;", "getModules", "()Ljava/util/Set;", "includesLibraryClassRoots", "", "getIncludesLibraryClassRoots", "()Z", "includesLibrarySourceRoots", "getIncludesLibrarySourceRoots", "equals", "other", "", "calcHashCode", "", "toString", "kotlin.base.project-structure"})
final class LibraryWithoutSourceScope
extends PoweredLibraryScopeBase
implements CombinableSourceAndClassRootsScope {
    @NotNull
    private final Library library;

    public LibraryWithoutSourceScope(@NotNull Project project, @Nullable Set<String> topPackageNames, @Nullable Set<? extends NewVirtualFileSystem> entriesVirtualFileSystems, @NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        super(project, virtualFileArray, VirtualFile.EMPTY_ARRAY, topPackageNames, entriesVirtualFileSystems);
        this.library = library;
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.myIndex.getClassRootForFile(file);
    }

    @Override
    @NotNull
    public Object2IntMap<VirtualFile> getRoots() {
        Object2IntMap object2IntMap = this.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)object2IntMap, (String)"getEntries(...)");
        return object2IntMap;
    }

    @Override
    @NotNull
    public Set<Module> getModules() {
        return SetsKt.emptySet();
    }

    @Override
    public boolean getIncludesLibraryClassRoots() {
        return true;
    }

    @Override
    public boolean getIncludesLibrarySourceRoots() {
        return false;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LibraryWithoutSourceScope && Intrinsics.areEqual((Object)this.library, (Object)((LibraryWithoutSourceScope)other).library);
    }

    public int calcHashCode() {
        return this.library.hashCode();
    }

    @NotNull
    public String toString() {
        return "LibraryWithoutSourceScope(" + this.library + ")";
    }
}

