/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.ProjectStructureProviderIdeImplKt;
import org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations.KotlinForwardDeclarationsFileOwnerTracker;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/forwardDeclarations/KotlinModuleInfoBasedForwardDeclarationsFileOwnerTrackerImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/forwardDeclarations/KotlinForwardDeclarationsFileOwnerTracker;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "getFileOwner", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "virtualFile", "registerFileOwner", "", "owner", "libraryInfosRemoved", "libraryInfos", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "dispose", "kotlin.base.project-structure"})
@ApiStatus.Internal
public final class KotlinModuleInfoBasedForwardDeclarationsFileOwnerTrackerImpl
implements KotlinForwardDeclarationsFileOwnerTracker,
LibraryInfoListener,
Disposable {
    @NotNull
    private final Map<VirtualFile, IdeaModuleInfo> cache;

    public KotlinModuleInfoBasedForwardDeclarationsFileOwnerTrackerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.cache = new ConcurrentHashMap();
        project.getMessageBus().connect((Disposable)this).subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
    }

    @Override
    @Nullable
    public KaModule getFileOwner(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        IdeaModuleInfo ideaModuleInfo = this.cache.get(virtualFile);
        return ideaModuleInfo != null ? ProjectStructureProviderIdeImplKt.toKaModule(ideaModuleInfo) : null;
    }

    @Override
    public void registerFileOwner(@NotNull VirtualFile virtualFile, @NotNull KaModule owner) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.cache.put(virtualFile, KotlinProjectStructureUtils.getModuleInfo(owner));
    }

    @Override
    public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
        Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
        this.cache.values().removeAll(libraryInfos);
    }

    public void dispose() {
    }
}

