/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.GlobalStorageEntitySource;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.platforms.KLibUtils;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCacheKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.JvmLibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmIdePlatformKind;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Service(value={Service.Level.PROJECT})
@K1ModeProjectStructureApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "libraryInfoCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache;", "get", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "key", "Lcom/intellij/openapi/roots/libraries/Library;", "deduplicatedLibrary", "beforeWorkspaceModelChanged", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "dispose", "removedLibraryInfoTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "values", "", "LibraryInfoInnerCache", "Companion", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nLibraryInfoCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryInfoCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,422:1\n1#2:423\n*E\n"})
public final class LibraryInfoCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryInfoInnerCache libraryInfoCache;

    public LibraryInfoCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.libraryInfoCache = new LibraryInfoInnerCache(project);
        Disposer.register((Disposable)this, (Disposable)this.libraryInfoCache);
    }

    @NotNull
    public final List<LibraryInfo> get(@NotNull Library key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(key instanceof LibraryEx)) {
            boolean bl = false;
            String string = "Library '" + key.getPresentableName() + "' does not implement LibraryEx which is not expected";
            throw new IllegalArgumentException(string.toString());
        }
        return this.libraryInfoCache.get((LibraryEx)key);
    }

    @NotNull
    public final Library deduplicatedLibrary(@NotNull Library key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Library)((LibraryInfo)kotlin.collections.CollectionsKt.first(this.get(key))).getLibrary();
    }

    @ApiStatus.Internal
    public final void beforeWorkspaceModelChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.libraryInfoCache.beforeWorkspaceModelChanged(event);
    }

    public void dispose() {
    }

    @NotNull
    public final ModificationTracker removedLibraryInfoTracker() {
        return (ModificationTracker)this.libraryInfoCache.getRemovedLibraryInfoTracker();
    }

    @NotNull
    public final Collection<List<LibraryInfo>> values() {
        return this.libraryInfoCache.values();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nLibraryInfoCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryInfoCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,422:1\n31#2,2:423\n*S KotlinDebug\n*F\n+ 1 LibraryInfoCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$Companion\n*L\n386#1:423,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryInfoCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LibraryInfoCache> serviceClass$iv = LibraryInfoCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LibraryInfoCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0010\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0016H\u0014J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0018\u001a\u00020\u0002H\u0096\u0002J(\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u00022\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0002J@\u0010\u001b\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J:\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\f\u0010\u001f\u001a\u00020\u000f*\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J*\u0010!\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J*\u0010\"\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\"\u0010#\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0016H\u0014J*\u0010$\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J<\u0010%\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030'H\u0014J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0016\u0010)\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u001e\u0010+\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J<\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0016H\u0014JX\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u001e\u00103\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0004042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000406H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00100\u001a\u00020\u0002H\u0002J\u000e\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR6\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u000ej\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "removedLibraryInfoTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "getRemovedLibraryInfoTracker", "()Lcom/intellij/openapi/util/SimpleModificationTracker;", "deduplicationCache", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "subscribe", "", "doInvalidate", "cache", "", "get", "key", "getCachedOrPutNewValue", "newValue", "addEntryToCache", "root", "value", "cachedDeduplicatedValue", "firstRoot", "checkKeyValidity", "checkKeyConsistency", "checkCacheConsistency", "additionalEntitiesCheck", "disposeIllegalEntry", "disposeEntry", "entry", "", "dropDisposedKey", "checkValueValidity", "calculate", "postProcessNewValue", "doInvalidateKeysAndGetOutdatedValues", "", "keys", "createLibraryInfos", "library", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "klibLibraryInfoFactory", "Lkotlin/Function3;", "metadataLibraryInfoFactory", "Lkotlin/Function2;", "getPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "beforeWorkspaceModelChanged", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nLibraryInfoCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryInfoCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 WorkspaceEntityChangeListener.kt\norg/jetbrains/kotlin/idea/base/util/caching/WorkspaceEntityChangeListenerKt\n*L\n1#1,422:1\n1#2:423\n1#2:454\n1#2:478\n1#2:500\n381#3,7:424\n381#3,7:437\n1863#4,2:431\n1485#4:433\n1510#4,3:434\n1513#4,3:444\n1619#4:452\n1863#4:453\n1864#4:455\n1620#4:456\n1611#4,9:457\n1863#4:466\n808#4,11:467\n1864#4:479\n1620#4:480\n1202#4,2:481\n1230#4,4:483\n1619#4:487\n1863#4:488\n808#4,11:489\n1864#4:501\n1620#4:502\n1202#4,2:503\n1230#4,4:505\n1557#4:509\n1628#4,3:510\n3829#5:447\n4344#5,2:448\n111#6:450\n111#6:451\n*S KotlinDebug\n*F\n+ 1 LibraryInfoCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache\n*L\n333#1:454\n339#1:478\n343#1:500\n141#1:424,7\n269#1:437,7\n246#1:431,2\n269#1:433\n269#1:434,3\n269#1:444,3\n333#1:452\n333#1:453\n333#1:455\n333#1:456\n339#1:457,9\n339#1:466\n340#1:467,11\n339#1:479\n339#1:480\n341#1:481,2\n341#1:483,4\n343#1:487\n343#1:488\n344#1:489,11\n343#1:501\n343#1:502\n345#1:503,2\n345#1:505,4\n357#1:509\n357#1:510,3\n302#1:447\n302#1:448,2\n327#1:450\n328#1:451\n*E\n"})
    private static final class LibraryInfoInnerCache
    extends SynchronizedFineGrainedEntityCache<LibraryEx, List<? extends LibraryInfo>> {
        @NotNull
        private final SimpleModificationTracker removedLibraryInfoTracker;
        @NotNull
        private final HashMap<String, List<LibraryEx>> deduplicationCache;

        public LibraryInfoInnerCache(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, false, false, 6, null);
            this.removedLibraryInfoTracker = new SimpleModificationTracker();
            this.deduplicationCache = new HashMap();
            this.initialize();
        }

        @NotNull
        public final SimpleModificationTracker getRemovedLibraryInfoTracker() {
            return this.removedLibraryInfoTracker;
        }

        @Override
        protected void subscribe() {
        }

        @Override
        protected void doInvalidate(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            super.doInvalidate(cache2);
            this.deduplicationCache.clear();
        }

        @Override
        @NotNull
        public List<LibraryInfo> get(@NotNull LibraryEx key) {
            List<LibraryInfo> list2;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ThreadingAssertions.softAssertReadAccess();
            this.checkKeyAndDisposeIllegalEntry(key);
            List<LibraryInfo> list3 = this.getCachedOrPutNewValue(key, null);
            if (list3 != null) {
                List<LibraryInfo> it = list3;
                boolean bl = false;
                return it;
            }
            ProgressManager.checkCanceled();
            List<LibraryInfo> newValue = this.calculate(key);
            if (FineGrainedEntityCache.Companion.isValidityChecksEnabled()) {
                this.checkValueValidity(newValue);
            }
            if ((list2 = this.getCachedOrPutNewValue(key, newValue)) != null) {
                List<LibraryInfo> it = list2;
                boolean bl = false;
                return it;
            }
            this.postProcessNewValue(key, newValue);
            return newValue;
        }

        private final List<LibraryInfo> getCachedOrPutNewValue(LibraryEx key, List<? extends LibraryInfo> newValue) {
            return (List)this.useCache(arg_0 -> LibraryInfoInnerCache.getCachedOrPutNewValue$lambda$3(this, key, newValue, arg_0));
        }

        private final void addEntryToCache(Map<LibraryEx, List<LibraryInfo>> cache2, LibraryEx key, String root, List<? extends LibraryInfo> value) {
            Object object;
            cache2.put(key, value);
            Map $this$getOrPut$iv = this.deduplicationCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(root);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(root, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(key);
        }

        private final List<LibraryInfo> cachedDeduplicatedValue(Map<LibraryEx, List<LibraryInfo>> cache2, LibraryEx key, String root) {
            Object v0;
            Map keyUrlsByType;
            List<LibraryEx> deduplicatedLibraries;
            block4: {
                deduplicatedLibraries = this.deduplicationCache.get(root);
                Collection collection = deduplicatedLibraries;
                if (collection == null || collection.isEmpty()) {
                    return null;
                }
                keyUrlsByType = LibraryInfoCacheKt.access$urlsByType(key);
                Iterable iterable = deduplicatedLibraries;
                for (Object t : iterable) {
                    LibraryEx it = (LibraryEx)t;
                    boolean bl = false;
                    if (!LibraryInfoCacheKt.access$rootEquals(keyUrlsByType, it)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            LibraryEx libraryEx = v0;
            if (libraryEx == null) {
                return null;
            }
            LibraryEx deduplicatedLibrary = libraryEx;
            List<LibraryInfo> cachedValue2 = cache2.get(deduplicatedLibrary);
            if (cachedValue2 == null) {
                KotlinExceptionWithAttachments exception = new KotlinExceptionWithAttachments(StringsKt.trimIndent((String)("\n                        inconsistent state:\n                        is the same key: " + (deduplicatedLibrary == key) + "\n                        root consistent: " + Intrinsics.areEqual((Object)this.firstRoot(key), (Object)root) + "\n                        urls consistent: " + Intrinsics.areEqual((Object)LibraryInfoCacheKt.access$urlsByType(key), (Object)keyUrlsByType) + "\n                        key name: " + key.getPresentableName() + "\n                        deduplicated key name: " + deduplicatedLibrary.getPresentableName() + "\n                    "))).withAttachment("key.txt", (Object)key.toString()).withAttachment("deduplicated.txt", (Object)deduplicatedLibrary.toString()).withAttachment("librariesBefore.txt", (Object)kotlin.collections.CollectionsKt.joinToString$default((Iterable)deduplicatedLibraries, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                ((Collection)deduplicatedLibraries).remove(deduplicatedLibrary);
                exception.withAttachment("librariesAfter.txt", (Object)kotlin.collections.CollectionsKt.joinToString$default((Iterable)deduplicatedLibraries, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                this.getLogger().error((Throwable)exception);
                return this.cachedDeduplicatedValue(cache2, key, root);
            }
            return cachedValue2;
        }

        private final String firstRoot(LibraryEx $this$firstRoot) {
            String[] stringArray = $this$firstRoot.getUrls(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
            String string = (String)ArraysKt.firstOrNull((Object[])stringArray);
            if (string == null) {
                string = "";
            }
            return string;
        }

        @Override
        protected void checkKeyValidity(@NotNull LibraryEx key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            LibraryInfoCacheKt.checkValidity((Library)key);
        }

        @Override
        protected void checkKeyConsistency(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2, @NotNull LibraryEx key) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super.checkKeyConsistency(cache2, key);
            this.checkCacheConsistency(cache2, key);
        }

        private final void checkCacheConsistency(Map<LibraryEx, List<LibraryInfo>> cache2, LibraryEx key) {
            boolean isDeduplicated;
            boolean isCached = cache2.containsKey(key);
            List<LibraryEx> list2 = this.deduplicationCache.get(this.firstRoot(key));
            boolean bl = list2 != null ? list2.contains(key) : (isDeduplicated = false);
            if (isCached != isDeduplicated) {
                throw new IllegalStateException(("inconsistent state " + key.getPresentableName() + ": is cached: " + isCached + ", is deduplicated: " + isDeduplicated).toString());
            }
        }

        @Override
        protected void additionalEntitiesCheck(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Iterator<List<LibraryEx>> iterator = this.deduplicationCache.values().iterator();
            while (iterator.hasNext()) {
                List<LibraryEx> values2;
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                Iterator<LibraryEx> iterator2 = values2.iterator();
                while (iterator2.hasNext()) {
                    LibraryEx library = iterator2.next();
                    try {
                        this.checkCacheConsistency(cache2, library);
                    }
                    catch (Throwable e) {
                        iterator2.remove();
                        cache2.remove(library);
                        this.getLogger().error(e);
                    }
                }
            }
        }

        @Override
        protected void disposeIllegalEntry(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2, @NotNull LibraryEx key) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super.disposeIllegalEntry(cache2, key);
            this.dropDisposedKey(key);
        }

        @Override
        protected void disposeEntry(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2, @NotNull Map.Entry<LibraryEx, List<LibraryInfo>> entry) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            this.dropDisposedKey(entry.getKey());
            LibraryEx libInfoKey = ((LibraryInfo)kotlin.collections.CollectionsKt.first(entry.getValue())).getLibrary();
            if (Intrinsics.areEqual((Object)libInfoKey, (Object)entry.getKey())) {
                return;
            }
            Iterator<Map.Entry<LibraryEx, List<LibraryInfo>>> iterator = cache2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<LibraryEx, List<LibraryInfo>> cacheEntry = iterator.next();
                if (!Intrinsics.areEqual((Object)((LibraryInfo)kotlin.collections.CollectionsKt.first(cacheEntry.getValue())).getLibrary(), (Object)libInfoKey)) continue;
                iterator.remove();
                this.dropDisposedKey(cacheEntry.getKey());
            }
        }

        private final void dropDisposedKey(LibraryEx key) {
            Iterator<List<LibraryEx>> iterator = this.deduplicationCache.values().iterator();
            while (iterator.hasNext()) {
                List<LibraryEx> values2;
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                if (!values2.remove(key)) continue;
                break;
            }
        }

        @Override
        protected void checkValueValidity(@NotNull List<? extends LibraryInfo> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Iterable $this$forEach$iv = value;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryInfo p0 = (LibraryInfo)element$iv;
                boolean bl = false;
                p0.checkValidity();
            }
        }

        @Override
        @NotNull
        public List<LibraryInfo> calculate(@NotNull LibraryEx key) {
            List<LibraryInfo> list2;
            List<LibraryInfo> list3;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            IdePlatformKind platformKind = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)this.getPlatform(key));
            if (platformKind instanceof JvmIdePlatformKind) {
                list3 = kotlin.collections.CollectionsKt.listOf((Object)new JvmLibraryInfo(this.getProject(), key));
            } else if (platformKind instanceof CommonIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.1.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.2.INSTANCE));
            } else if (platformKind instanceof JsIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.3.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.4.INSTANCE));
            } else if (platformKind instanceof WasmIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.5.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.6.INSTANCE));
            } else if (platformKind instanceof NativeIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.7.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.8.INSTANCE));
            } else {
                throw new IllegalStateException(("Unexpected platform kind: " + platformKind).toString());
            }
            List<LibraryInfo> it = list2 = list3;
            boolean bl = false;
            if (!(!((Collection)it).isEmpty())) {
                boolean bl2 = false;
                String string = "Must be not empty for consistency with LibraryInfoCache#deduplicatedLibrary";
                throw new IllegalArgumentException(string.toString());
            }
            return list2;
        }

        @Override
        public void postProcessNewValue(@NotNull LibraryEx key, @NotNull List<? extends LibraryInfo> value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            ((LibraryInfoListener)this.getProject().getMessageBus().syncPublisher(LibraryInfoListener.Companion.getTOPIC())).libraryInfosAdded((Collection<? extends LibraryInfo>)value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Collection<List<LibraryInfo>> doInvalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends LibraryEx> keys, @NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
            Object $this$getOrPut$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            List outdatedValues = new ArrayList();
            Iterable $this$groupBy$iv = keys;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                LibraryEx it = (LibraryEx)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = this.firstRoot(it);
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groupBy = destination$iv$iv;
            for (Map.Entry entry : groupBy.entrySet()) {
                List<LibraryEx> deduplicatedLibraries;
                String root = (String)entry.getKey();
                List invalidatedLibraries = (List)entry.getValue();
                if (this.deduplicationCache.get(root) == null || deduplicatedLibraries.isEmpty()) continue;
                deduplicatedLibraries.removeAll(invalidatedLibraries);
                for (LibraryEx invalidatedLibrary : invalidatedLibraries) {
                    Object object = cache2.remove(invalidatedLibrary);
                    if (object == null) continue;
                    Object it = $this$getOrPut$iv$iv$iv = object;
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)((LibraryInfo)kotlin.collections.CollectionsKt.first((List)it)).getLibrary(), (Object)invalidatedLibrary) ? $this$getOrPut$iv$iv$iv : null;
                    if (object == null) {
                        continue;
                    }
                    List<LibraryInfo> anchorInfo = object;
                    ((Collection)outdatedValues).add(anchorInfo);
                    if (deduplicatedLibraries.isEmpty()) continue;
                    Map invalidatedLibraryUrlsByType = LibraryInfoCacheKt.access$urlsByType(invalidatedLibrary);
                    Iterator<LibraryEx> deduplicatedLibrariesIterator = deduplicatedLibraries.iterator();
                    while (deduplicatedLibrariesIterator.hasNext()) {
                        LibraryEx deduplicatedLibrary = deduplicatedLibrariesIterator.next();
                        if (!LibraryInfoCacheKt.access$rootEquals(invalidatedLibraryUrlsByType, deduplicatedLibrary)) continue;
                        deduplicatedLibrariesIterator.remove();
                        cache2.remove(deduplicatedLibrary);
                    }
                }
            }
            return outdatedValues;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LibraryInfo> createLibraryInfos(LibraryEx library, IdePlatformKind platformKind, Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo> klibLibraryInfoFactory, Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo> metadataLibraryInfoFactory) {
            ArrayList<Object> arrayList;
            void $this$filterTo$iv$iv;
            TargetPlatform defaultPlatform = platformKind.getDefaultPlatform();
            VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!KLibUtils.isKlibLibraryRootForPlatform(it, defaultPlatform)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List klibFiles = (List)destination$iv$iv;
            if (klibFiles.isEmpty()) {
                return kotlin.collections.CollectionsKt.listOf((Object)metadataLibraryInfoFactory.invoke((Object)this.getProject(), (Object)library));
            }
            ArrayList<Object> $this$createLibraryInfos_u24lambda_u2411 = arrayList = new ArrayList<Object>(klibFiles.size());
            boolean bl = false;
            for (VirtualFile file : klibFiles) {
                String path2;
                if (PathUtil.getLocalPath((VirtualFile)file) == null) continue;
                $this$createLibraryInfos_u24lambda_u2411.add(klibLibraryInfoFactory.invoke((Object)this.getProject(), (Object)library, (Object)path2));
            }
            return arrayList;
        }

        private final TargetPlatform getPlatform(LibraryEx library) {
            return !library.isDisposed() ? KotlinLibraryKindKt.getPlatform(KotlinLibraryKindKt.detectLibraryKind((Library)library, this.getProject())) : JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        }

        /*
         * WARNING - void declaration
         */
        public final void beforeWorkspaceModelChanged(@NotNull VersionedStorageChange event) {
            Iterable libraryBridge;
            void $this$associateByTo$iv$iv;
            void $this$mapNotNullTo$iv;
            Object object;
            void $this$associateByTo$iv$iv2;
            Object element$iv$iv$iv;
            LibraryEntity it;
            void $this$mapNotNullTo$iv2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ImmutableEntityStorage storageBefore = event.getStorageBefore();
            VersionedStorageChange $this$getChanges$iv = event;
            boolean $i$f$getChanges = false;
            List libraryChanges = $this$getChanges$iv.getChanges(LibraryEntity.class);
            VersionedStorageChange $this$getChanges$iv2 = event;
            boolean $i$f$getChanges232 = false;
            List moduleChanges = $this$getChanges$iv2.getChanges(ModuleEntity.class);
            if (kotlin.collections.CollectionsKt.none((Iterable)libraryChanges) && kotlin.collections.CollectionsKt.none((Iterable)moduleChanges)) {
                return;
            }
            Iterable $i$f$getChanges232 = libraryChanges;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void var9_12 = $this$mapNotNullTo$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = var9_12.iterator();
            while (iterator.hasNext()) {
                Library it$iv;
                LibraryEntity oldEntity;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                EntityChange it2 = (EntityChange)element$iv;
                boolean bl2 = false;
                WorkspaceEntity workspaceEntity = it2.getOldEntity();
                it = (LibraryEntity)workspaceEntity;
                boolean bl3 = false;
                LibraryEntity libraryEntity = it;
                LibraryEntity libraryEntity2 = oldEntity = (LibraryEntity)(!((libraryEntity != null ? libraryEntity.getEntitySource() : null) instanceof GlobalStorageEntitySource) ? workspaceEntity : null);
                if ((libraryEntity2 != null ? LibraryEntityUtils.findLibraryBridge((LibraryEntity)libraryEntity2, (EntityStorage)((EntityStorage)storageBefore)) : null) == null) continue;
                it$iv = it$iv;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
            List outdatedLibraries = kotlin.collections.CollectionsKt.toMutableList((Collection)destination$iv);
            Iterable $this$mapNotNull$iv = moduleChanges;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<List> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            Iterable $this$forEach$iv$iv$iv = iterable;
            boolean $i$f$forEach2 = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                List list2;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl5 = false;
                it = (EntityChange)element$iv$iv;
                boolean bl6 = false;
                Object object2 = (ModuleEntity)it.getOldEntity();
                if (object2 != null && (object2 = object2.getDependencies()) != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = (Iterable)object2;
                    boolean $i$f$filterIsInstance2 = false;
                    Iterable bl4 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv2 instanceof LibraryDependency)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = null;
                }
                if (list2 == null) continue;
                List it$iv$iv = list2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$associateBy$iv = kotlin.collections.CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            boolean $i$f$associateBy232 = false;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(n);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                void it2;
                element$iv$iv$iv = (LibraryDependency)element$iv$iv;
                object = destination$iv$iv3;
                boolean bl8 = false;
                object.put(it2.getLibrary(), element$iv$iv);
            }
            Map oldLibDependencies = destination$iv$iv3;
            Iterable $i$f$associateBy232 = moduleChanges;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo3 = false;
            Iterable $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
            boolean $i$f$forEach3 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv2) {
                List list3;
                Object element$iv = element$iv$iv;
                boolean bl9 = false;
                EntityChange it3 = (EntityChange)element$iv;
                boolean bl10 = false;
                Object object3 = (ModuleEntity)it3.getNewEntity();
                if (object3 != null && (object3 = object3.getDependencies()) != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = (Iterable)object3;
                    boolean $i$f$filterIsInstance = false;
                    Iterable $i$f$filterIsInstance2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv3 instanceof LibraryDependency)) continue;
                        destination$iv$iv4.add(element$iv$iv3);
                    }
                    list3 = (List)destination$iv$iv4;
                } else {
                    list3 = null;
                }
                if (list3 == null) continue;
                List it$iv = list3;
                boolean bl11 = false;
                collection.add(it$iv);
            }
            Iterable $this$associateBy$iv2 = kotlin.collections.CollectionsKt.flatten((Iterable)collection);
            boolean bl2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
            $this$forEach$iv$iv2 = $this$associateBy$iv2;
            Map destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it4;
                LibraryDependency bl9 = (LibraryDependency)element$iv$iv;
                object = destination$iv$iv5;
                boolean bl12 = false;
                object.put(it4.getLibrary(), element$iv$iv);
            }
            Map newLibDependencies = destination$iv$iv5;
            for (Map.Entry entry : oldLibDependencies.entrySet()) {
                LibraryDependency value;
                destination$iv$iv5 = entry.getValue();
                LibraryDependency it5 = (LibraryDependency)destination$iv$iv5;
                boolean bl13 = false;
                if ((LibraryDependency)(!(it5.getLibrary().getTableId() instanceof LibraryTableId.GlobalLibraryTableId) ? destination$iv$iv5 : null) == null || Intrinsics.areEqual((Object)value, newLibDependencies.get(entry.getKey()))) continue;
                libraryBridge = LibraryEntityUtils.findLibraryBridge((LibraryId)value.getLibrary(), (EntityStorage)((EntityStorage)storageBefore), (Project)this.getProject());
                CollectionsKt.addIfNotNull((Collection)outdatedLibraries, (Object)libraryBridge);
            }
            if (!((Collection)outdatedLibraries).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable iterable2 = outdatedLibraries;
                object = this;
                boolean $i$f$map = false;
                libraryBridge = iterable2;
                Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    Library it4 = (Library)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl14 = false;
                    Intrinsics.checkNotNull((Object)it3, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
                    collection2.add((LibraryEx)it3);
                }
                HashSet droppedLibraryInfos = (HashSet)AddToStdlibKt.flattenTo((Iterable)FineGrainedEntityCache.invalidateKeysAndGetOutdatedValues$default((FineGrainedEntityCache)object, (List)destination$iv$iv2, null, 2, null), (Collection)new HashSet());
                if (!((Collection)droppedLibraryInfos).isEmpty()) {
                    this.removedLibraryInfoTracker.incModificationCount();
                    ((LibraryInfoListener)this.getProject().getMessageBus().syncPublisher(LibraryInfoListener.Companion.getTOPIC())).libraryInfosRemoved(droppedLibraryInfos);
                }
            }
        }

        private static final List getCachedOrPutNewValue$lambda$3(LibraryInfoInnerCache this$0, LibraryEx $key, List $newValue, Map cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            this$0.checkEntitiesIfRequired(cache2);
            List list2 = (List)cache2.get($key);
            if (list2 != null) {
                List it = list2;
                boolean bl = false;
                return it;
            }
            String root = this$0.firstRoot($key);
            List deduplicatedValue = this$0.cachedDeduplicatedValue(cache2, $key, root);
            List list3 = deduplicatedValue;
            if (list3 == null && (list3 = $newValue) == null) {
                return null;
            }
            List resultValue = list3;
            this$0.addEntryToCache(cache2, $key, root, resultValue);
            return deduplicatedValue;
        }
    }
}

