/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.plugin.artifacts;

import com.intellij.util.io.Decompressor;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.io.File;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0002R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/LazyZipUnpacker;", "Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer;", "Ljava/io/File;", "", "destination", "<init>", "(Ljava/io/File;)V", "produceOutput", "", "input", "computationContext", "(Ljava/io/File;Lkotlin/Unit;)Ljava/util/List;", "updateMessageDigestWithInput", "messageDigest", "Ljava/security/MessageDigest;", "buffer", "", "lazyUnpack", "zip", "getUnpackedIfUpToDateOrNull", "kotlin.base.plugin"})
@SourceDebugExtension(value={"SMAP\nLazyZipUnpacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyZipUnpacker.kt\norg/jetbrains/kotlin/idea/base/plugin/artifacts/LazyZipUnpacker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public final class LazyZipUnpacker
extends AbstractLazyFileOutputProducer<File, Unit> {
    @NotNull
    private final File destination;

    public LazyZipUnpacker(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        String string = LazyZipUnpacker.class.getName();
        String string2 = destination.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
        super(string + "-" + DigestUtilKt.hashToHexString((String)string2, (MessageDigest)DigestUtil.md5()));
        this.destination = destination;
    }

    @Override
    @NotNull
    protected List<File> produceOutput(@NotNull File input, @NotNull Unit computationContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)computationContext, (String)"computationContext");
        FilesKt.deleteRecursively((File)this.destination);
        new Decompressor.Zip(input).extract(this.destination);
        if (!this.destination.isDirectory()) {
            throw new IllegalStateException("Check failed.");
        }
        return CollectionsKt.listOf((Object)this.destination);
    }

    @Override
    protected void updateMessageDigestWithInput(@NotNull MessageDigest messageDigest, @NotNull File input, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Path path2 = input.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        DigestUtil.updateContentHash((MessageDigest)messageDigest, (Path)path2, (byte[])buffer);
    }

    @NotNull
    public final File lazyUnpack(@NotNull File zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        File file = (File)CollectionsKt.singleOrNull(this.lazyProduceOutput(zip, Unit.INSTANCE));
        if (file == null) {
            throw new IllegalStateException("produceOutput returns only single element".toString());
        }
        return file;
    }

    @Nullable
    public final File getUnpackedIfUpToDateOrNull(@NotNull File zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Collection collection = this.getOutputIfUpToDateOrEmpty(zip);
        if (collection.isEmpty()) {
            boolean bl = false;
            return null;
        }
        File file = (File)CollectionsKt.singleOrNull((List)((List)collection));
        if (file == null) {
            throw new IllegalStateException("produceOutput returns only single element".toString());
        }
        return file;
    }
}

