/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.idea.base.platforms.IdePlatformKindProjectStructure;
import org.jetbrains.kotlin.idea.base.platforms.KLibUtils;
import org.jetbrains.kotlin.idea.base.platforms.KotlinCommonLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmEffectiveLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinNativeLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmJsLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmWasiLibraryKind;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmJsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmWasiIdePlatformKind;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms;
import org.jetbrains.kotlin.utils.PathUtil;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\b\u001a\u00020\tJ%\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getLibraryVersionProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getLibrary", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "pattern", "Ljava/util/regex/Pattern;", "([Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/regex/Pattern;)Lcom/intellij/openapi/vfs/VirtualFile;", "getLibraryKlibVersion", "library", "klibPattern", "getLibraryJarVersion", "jarPattern", "Companion", "kotlin.base.platforms"})
@SourceDebugExtension(value={"SMAP\nIdePlatformKindProjectStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,111:1\n1310#2,2:112\n*S KotlinDebug\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure\n*L\n56#1:112,2\n*E\n"})
public final class IdePlatformKindProjectStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Pattern KOTLIN_STDLIB_COMMON_KLIB_PATTERN;
    @NotNull
    private static final Map<String, IdePlatformKind> PLATFORM_EXTENSIONS;

    public IdePlatformKindProjectStructure(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final CommonCompilerArguments getCompilerArguments(@NotNull IdePlatformKind platformKind) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
        IdePlatformKind idePlatformKind = platformKind;
        if (idePlatformKind instanceof CommonIdePlatformKind) {
            commonCompilerArguments = null;
        } else if (idePlatformKind instanceof JvmIdePlatformKind) {
            commonCompilerArguments = (CommonCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings();
        } else if (idePlatformKind instanceof JsIdePlatformKind) {
            commonCompilerArguments = (CommonCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings();
        } else if (idePlatformKind instanceof WasmIdePlatformKind) {
            commonCompilerArguments = (CommonCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings();
        } else if (idePlatformKind instanceof NativeIdePlatformKind) {
            commonCompilerArguments = null;
        } else {
            throw new IllegalStateException(("Unsupported platform kind: " + platformKind).toString());
        }
        return commonCompilerArguments;
    }

    @NotNull
    public final Function1<Library, IdeKotlinVersion> getLibraryVersionProvider(@NotNull IdePlatformKind platformKind) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
        IdePlatformKind idePlatformKind = platformKind;
        if (idePlatformKind instanceof CommonIdePlatformKind) {
            function1 = arg_0 -> IdePlatformKindProjectStructure.getLibraryVersionProvider$lambda$0(this, arg_0);
        } else if (idePlatformKind instanceof JvmIdePlatformKind) {
            function1 = arg_0 -> IdePlatformKindProjectStructure.getLibraryVersionProvider$lambda$1(this, arg_0);
        } else if (idePlatformKind instanceof JsIdePlatformKind) {
            function1 = arg_0 -> IdePlatformKindProjectStructure.getLibraryVersionProvider$lambda$2(this, arg_0);
        } else if (idePlatformKind instanceof WasmIdePlatformKind || idePlatformKind instanceof NativeIdePlatformKind) {
            function1 = getLibraryVersionProvider.4.INSTANCE;
        } else {
            throw new IllegalStateException(("Unsupported platform kind: " + platformKind).toString());
        }
        return function1;
    }

    private final VirtualFile getLibrary(VirtualFile[] roots, Pattern pattern2) {
        VirtualFile virtualFile;
        block1: {
            VirtualFile[] $this$firstOrNull$iv = roots;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$firstOrNull$iv[j];
                boolean bl = false;
                if (!pattern2.matcher(it.getName()).matches()) continue;
                virtualFile = element$iv;
                break block1;
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    private final IdeKotlinVersion getLibraryKlibVersion(Library library, Pattern klibPattern) {
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile virtualFile = this.getLibrary(virtualFileArray, klibPattern);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile libraryKlib = virtualFile;
        return IdeKotlinVersion.Companion.fromKLibManifest(libraryKlib);
    }

    private final IdeKotlinVersion getLibraryJarVersion(Library library, Pattern jarPattern) {
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile virtualFile = this.getLibrary(virtualFileArray, jarPattern);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile libraryJar = virtualFile;
        return IdeKotlinVersion.Companion.fromManifest(libraryJar);
    }

    private static final IdeKotlinVersion getLibraryVersionProvider$lambda$0(IdePlatformKindProjectStructure this$0, Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        IdeKotlinVersion ideKotlinVersion = this$0.getLibraryKlibVersion(library, KOTLIN_STDLIB_COMMON_KLIB_PATTERN);
        if (ideKotlinVersion == null) {
            ideKotlinVersion = this$0.getLibraryJarVersion(library, PathUtil.INSTANCE.getKOTLIN_STDLIB_COMMON_JAR_PATTERN());
        }
        return ideKotlinVersion;
    }

    private static final IdeKotlinVersion getLibraryVersionProvider$lambda$1(IdePlatformKindProjectStructure this$0, Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return this$0.getLibraryJarVersion(library, PathUtil.KOTLIN_RUNTIME_JAR_PATTERN);
    }

    private static final IdeKotlinVersion getLibraryVersionProvider$lambda$2(IdePlatformKindProjectStructure this$0, Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return KotlinJavaScriptStdlibDetectorFacility.INSTANCE.getStdlibVersion(this$0.project, library);
    }

    @JvmStatic
    @NotNull
    public static final IdePlatformKindProjectStructure getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Pattern pattern2 = Pattern.compile(".*kotlin-stdlib-.*common.*\\.klib");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        KOTLIN_STDLIB_COMMON_KLIB_PATTERN = pattern2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin_metadata", (Object)CommonIdePlatformKind.INSTANCE), TuplesKt.to((Object)"js", (Object)JsIdePlatformKind.INSTANCE), TuplesKt.to((Object)"kjsm", (Object)JsIdePlatformKind.INSTANCE)};
        PLATFORM_EXTENSIONS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure$Companion;", "", "<init>", "()V", "KOTLIN_STDLIB_COMMON_KLIB_PATTERN", "Ljava/util/regex/Pattern;", "getInstance", "Lorg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure;", "project", "Lcom/intellij/openapi/project/Project;", "PLATFORM_EXTENSIONS", "", "", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getLibraryPlatformKind", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLibraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "platformKind", "kotlin.base.platforms"})
    @SourceDebugExtension(value={"SMAP\nIdePlatformKindProjectStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n31#2,2:112\n1#3:114\n*S KotlinDebug\n*F\n+ 1 IdePlatformKindProjectStructure.kt\norg/jetbrains/kotlin/idea/base/platforms/IdePlatformKindProjectStructure$Companion\n*L\n73#1:112,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdePlatformKindProjectStructure getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<IdePlatformKindProjectStructure> serviceClass$iv = IdePlatformKindProjectStructure.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (IdePlatformKindProjectStructure)object;
        }

        @Nullable
        public final IdePlatformKind getLibraryPlatformKind(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            IdePlatformKind idePlatformKind = (IdePlatformKind)PLATFORM_EXTENSIONS.get(file.getExtension());
            if (idePlatformKind != null) {
                IdePlatformKind it = idePlatformKind;
                boolean bl = false;
                return it;
            }
            if (!KLibUtils.isKLibRootCandidate(file)) {
                return null;
            }
            return KLibUtils.isKlibLibraryRootForPlatform(file, CommonPlatforms.INSTANCE.getDefaultCommonPlatform()) ? (IdePlatformKind)CommonIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file, JsPlatforms.INSTANCE.getDefaultJsPlatform()) ? (IdePlatformKind)JsIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file, WasmPlatforms.INSTANCE.getWasmWasi()) ? (IdePlatformKind)WasmWasiIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file, WasmPlatforms.INSTANCE.getWasmJs()) ? (IdePlatformKind)WasmJsIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file, WasmPlatforms.INSTANCE.getUnspecifiedWasmPlatform()) ? (IdePlatformKind)WasmJsIdePlatformKind.INSTANCE : (KLibUtils.isKlibLibraryRootForPlatform(file, NativePlatforms.INSTANCE.getUnspecifiedNativePlatform()) ? (IdePlatformKind)NativeIdePlatformKind.INSTANCE : null)))));
        }

        @NotNull
        public final PersistentLibraryKind<?> getLibraryKind(@NotNull IdePlatformKind platformKind) {
            PersistentLibraryKind persistentLibraryKind;
            Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
            IdePlatformKind idePlatformKind = platformKind;
            if (idePlatformKind instanceof CommonIdePlatformKind) {
                persistentLibraryKind = KotlinCommonLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof JvmIdePlatformKind) {
                persistentLibraryKind = KotlinJvmEffectiveLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof JsIdePlatformKind) {
                persistentLibraryKind = KotlinJavaScriptLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof WasmJsIdePlatformKind) {
                persistentLibraryKind = KotlinWasmJsLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof WasmWasiIdePlatformKind) {
                persistentLibraryKind = KotlinWasmWasiLibraryKind.INSTANCE;
            } else if (idePlatformKind instanceof NativeIdePlatformKind) {
                persistentLibraryKind = KotlinNativeLibraryKind.INSTANCE;
            } else {
                throw new IllegalStateException(("Unsupported platform kind: " + platformKind).toString());
            }
            return persistentLibraryKind;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

