/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library.KaLibraryEntityBasedLibraryModuleBase;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library.KaLibraryModuleBase;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.librarySource.KaLibrarySourceModuleImpl;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.provider.InternalKaModuleConstructor;
import org.jetbrains.kotlin.idea.base.platforms.KLibUtils;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindKt;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmJsLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmWasiLibraryKind;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.CommonizerNativeTargetsCompat;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NativeKlibLibraryInfoKt;
import org.jetbrains.kotlin.idea.base.util.LoggingUtils;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmIdePlatformKind;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0011\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibraryModuleImpl;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibraryEntityBasedLibraryModuleBase;", "entityId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/LibraryId;Lcom/intellij/openapi/project/Project;)V", "getEntityId", "()Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "getProject", "()Lcom/intellij/openapi/project/Project;", "librarySources", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "librarySources$delegate", "Lkotlin/Lazy;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "targetPlatform$delegate", "idePlatformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getIdePlatformKind", "()Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "idePlatformKind$delegate", "resolvedKotlinLibraries", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getResolvedKotlinLibraries", "()Ljava/util/List;", "resolvedKotlinLibraries$delegate", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "kotlin.base.fir.project-structure"})
@SourceDebugExtension(value={"SMAP\nKaLibraryModuleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaLibraryModuleImpl.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibraryModuleImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1368#2:97\n1454#2,5:98\n774#2:103\n865#2,2:104\n1611#2,9:106\n1863#2:115\n1864#2:117\n1620#2:118\n1#3:116\n*S KotlinDebug\n*F\n+ 1 KaLibraryModuleImpl.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibraryModuleImpl\n*L\n51#1:97\n51#1:98,5\n68#1:103\n68#1:104,2\n69#1:106,9\n69#1:115\n69#1:117\n69#1:118\n69#1:116\n*E\n"})
public final class KaLibraryModuleImpl
extends KaLibraryEntityBasedLibraryModuleBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryId entityId;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy librarySources$delegate;
    @NotNull
    private final Lazy targetPlatform$delegate;
    @NotNull
    private final Lazy idePlatformKind$delegate;
    @NotNull
    private final Lazy resolvedKotlinLibraries$delegate;
    @NotNull
    private static final Logger KOTLIN_LOGGER;

    @InternalKaModuleConstructor
    public KaLibraryModuleImpl(@NotNull LibraryId entityId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.entityId = entityId;
        this.project = project;
        this.librarySources$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaLibraryModuleImpl.librarySources_delegate$lambda$0(this));
        this.targetPlatform$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaLibraryModuleImpl.targetPlatform_delegate$lambda$4(this));
        this.idePlatformKind$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaLibraryModuleImpl.idePlatformKind_delegate$lambda$5(this));
        this.resolvedKotlinLibraries$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaLibraryModuleImpl.resolvedKotlinLibraries_delegate$lambda$8(this));
    }

    @Override
    @NotNull
    public LibraryId getEntityId() {
        return this.entityId;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public KaLibrarySourceModule getLibrarySources() {
        Lazy lazy = this.librarySources$delegate;
        return (KaLibrarySourceModule)lazy.getValue();
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        Lazy lazy = this.targetPlatform$delegate;
        return (TargetPlatform)lazy.getValue();
    }

    private final IdePlatformKind getIdePlatformKind() {
        Lazy lazy = this.idePlatformKind$delegate;
        return (IdePlatformKind)lazy.getValue();
    }

    @NotNull
    public final List<KotlinLibrary> getResolvedKotlinLibraries() {
        Lazy lazy = this.resolvedKotlinLibraries$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof KaLibraryModuleImpl && Intrinsics.areEqual((Object)this.getEntityId(), (Object)((KaLibraryModuleImpl)other).getEntityId());
    }

    @Override
    public int hashCode() {
        return this.getEntityId().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "idePlatformKind=" + this.getIdePlatformKind();
    }

    private static final KaLibrarySourceModuleImpl librarySources_delegate$lambda$0(KaLibraryModuleImpl this$0) {
        return new KaLibrarySourceModuleImpl(this$0);
    }

    private static final List targetPlatform_delegate$lambda$4$lambda$3$lambda$1(KotlinLibrary $this$safeRead) {
        Intrinsics.checkNotNullParameter((Object)$this$safeRead, (String)"$this$safeRead");
        return CommonizerNativeTargetsCompat.INSTANCE.getCommonizerNativeTargetsCompat((BaseKotlinLibrary)$this$safeRead);
    }

    private static final List targetPlatform_delegate$lambda$4$lambda$3$lambda$2(KotlinLibrary $this$safeRead) {
        Intrinsics.checkNotNullParameter((Object)$this$safeRead, (String)"$this$safeRead");
        return KotlinLibraryKt.getNativeTargets((BaseKotlinLibrary)((BaseKotlinLibrary)$this$safeRead));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TargetPlatform targetPlatform_delegate$lambda$4(KaLibraryModuleImpl this$0) {
        TargetPlatform targetPlatform;
        IdePlatformKind idePlatformKind = this$0.getIdePlatformKind();
        if (idePlatformKind instanceof JvmIdePlatformKind) {
            targetPlatform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
            return targetPlatform;
        } else if (idePlatformKind instanceof CommonIdePlatformKind) {
            targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
            return targetPlatform;
        } else if (idePlatformKind instanceof JsIdePlatformKind) {
            targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
            return targetPlatform;
        } else if (idePlatformKind instanceof WasmIdePlatformKind) {
            PersistentLibraryKind persistentLibraryKind = this$0.getLibrary().getKind();
            if (persistentLibraryKind instanceof KotlinWasmJsLibraryKind) {
                targetPlatform = WasmPlatforms.INSTANCE.getWasmJs();
                return targetPlatform;
            } else {
                if (!(persistentLibraryKind instanceof KotlinWasmWasiLibraryKind)) throw new IllegalStateException(("Unexpected Wasm library kind `" + this$0.getLibrary().getKind() + "`").toString());
                targetPlatform = WasmPlatforms.INSTANCE.getWasmWasi();
            }
            return targetPlatform;
        } else {
            void $this$flatMapTo$iv$iv;
            if (!(idePlatformKind instanceof NativeIdePlatformKind)) throw new IllegalStateException(("Unexpected platform kind: " + this$0.getIdePlatformKind()).toString());
            Iterable $this$flatMap$iv = this$0.getResolvedKotlinLibraries();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinLibrary resolvedKotlinLibrary = (KotlinLibrary)element$iv$iv;
                boolean bl = false;
                List list2 = NativeKlibLibraryInfoKt.safeRead(resolvedKotlinLibrary, null, KaLibraryModuleImpl::targetPlatform_delegate$lambda$4$lambda$3$lambda$1);
                if (list2 == null) {
                    list2 = NativeKlibLibraryInfoKt.safeRead(resolvedKotlinLibrary, CollectionsKt.emptyList(), KaLibraryModuleImpl::targetPlatform_delegate$lambda$4$lambda$3$lambda$2);
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List platformNames = (List)destination$iv$iv;
            targetPlatform = NativePlatforms.INSTANCE.nativePlatformByTargetNames((Collection)platformNames);
        }
        return targetPlatform;
    }

    private static final IdePlatformKind idePlatformKind_delegate$lambda$5(KaLibraryModuleImpl this$0) {
        return IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)KotlinLibraryKindKt.getPlatform(KotlinLibraryKindKt.detectLibraryKind((Library)this$0.getLibrary(), this$0.getProject())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List resolvedKotlinLibraries_delegate$lambda$8(KaLibraryModuleImpl this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        TargetPlatform defaultPlatform = this$0.getIdePlatformKind().getDefaultPlatform();
        Iterable $this$filter$iv = this$0.getBinaryVirtualFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!KLibUtils.isKlibLibraryRootForPlatform(it, defaultPlatform)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = roots;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinLibrary it$iv$iv;
            String path2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile root = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((PathUtil.getLocalPath((VirtualFile)root) == null ? null : SingleFileResolveKt.resolveSingleFileKlib((File)new File(path2), (Logger)KOTLIN_LOGGER, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(KaLibraryModuleBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KOTLIN_LOGGER = LoggingUtils.asKotlinLogger(logger);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibraryModuleImpl$Companion;", "", "<init>", "()V", "KOTLIN_LOGGER", "Lorg/jetbrains/kotlin/util/Logger;", "kotlin.base.fir.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

