/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiPlatform;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.idea.base.analysisApiPlatform.IdeKotlinAnchorModuleProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.util.ResolutionAnchorCacheState;
import org.jetbrains.kotlin.idea.caches.trackers.ModuleModificationTracker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\n\u001a\u00020\tH\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\b\u0010%\u001a\u00020\u001fH\u0002J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020'0\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u0015\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f0\u001e\u00a2\u0006\u0002\b!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider;", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinAnchorModuleProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAnchorModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "libraryModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "getAllAnchorModules", "", "getAllAnchorModulesIfComputed", "getAnchorLibraries", "", "setAnchors", "", "mapping", "", "", "state", "Lorg/jetbrains/kotlin/idea/caches/resolve/util/ResolutionAnchorCacheState;", "getState", "()Lorg/jetbrains/kotlin/idea/caches/resolve/util/ResolutionAnchorCacheState;", "moduleNameToAnchorName", "getModuleNameToAnchorName", "()Ljava/util/Map;", "anchorMappingCachedValue", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider$AnchorMapping;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "anchorMapping", "getAnchorMapping", "()Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider$AnchorMapping;", "createResolutionAnchorMapping", "getLibrariesByName", "Lcom/intellij/openapi/roots/libraries/Library;", "AnchorMapping", "Companion", "kotlin.base.fir.analysis-api-platform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nK2IdeKotlinAnchorModuleProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2IdeKotlinAnchorModuleProvider.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n1863#2:123\n1864#2:131\n381#3,7:124\n15#4:132\n*S KotlinDebug\n*F\n+ 1 K2IdeKotlinAnchorModuleProvider.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider\n*L\n88#1:123\n88#1:131\n100#1:124,7\n120#1:132\n*E\n"})
public final class K2IdeKotlinAnchorModuleProvider
implements IdeKotlinAnchorModuleProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CachedValue<AnchorMapping> anchorMappingCachedValue;
    @NotNull
    private static final Logger logger;

    public K2IdeKotlinAnchorModuleProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue((UserDataHolder)this.project, () -> K2IdeKotlinAnchorModuleProvider.anchorMappingCachedValue$lambda$0(this), false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
        this.anchorMappingCachedValue = cachedValue2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public KaSourceModule getAnchorModule(@NotNull KaLibraryModule libraryModule) {
        Intrinsics.checkNotNullParameter((Object)libraryModule, (String)"libraryModule");
        return this.getAnchorMapping().getAnchorByLibrary().get(libraryModule);
    }

    @Override
    @NotNull
    public Collection<KaSourceModule> getAllAnchorModules() {
        return this.getAnchorMapping().getLibrariesByAnchor().keySet();
    }

    @Override
    @Nullable
    public Collection<KaSourceModule> getAllAnchorModulesIfComputed() {
        Object object = this.anchorMappingCachedValue.getUpToDateOrNull();
        if (object == null || (object = (AnchorMapping)object.get()) == null) {
            return null;
        }
        Object mapping = object;
        return ((AnchorMapping)mapping).getLibrariesByAnchor().keySet();
    }

    @Override
    @NotNull
    public List<KaLibraryModule> getAnchorLibraries(@NotNull KaSourceModule libraryModule) {
        Intrinsics.checkNotNullParameter((Object)libraryModule, (String)"libraryModule");
        List list2 = this.getAnchorMapping().getLibrariesByAnchor().get(libraryModule);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @TestOnly
    public final void setAnchors(@NotNull Map<String, String> mapping) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        this.getState().setAnchors(mapping);
    }

    private final ResolutionAnchorCacheState getState() {
        return ResolutionAnchorCacheState.Companion.getInstance(this.project);
    }

    private final Map<String, String> getModuleNameToAnchorName() {
        return this.getState().myState.getModuleNameToAnchorName();
    }

    private final AnchorMapping getAnchorMapping() {
        Object object = this.anchorMappingCachedValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AnchorMapping)object;
    }

    private final AnchorMapping createResolutionAnchorMapping() {
        Map<String, String> moduleNameToAnchorName = this.getModuleNameToAnchorName();
        if (moduleNameToAnchorName.isEmpty()) {
            return new AnchorMapping(MapsKt.emptyMap(), MapsKt.emptyMap());
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
        Map<String, Library> librariesByName = this.getLibrariesByName();
        Map anchorByLibrary = new LinkedHashMap();
        Map librariesByAnchor = new LinkedHashMap();
        Iterable $this$forEach$iv = moduleNameToAnchorName.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String libraryName = (String)entry.getKey();
            String anchorName = (String)entry.getValue();
            Object object2 = librariesByName.get(libraryName);
            if (object2 == null || (object2 = ApiKt.toKaLibraryModules(object2, this.project)) == null || (object2 = (KaLibraryModule)CollectionsKt.firstOrNull((List)object2)) == null) {
                K2IdeKotlinAnchorModuleProvider $this$createResolutionAnchorMapping_u24lambda_u244_u24lambda_u241 = this;
                boolean bl2 = false;
                logger.warn("Resolution anchor mapping key doesn't point to a known library: " + libraryName + ". Skipping this anchor");
                continue;
            }
            Object library = object2;
            Object object3 = moduleManager.findModuleByName(anchorName);
            if (object3 == null || (object3 = ApiKt.toKaSourceModuleForProduction(object3)) == null) {
                K2IdeKotlinAnchorModuleProvider $this$createResolutionAnchorMapping_u24lambda_u244_u24lambda_u242 = this;
                boolean bl3 = false;
                logger.warn("Resolution anchor mapping value doesn't point to a source module: " + anchorName + ". Skipping this anchor");
                continue;
            }
            Object anchor = object3;
            anchorByLibrary.put(library, anchor);
            Map $this$getOrPut$iv = librariesByAnchor;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(anchor);
            if (value$iv == null) {
                boolean bl4 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(anchor, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(library);
        }
        return new AnchorMapping(anchorByLibrary, librariesByAnchor);
    }

    private final Map<String, Library> getLibrariesByName() {
        Map map2;
        Map $this$getLibrariesByName_u24lambda_u245 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Module module : ModuleManager.Companion.getInstance(this.project).getModules()) {
            ProgressManager.checkCanceled();
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                String name2;
                Library library;
                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() == null || library.getName() == null) continue;
                $this$getLibrariesByName_u24lambda_u245.put(name2, library);
            }
        }
        return MapsKt.build((Map)map2);
    }

    private static final CachedValueProvider.Result anchorMappingCachedValue$lambda$0(K2IdeKotlinAnchorModuleProvider this$0) {
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance(this$0.project), JavaLibraryModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)this$0.createResolutionAnchorMapping(), (Object[])objectArray);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(K2IdeKotlinAnchorModuleProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        K2IdeKotlinAnchorModuleProvider.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider$AnchorMapping;", "", "anchorByLibrary", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "librariesByAnchor", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getAnchorByLibrary", "()Ljava/util/Map;", "getLibrariesByAnchor", "kotlin.base.fir.analysis-api-platform"})
    private static final class AnchorMapping {
        @NotNull
        private final Map<KaLibraryModule, KaSourceModule> anchorByLibrary;
        @NotNull
        private final Map<KaSourceModule, List<KaLibraryModule>> librariesByAnchor;

        public AnchorMapping(@NotNull Map<KaLibraryModule, ? extends KaSourceModule> anchorByLibrary, @NotNull Map<KaSourceModule, ? extends List<? extends KaLibraryModule>> librariesByAnchor) {
            Intrinsics.checkNotNullParameter(anchorByLibrary, (String)"anchorByLibrary");
            Intrinsics.checkNotNullParameter(librariesByAnchor, (String)"librariesByAnchor");
            this.anchorByLibrary = anchorByLibrary;
            this.librariesByAnchor = librariesByAnchor;
        }

        @NotNull
        public final Map<KaLibraryModule, KaSourceModule> getAnchorByLibrary() {
            return this.anchorByLibrary;
        }

        @NotNull
        public final Map<KaSourceModule, List<KaLibraryModule>> getLibrariesByAnchor() {
            return this.librariesByAnchor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/K2IdeKotlinAnchorModuleProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.base.fir.analysis-api-platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

