/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.copyPaste;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinOptimizeImportsFacility;
import org.jetbrains.kotlin.idea.base.codeInsight.copyPaste.KotlinCopyPasteActionInfo;
import org.jetbrains.kotlin.idea.base.codeInsight.copyPaste.RestoreReferencesDialog;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/copyPaste/ReviewAddedImports;", "", "<init>", "()V", "reviewAddedImports", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "imported", "", "", "showHint", "info", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "reviewImports", "importedClasses", "removeImports", "importsToRemove", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nReviewAddedImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewAddedImports.kt\norg/jetbrains/kotlin/idea/base/codeInsight/copyPaste/ReviewAddedImports\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n73#2:101\n73#2:102\n11158#3:103\n11493#3,3:104\n1611#4,9:107\n1863#4:116\n1864#4:119\n1620#4:120\n1#5:117\n1#5:118\n*S KotlinDebug\n*F\n+ 1 ReviewAddedImports.kt\norg/jetbrains/kotlin/idea/base/codeInsight/copyPaste/ReviewAddedImports\n*L\n38#1:101\n65#1:102\n79#1:103\n79#1:104,3\n91#1:107,9\n91#1:116\n91#1:119\n91#1:120\n91#1:118\n*E\n"})
public final class ReviewAddedImports {
    @NotNull
    public static final ReviewAddedImports INSTANCE = new ReviewAddedImports();

    private ReviewAddedImports() {
    }

    public final void reviewAddedImports(@NotNull Project project, @NotNull Editor editor, @NotNull KtFile file, @NotNull Collection<String> imported) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 1 && !imported.isEmpty()) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                KotlinCopyPasteActionInfo.INSTANCE.setImportsToBeReviewed(file, imported);
                this.removeImports(project, file, KotlinCopyPasteActionInfo.INSTANCE.getImportsToBeDeleted(file));
                return;
            }
            Object[] objectArray = new Object[]{imported.size()};
            String notificationText = KotlinBundle.htmlMessage((String)"copy.paste.reference.notification", (Object[])objectArray);
            ApplicationManager.getApplication().invokeLater(() -> ReviewAddedImports.reviewAddedImports$lambda$1(editor, notificationText, project, file, imported), ModalityState.nonModal());
        }
    }

    private final void showHint(Editor editor, @Nls String info2, HyperlinkListener hyperlinkListener) {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LightweightHint hint2 = new LightweightHint(HintUtil.createInformationLabel((String)info2, (HyperlinkListener)hyperlinkListener, null, null));
        int flags = 10;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint2, editor, (short)2, flags, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    private final void reviewImports(Project project, KtFile file, Collection<String> importedClasses) {
        RestoreReferencesDialog dialog2 = new RestoreReferencesDialog(project, ArrayUtil.toObjectArray(importedClasses), true);
        dialog2.setTitle(KotlinBundle.message((String)"copy.paste.select.imports.to.remove.dialog", (Object[])new Object[0]));
        if (dialog2.showAndGet()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = dialog2.getSelectedElements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedElements(...)");
            Object[] objectArray2 = objectArray;
            KtFile ktFile2 = file;
            Project project2 = project;
            ReviewAddedImports reviewAddedImports = this;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var13_16 = item$iv$iv = $this$mapTo$iv$iv[j];
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.String");
                collection.add((String)it);
            }
            collection = (List)destination$iv$iv;
            reviewAddedImports.removeImports(project2, ktFile2, CollectionsKt.toSortedSet((Iterable)collection));
        }
    }

    private final void removeImports(Project project, KtFile file, Collection<String> importsToRemove) {
        if (importsToRemove.isEmpty()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)KotlinBundle.message((String)"revert.applied.imports.command", (Object[])new Object[0]), null, () -> ReviewAddedImports.removeImports$lambda$5(file, importsToRemove), (PsiFile[])new PsiFile[0]);
    }

    private static final void reviewAddedImports$lambda$1$lambda$0(Project $project, KtFile $file, Collection $imported, HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            INSTANCE.reviewImports($project, $file, $imported);
        }
    }

    private static final void reviewAddedImports$lambda$1(Editor $editor, String $notificationText, Project $project, KtFile $file, Collection $imported) {
        INSTANCE.showHint($editor, $notificationText, arg_0 -> ReviewAddedImports.reviewAddedImports$lambda$1$lambda$0($project, $file, $imported, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeImports$lambda$5(KtFile $file, Collection $importsToRemove) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $file.getImportDirectives();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FqName importedFqName;
            ImportPath importPath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtImportDirective it = (KtImportDirective)element$iv$iv;
            boolean bl2 = false;
            if (it.getImportedFqName() == null) {
                importPath = null;
            } else if ($importsToRemove.contains(importedFqName.asString())) {
                importPath = null;
            } else {
                Name name2;
                FqName fqName2 = importedFqName;
                boolean bl3 = it.isAllUnder();
                if (it.getAliasName() != null) {
                    void alias;
                    boolean bl4 = bl3;
                    FqName fqName3 = fqName2;
                    boolean bl5 = false;
                    Name name3 = Name.identifier((String)alias);
                    fqName2 = fqName3;
                    bl3 = bl4;
                    name2 = name3;
                } else {
                    name2 = null;
                }
                Name name4 = name2;
                boolean bl6 = bl3;
                FqName fqName4 = fqName2;
                importPath = new ImportPath(fqName4, bl6, name4);
            }
            if (importPath == null) continue;
            ImportPath it$iv$iv = importPath;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newImports = (List)destination$iv$iv;
        KotlinOptimizeImportsFacility.Companion.getInstance().replaceImports($file, newImports);
    }
}

