/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinAnnotationsResolver;
import org.jetbrains.kotlin.idea.base.analysisApiPlatform.IdeKotlinAnnotationsResolverFactoryKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\f*\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00100\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinAnnotationsResolver;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinAnnotationsResolver;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "declarationsByAnnotation", "", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "annotationsOnDeclaration", "declaration", "referencedFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "resolveAnnotationId", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "resolveAnnotationFqName", "getCandidatesFromImports", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinAnnotationsResolver$ResolveByImportsCandidates;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetName", "Lorg/jetbrains/kotlin/name/Name;", "resolveToSingleName", "annotationActuallyExists", "", "matchingImport", "ResolveByImportsCandidates", "kotlin.base.analysis-api-platform"})
@SourceDebugExtension(value={"SMAP\nIdeKotlinAnnotationsResolverFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinAnnotationsResolverFactory.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinAnnotationsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1611#2,9:145\n1863#2:154\n1864#2:156\n1620#2:157\n1557#2:158\n1628#2,3:159\n669#2,11:163\n669#2,11:174\n1#3:155\n1#3:162\n*S KotlinDebug\n*F\n+ 1 IdeKotlinAnnotationsResolverFactory.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinAnnotationsResolver\n*L\n53#1:145,9\n53#1:154\n53#1:156\n53#1:157\n65#1:158\n65#1:159,3\n125#1:163,11\n129#1:174,11\n53#1:155\n*E\n"})
final class IdeKotlinAnnotationsResolver
implements KotlinAnnotationsResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public IdeKotlinAnnotationsResolver(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        this.project = project;
        this.searchScope = searchScope;
    }

    @Override
    @NotNull
    public Set<KtAnnotated> declarationsByAnnotation(@NotNull ClassId annotationClassId) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        if (!(!annotationClassId.isLocal() && !annotationClassId.isNestedClass())) {
            boolean bl = false;
            String string = "Queried annotation must be top-level, but was " + annotationClassId;
            throw new IllegalArgumentException(string.toString());
        }
        String string = annotationClassId.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        Collection annotationEntries = KotlinAnnotationsIndex.Helper.get(string, this.project, this.searchScope);
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)annotationEntries), arg_0 -> IdeKotlinAnnotationsResolver.declarationsByAnnotation$lambda$1(this, annotationClassId, arg_0)), IdeKotlinAnnotationsResolver::declarationsByAnnotation$lambda$2), IdeKotlinAnnotationsResolver::declarationsByAnnotation$lambda$3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<ClassId> annotationsOnDeclaration(@NotNull KtAnnotated declaration) {
        void $this$mapNotNullTo$iv$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtAnnotated ktAnnotated = declaration;
        if (ktAnnotated instanceof KtFile) {
            list2 = ((KtFile)declaration).getAnnotationEntries();
        } else if (ktAnnotated instanceof KtDeclaration) {
            List list3 = ((KtDeclaration)declaration).getAnnotationEntries();
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getAnnotationEntries(...)");
        } else {
            throw new IllegalStateException(("Unexpected element of class " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
        }
        List annotationEntries = list2;
        Iterable $this$mapNotNull$iv = annotationEntries;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            if (this.resolveAnnotationId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final FqName referencedFqName(KtUserType $this$referencedFqName) {
        void $this$mapTo$iv$iv;
        List allTypes = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)$this$referencedFqName, IdeKotlinAnnotationsResolver::referencedFqName$lambda$5)));
        Iterable $this$map$iv = allTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtUserType ktUserType = (KtUserType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getReferencedName();
            if (string == null) {
                return null;
            }
            collection.add(string);
        }
        List allQualifiers = (List)destination$iv$iv;
        return FqName.Companion.fromSegments(allQualifiers);
    }

    private final ClassId resolveAnnotationId(KtAnnotationEntry $this$resolveAnnotationId) {
        ClassId classId;
        FqName fqName2 = this.resolveAnnotationFqName($this$resolveAnnotationId);
        if (fqName2 != null) {
            FqName it = fqName2;
            boolean bl = false;
            classId = ClassId.Companion.topLevel(it);
        } else {
            classId = null;
        }
        return classId;
    }

    private final FqName resolveAnnotationFqName(KtAnnotationEntry $this$resolveAnnotationFqName) {
        KtTypeReference ktTypeReference = $this$resolveAnnotationFqName.getTypeReference();
        Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        KtUserType annotationTypeElement = object instanceof KtUserType ? (KtUserType)object : null;
        KtUserType ktUserType = annotationTypeElement;
        if (ktUserType == null || (ktUserType = this.referencedFqName(ktUserType)) == null) {
            return null;
        }
        KtUserType referencedName = ktUserType;
        if (referencedName.isRoot()) {
            return null;
        }
        if (!referencedName.parent().isRoot()) {
            KtUserType ktUserType2;
            KtUserType it = ktUserType2 = referencedName;
            boolean bl = false;
            return this.annotationActuallyExists((FqName)it) ? ktUserType2 : null;
        }
        KtFile ktFile2 = $this$resolveAnnotationFqName.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        ResolveByImportsCandidates candidates2 = this.getCandidatesFromImports(ktFile2, referencedName.shortName());
        FqName fqName2 = this.resolveToSingleName(candidates2.getFromExplicitImports());
        if (fqName2 == null && (fqName2 = this.resolveToSingleName(candidates2.getFromSamePackage())) == null) {
            fqName2 = this.resolveToSingleName(candidates2.getFromStarImports());
        }
        return fqName2;
    }

    private final ResolveByImportsCandidates getCandidatesFromImports(KtFile file, Name targetName) {
        Set starImports = new LinkedHashSet();
        Set explicitImports = new LinkedHashSet();
        for (KtImportDirective ktImportDirective : file.getImportDirectives()) {
            FqName importedName;
            if (ktImportDirective.getImportedFqName() == null) continue;
            if (ktImportDirective.isAllUnder()) {
                ((Collection)starImports).add(importedName.child(targetName));
                continue;
            }
            if (!Intrinsics.areEqual((Object)importedName.shortName(), (Object)targetName)) continue;
            ((Collection)explicitImports).add(importedName);
        }
        FqName packageImport = file.getPackageFqName().child(targetName);
        return new ResolveByImportsCandidates(SetsKt.setOf((Object)packageImport), explicitImports, starImports);
    }

    private final FqName resolveToSingleName(Set<FqName> $this$resolveToSingleName) {
        Object v0;
        block2: {
            Iterable $this$singleOrNull$iv = $this$resolveToSingleName;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FqName it = (FqName)element$iv;
                boolean bl = false;
                if (!this.annotationActuallyExists(it)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    private final boolean annotationActuallyExists(FqName matchingImport) {
        Object v0;
        block2: {
            Collection foundClasses = KotlinFullClassNameIndex.Helper.get(matchingImport.asString(), this.project, this.searchScope);
            Iterable $this$singleOrNull$iv = foundClasses;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl = false;
                if (!(it.isAnnotation() && it.isTopLevel())) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0 != null;
    }

    private static final boolean declarationsByAnnotation$lambda$1(IdeKotlinAnnotationsResolver this$0, ClassId $annotationClassId, KtAnnotationEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)this$0.resolveAnnotationId(it), (Object)$annotationClassId);
    }

    private static final KtAnnotated declarationsByAnnotation$lambda$2(KtAnnotationEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IdeKotlinAnnotationsResolverFactoryKt.access$getAnnotationOwner(it);
    }

    private static final boolean declarationsByAnnotation$lambda$3(KtAnnotated it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtFile || it instanceof KtDeclaration;
    }

    private static final KtUserType referencedFqName$lambda$5(KtUserType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQualifier();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinAnnotationsResolver$ResolveByImportsCandidates;", "", "fromSamePackage", "", "Lorg/jetbrains/kotlin/name/FqName;", "fromExplicitImports", "fromStarImports", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getFromSamePackage", "()Ljava/util/Set;", "getFromExplicitImports", "getFromStarImports", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.analysis-api-platform"})
    private static final class ResolveByImportsCandidates {
        @NotNull
        private final Set<FqName> fromSamePackage;
        @NotNull
        private final Set<FqName> fromExplicitImports;
        @NotNull
        private final Set<FqName> fromStarImports;

        public ResolveByImportsCandidates(@NotNull Set<FqName> fromSamePackage, @NotNull Set<FqName> fromExplicitImports, @NotNull Set<FqName> fromStarImports) {
            Intrinsics.checkNotNullParameter(fromSamePackage, (String)"fromSamePackage");
            Intrinsics.checkNotNullParameter(fromExplicitImports, (String)"fromExplicitImports");
            Intrinsics.checkNotNullParameter(fromStarImports, (String)"fromStarImports");
            this.fromSamePackage = fromSamePackage;
            this.fromExplicitImports = fromExplicitImports;
            this.fromStarImports = fromStarImports;
        }

        @NotNull
        public final Set<FqName> getFromSamePackage() {
            return this.fromSamePackage;
        }

        @NotNull
        public final Set<FqName> getFromExplicitImports() {
            return this.fromExplicitImports;
        }

        @NotNull
        public final Set<FqName> getFromStarImports() {
            return this.fromStarImports;
        }

        @NotNull
        public final Set<FqName> component1() {
            return this.fromSamePackage;
        }

        @NotNull
        public final Set<FqName> component2() {
            return this.fromExplicitImports;
        }

        @NotNull
        public final Set<FqName> component3() {
            return this.fromStarImports;
        }

        @NotNull
        public final ResolveByImportsCandidates copy(@NotNull Set<FqName> fromSamePackage, @NotNull Set<FqName> fromExplicitImports, @NotNull Set<FqName> fromStarImports) {
            Intrinsics.checkNotNullParameter(fromSamePackage, (String)"fromSamePackage");
            Intrinsics.checkNotNullParameter(fromExplicitImports, (String)"fromExplicitImports");
            Intrinsics.checkNotNullParameter(fromStarImports, (String)"fromStarImports");
            return new ResolveByImportsCandidates(fromSamePackage, fromExplicitImports, fromStarImports);
        }

        public static /* synthetic */ ResolveByImportsCandidates copy$default(ResolveByImportsCandidates resolveByImportsCandidates, Set set, Set set2, Set set3, int n, Object object) {
            if ((n & 1) != 0) {
                set = resolveByImportsCandidates.fromSamePackage;
            }
            if ((n & 2) != 0) {
                set2 = resolveByImportsCandidates.fromExplicitImports;
            }
            if ((n & 4) != 0) {
                set3 = resolveByImportsCandidates.fromStarImports;
            }
            return resolveByImportsCandidates.copy(set, set2, set3);
        }

        @NotNull
        public String toString() {
            return "ResolveByImportsCandidates(fromSamePackage=" + this.fromSamePackage + ", fromExplicitImports=" + this.fromExplicitImports + ", fromStarImports=" + this.fromStarImports + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.fromSamePackage).hashCode();
            result2 = result2 * 31 + ((Object)this.fromExplicitImports).hashCode();
            result2 = result2 * 31 + ((Object)this.fromStarImports).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolveByImportsCandidates)) {
                return false;
            }
            ResolveByImportsCandidates resolveByImportsCandidates = (ResolveByImportsCandidates)other;
            if (!Intrinsics.areEqual(this.fromSamePackage, resolveByImportsCandidates.fromSamePackage)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fromExplicitImports, resolveByImportsCandidates.fromExplicitImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.fromStarImports, resolveByImportsCandidates.fromStarImports);
        }
    }
}

