/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.RowIcon;
import java.util.Iterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclarationBase;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightParameter;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$J\u0014\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0011\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0082\u0010J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinIconProvider;", "Lcom/intellij/ide/IconProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isMatchingExpected", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "addExpectActualMarker", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "isExpectDeclaration", "getIcon", "psiElement", "flags", "", "Companion", "kotlin.base.util"})
public abstract class KotlinIconProvider
extends IconProvider
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected abstract boolean isMatchingExpected(@NotNull KtDeclaration var1);

    private final Icon addExpectActualMarker(Icon $this$addExpectActualMarker, PsiElement element) {
        Icon icon2;
        KtNamedDeclaration ktNamedDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
        if (ktNamedDeclaration == null) {
            return $this$addExpectActualMarker;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        if (this.isExpectDeclaration((KtDeclaration)declaration)) {
            icon2 = KotlinIcons.EXPECT;
        } else if (this.isMatchingExpected((KtDeclaration)declaration)) {
            icon2 = KotlinIcons.ACTUAL;
        } else {
            return $this$addExpectActualMarker;
        }
        Icon icon3 = icon2;
        Intrinsics.checkNotNull((Object)icon3);
        Icon additionalIcon = icon3;
        Icon $this$addExpectActualMarker_u24lambda_u240 = icon3 = new RowIcon(2, null, 2, null);
        boolean bl = false;
        $this$addExpectActualMarker_u24lambda_u240.setIcon($this$addExpectActualMarker, 0);
        $this$addExpectActualMarker_u24lambda_u240.setIcon(additionalIcon, 1);
        return icon3;
    }

    private final boolean isExpectDeclaration(KtDeclaration declaration) {
        KotlinIconProvider kotlinIconProvider = this;
        while (!PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
            KtClassOrObject containingDeclaration;
            if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)declaration) == null) {
                return false;
            }
            declaration = (KtDeclaration)containingDeclaration;
        }
        return true;
    }

    @Nullable
    public Icon getIcon(@NotNull PsiElement psiElement, int flags) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (psiElement instanceof KtFile) {
            KtClassOrObject mainClass;
            if (((KtFile)psiElement).isScript()) {
                return KotlinIconProvider.Companion.scriptIcon((PsiFile)psiElement);
            }
            KtClassOrObject ktClassOrObject = mainClass = Companion.getSingleClass((KtFile)psiElement);
            return ktClassOrObject != null ? this.getIcon((PsiElement)ktClassOrObject, flags) : KotlinIcons.FILE;
        }
        Icon result2 = Companion.getBaseIcon(psiElement);
        if ((flags & 1) > 0 && result2 != null && psiElement instanceof KtModifierListOwner && !(psiElement instanceof KtClassInitializer)) {
            Icon icon2;
            KtModifierList list2 = ((KtModifierListOwner)psiElement).getModifierList();
            Icon visibilityIcon = Companion.getVisibilityIcon(list2);
            try {
                icon2 = this.addExpectActualMarker(result2, psiElement);
            }
            catch (IndexNotReadyException indexNotReady) {
                icon2 = result2;
            }
            Icon withExpectedActual = icon2;
            return (Icon)KotlinIconProvider.Companion.createRowIcon(withExpectedActual, visibilityIcon);
        }
        return result2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\f\u0010\u0013\u001a\u00020\u000e*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u0004\u0018\u00010\u000e*\u00020\u0016J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u000e*\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinIconProvider$Companion;", "", "<init>", "()V", "isSingleClassFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getSingleClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getMainClass", "createRowIcon", "Lcom/intellij/ui/RowIcon;", "baseIcon", "Ljavax/swing/Icon;", "visibilityIcon", "getVisibilityIcon", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "scriptIcon", "Lcom/intellij/psi/PsiFile;", "getBaseIcon", "Lcom/intellij/psi/PsiElement;", "getBaseIconUnwrapped", "kotlin.base.util"})
    @SourceDebugExtension(value={"SMAP\nKotlinIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinIconProvider.kt\norg/jetbrains/kotlin/idea/KotlinIconProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,194:1\n1#2:195\n213#3:196\n280#4:197\n280#4:198\n*S KotlinDebug\n*F\n+ 1 KotlinIconProvider.kt\norg/jetbrains/kotlin/idea/KotlinIconProvider$Companion\n*L\n141#1:196\n174#1:197\n183#1:198\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSingleClassFile(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.getSingleClass(file) != null;
        }

        @Nullable
        public final KtClassOrObject getSingleClass(@NotNull KtFile file) {
            KtDeclaration ktDeclaration;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtDeclaration targetDeclaration = null;
            for (KtDeclaration declaration : file.getDeclarations()) {
                if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) || declaration instanceof KtTypeAlias) continue;
                if (targetDeclaration != null) {
                    return null;
                }
                targetDeclaration = declaration;
            }
            KtDeclaration ktDeclaration2 = targetDeclaration;
            if (ktDeclaration2 != null) {
                KtDeclaration ktDeclaration3;
                KtDeclaration it = ktDeclaration3 = ktDeclaration2;
                boolean bl = false;
                ktDeclaration = it instanceof KtClassOrObject && Intrinsics.areEqual((Object)StringUtil.getPackageName((String)file.getName()), (Object)((KtClassOrObject)it).getName()) ? ktDeclaration3 : null;
            } else {
                ktDeclaration = null;
            }
            Iterator iterator = ktDeclaration;
            return iterator instanceof KtClassOrObject ? (KtClassOrObject)iterator : null;
        }

        @Nullable
        public final KtClassOrObject getMainClass(@NotNull KtFile file) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtClassOrObject targetClassOrObject = null;
            for (KtDeclaration declaration : file.getDeclarations()) {
                if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) || !(declaration instanceof KtClassOrObject)) continue;
                if (targetClassOrObject != null) {
                    return null;
                }
                targetClassOrObject = (KtClassOrObject)declaration;
            }
            KtClassOrObject ktClassOrObject = targetClassOrObject;
            if (ktClassOrObject != null) {
                KtClassOrObject ktClassOrObject2;
                KtClassOrObject it = ktClassOrObject2 = ktClassOrObject;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)StringUtil.getPackageName((String)file.getName()), (Object)it.getName()) ? ktClassOrObject2 : null;
            } else {
                object = null;
            }
            return object;
        }

        private final RowIcon createRowIcon(Icon baseIcon, Icon visibilityIcon) {
            RowIcon rowIcon = new RowIcon(2, null, 2, null);
            rowIcon.setIcon(baseIcon, 0);
            rowIcon.setIcon(visibilityIcon, 1);
            return rowIcon;
        }

        @NotNull
        public final Icon getVisibilityIcon(@Nullable KtModifierList list2) {
            Object icon2 = list2 != null ? (list2.hasModifier(KtTokens.PRIVATE_KEYWORD) ? PlatformIcons.Private : (list2.hasModifier(KtTokens.PROTECTED_KEYWORD) ? PlatformIcons.Protected : (list2.hasModifier(KtTokens.INTERNAL_KEYWORD) ? PlatformIcons.Local : null))) : null;
            PlatformIcons platformIcons = icon2;
            if (platformIcons == null) {
                platformIcons = PlatformIcons.Public;
            }
            PlatformIcons platformIcons2 = platformIcons;
            IconManager iconManager = IconManager.Companion.getInstance();
            PlatformIcons p0 = platformIcons2;
            boolean bl = false;
            return iconManager.getPlatformIcon(p0);
        }

        private final Icon scriptIcon(PsiFile $this$scriptIcon) {
            Icon icon2;
            String string = $this$scriptIcon.getVirtualFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".gradle.kts", (boolean)false, (int)2, null)) {
                Icon icon3 = KotlinIcons.GRADLE_SCRIPT;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"GRADLE_SCRIPT");
            } else {
                Icon icon4 = KotlinIcons.SCRIPT;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SCRIPT");
            }
            return icon2;
        }

        @Nullable
        public final Icon getBaseIcon(@NotNull PsiElement $this$getBaseIcon) {
            Icon icon2;
            Intrinsics.checkNotNullParameter((Object)$this$getBaseIcon, (String)"<this>");
            PsiElement psiElement = $this$getBaseIcon;
            if (psiElement instanceof KtPackageDirective) {
                icon2 = AllIcons.Nodes.Package;
            } else if (psiElement instanceof KtFile || psiElement instanceof KtLightClassForFacade) {
                icon2 = KotlinIcons.FILE;
            } else if (psiElement instanceof KtScript) {
                PsiElement psiElement2 = ((KtScript)$this$getBaseIcon).getParent();
                KtFile ktFile2 = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
                icon2 = ktFile2 != null ? this.scriptIcon((PsiFile)ktFile2) : null;
            } else if (psiElement instanceof KtLightClass) {
                PsiElement psiElement3 = ((KtLightClass)$this$getBaseIcon).getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getNavigationElement(...)");
                icon2 = this.getBaseIcon(psiElement3);
            } else if (psiElement instanceof KtNamedFunction) {
                if (((KtNamedFunction)$this$getBaseIcon).getReceiverTypeReference() != null) {
                    icon2 = KtPsiUtil.isAbstract((KtDeclarationWithBody)((KtDeclarationWithBody)$this$getBaseIcon)) ? KotlinIcons.ABSTRACT_EXTENSION_FUNCTION : KotlinIcons.EXTENSION_FUNCTION;
                } else {
                    PsiElement $this$getStrictParentOfType$iv = $this$getBaseIcon;
                    boolean $i$f$getStrictParentOfType = false;
                    icon2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedDeclaration.class, (boolean)true) instanceof KtClass ? (KtPsiUtil.isAbstract((KtDeclarationWithBody)((KtDeclarationWithBody)$this$getBaseIcon)) ? com.intellij.util.PlatformIcons.ABSTRACT_METHOD_ICON : IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Method)) : KotlinIcons.FUNCTION;
                }
            } else if (psiElement instanceof KtConstructor) {
                icon2 = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Method);
            } else if (psiElement instanceof KtLightMethod) {
                PsiElement u = LightClassUtilsKt.getUnwrapped((PsiElement)$this$getBaseIcon);
                icon2 = u instanceof KtProperty ? (!((KtProperty)u).hasBody() ? com.intellij.util.PlatformIcons.ABSTRACT_METHOD_ICON : IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Method)) : IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Method);
            } else if (psiElement instanceof KtLightParameter) {
                icon2 = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Variable);
            } else if (psiElement instanceof KtFunctionLiteral) {
                icon2 = KotlinIcons.LAMBDA;
            } else if (psiElement instanceof KtClass) {
                icon2 = ((KtClass)$this$getBaseIcon).isInterface() ? KotlinIcons.INTERFACE : (((KtClass)$this$getBaseIcon).isEnum() ? KotlinIcons.ENUM : (((KtClass)$this$getBaseIcon).isAnnotation() ? KotlinIcons.ANNOTATION : ($this$getBaseIcon instanceof KtEnumEntry && ((KtEnumEntry)$this$getBaseIcon).getPrimaryConstructorParameterList() == null ? KotlinIcons.ENUM : (KtPsiUtilKt.isAbstract((KtClass)((KtClass)$this$getBaseIcon)) ? KotlinIcons.ABSTRACT_CLASS : KotlinIcons.CLASS))));
            } else if (psiElement instanceof KtObjectDeclaration) {
                icon2 = KotlinIcons.OBJECT;
            } else if (psiElement instanceof KtParameter) {
                icon2 = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)((KtParameter)$this$getBaseIcon)) != null ? (((KtParameter)$this$getBaseIcon).isMutable() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL) : KotlinIcons.PARAMETER;
            } else if (psiElement instanceof KtProperty) {
                icon2 = ((KtProperty)$this$getBaseIcon).isVar() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL;
            } else if (psiElement instanceof KtScriptInitializer) {
                icon2 = KotlinIcons.LAMBDA;
            } else if (psiElement instanceof KtClassInitializer) {
                icon2 = KotlinIcons.CLASS_INITIALIZER;
            } else if (psiElement instanceof KtTypeAlias) {
                icon2 = KotlinIcons.TYPE_ALIAS;
            } else if (psiElement instanceof KtAnnotationEntry) {
                Name name2 = ((KtAnnotationEntry)$this$getBaseIcon).getShortName();
                boolean $this$ifTrue$iv = Intrinsics.areEqual((Object)(name2 != null ? name2.asString() : null), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT());
                boolean $i$f$ifTrue = false;
                if ($this$ifTrue$iv) {
                    boolean bl = false;
                    PsiElement grandParent = ((KtAnnotationEntry)$this$getBaseIcon).getParent().getParent();
                    if (grandParent instanceof KtPropertyAccessor) {
                        KtProperty ktProperty = ((KtPropertyAccessor)grandParent).getProperty();
                        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
                        icon2 = Companion.getBaseIcon((PsiElement)ktProperty);
                    } else {
                        Intrinsics.checkNotNull((Object)grandParent);
                        icon2 = Companion.getBaseIcon(grandParent);
                    }
                } else {
                    icon2 = null;
                }
            } else if (psiElement instanceof PsiClass) {
                Icon icon3;
                boolean $this$ifTrue$iv = $this$getBaseIcon instanceof KtLightClassForDecompiledDeclarationBase;
                boolean $i$f$ifTrue = false;
                if ($this$ifTrue$iv) {
                    KtClassOrObject origin;
                    boolean bl = false;
                    PsiElement psiElement4 = $this$getBaseIcon;
                    KtLightClass ktLightClass = psiElement4 instanceof KtLightClass ? (KtLightClass)psiElement4 : null;
                    KtClassOrObject ktClassOrObject = origin = ktLightClass != null ? (KtClassOrObject)ktLightClass.getKotlinOrigin() : null;
                    icon3 = ktClassOrObject != null ? Companion.getBaseIcon((PsiElement)ktClassOrObject) : KotlinIcons.CLASS;
                } else {
                    icon3 = icon2 = null;
                }
                if (icon3 == null) {
                    icon2 = this.getBaseIconUnwrapped($this$getBaseIcon);
                }
            } else {
                icon2 = this.getBaseIconUnwrapped($this$getBaseIcon);
            }
            return icon2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Icon getBaseIconUnwrapped(PsiElement $this$getBaseIconUnwrapped) {
            PsiElement psiElement;
            PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)$this$getBaseIconUnwrapped);
            psiElement3 = psiElement3;
            if (psiElement2 == null) return null;
            PsiElement it = psiElement = psiElement3;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)$this$getBaseIconUnwrapped)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            PsiElement psiElement3 = psiElement;
            psiElement3 = psiElement3;
            if (psiElement4 == null) return null;
            Icon icon2 = this.getBaseIcon(psiElement3);
            return icon2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

