/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\u0006*\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u001d\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions;", "", "<init>", "()V", "createSupertypeList", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "createClassLikeType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getApproximatedTypeImpl", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "findCommonSuperType", "Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "types", "", "commonSuperType", "left", "right", "commonSuperTypeBetweenIntegerTypeAndRegularType", "integerLiteralType", "regularType", "commonSuperTypeBetweenTwoConstantTypes", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;", "approximateIntegerLiteralBounds", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "withNullabilityAndAttributes", "isMarkedNullable", "", "attributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "tree"})
@SourceDebugExtension(value={"SMAP\nConeIntegerLiteralTypeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeIntegerLiteralTypeImpl.kt\norg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n2746#2,3:240\n2783#2,7:243\n*S KotlinDebug\n*F\n+ 1 ConeIntegerLiteralTypeImpl.kt\norg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions\n*L\n144#1:240,3\n172#1:243,7\n*E\n"})
final class ConeIntegerLiteralTypeExtensions {
    @NotNull
    public static final ConeIntegerLiteralTypeExtensions INSTANCE = new ConeIntegerLiteralTypeExtensions();

    private ConeIntegerLiteralTypeExtensions() {
    }

    @NotNull
    public final List<ConeClassLikeType> createSupertypeList(@NotNull ConeIntegerLiteralType type2) {
        List list2;
        boolean bl;
        ConeClassLikeTypeImpl comparableSuperType;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray;
        block5: {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            coneKotlinTypeProjectionArray = new ConeKotlinTypeProjectionIn[]{new ConeKotlinTypeProjectionIn(type2)};
            comparableSuperType = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(StandardClassIds.INSTANCE.getComparable()), coneKotlinTypeProjectionArray, false, null, 8, null);
            Iterable $this$none$iv = type2.getPossibleTypes();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            coneKotlinTypeProjectionArray = new ConeClassLikeType[]{this.createClassLikeType(StandardClassIds.INSTANCE.getNumber()), comparableSuperType};
            list2 = CollectionsKt.listOf((Object[])coneKotlinTypeProjectionArray);
        } else {
            list2 = CollectionsKt.listOf((Object)comparableSuperType);
        }
        return list2;
    }

    @NotNull
    public final ConeClassLikeType createClassLikeType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(classId), ConeTypeProjection.Companion.getEMPTY_ARRAY(), false, null, 8, null);
    }

    @NotNull
    public final ConeClassLikeType getApproximatedTypeImpl(@NotNull ConeIntegerLiteralType $this$getApproximatedTypeImpl, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$getApproximatedTypeImpl, (String)"<this>");
        ConeKotlinType coneKotlinType = expectedType;
        ConeRigidType coneRigidType = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
        ConeClassLikeType coneClassLikeType = coneRigidType instanceof ConeClassLikeType ? (ConeClassLikeType)coneRigidType : null;
        ConeClassLikeType expectedTypeForApproximation = coneClassLikeType != null ? this.withNullabilityAndAttributes(coneClassLikeType, false, ConeAttributes.Companion.getEmpty()) : null;
        coneRigidType = expectedTypeForApproximation;
        ConeClassLikeType approximatedType = coneRigidType == null || !$this$getApproximatedTypeImpl.getPossibleTypes().contains(coneRigidType) ? (ConeClassLikeType)CollectionsKt.first((Iterable)$this$getApproximatedTypeImpl.getPossibleTypes()) : expectedTypeForApproximation;
        return this.withNullabilityAndAttributes(approximatedType, $this$getApproximatedTypeImpl.isMarkedNullable(), $this$getApproximatedTypeImpl.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RigidTypeMarker findCommonSuperType(@NotNull Collection<? extends RigidTypeMarker> types) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        if (types.isEmpty()) {
            return null;
        }
        Iterable $this$reduce$iv = types;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void right;
            RigidTypeMarker rigidTypeMarker = (RigidTypeMarker)iterator$iv.next();
            RigidTypeMarker left = (RigidTypeMarker)accumulator$iv;
            boolean bl = false;
            accumulator$iv = INSTANCE.commonSuperType(left, (RigidTypeMarker)right);
        }
        return (RigidTypeMarker)accumulator$iv;
    }

    private final RigidTypeMarker commonSuperType(RigidTypeMarker left, RigidTypeMarker right) {
        if (left == null || right == null) {
            return null;
        }
        return left instanceof ConeIntegerLiteralType && !(right instanceof ConeIntegerLiteralType) ? this.commonSuperTypeBetweenIntegerTypeAndRegularType((ConeIntegerLiteralType)left, right) : (right instanceof ConeIntegerLiteralType && !(left instanceof ConeIntegerLiteralType) ? this.commonSuperTypeBetweenIntegerTypeAndRegularType((ConeIntegerLiteralType)right, left) : (left instanceof ConeIntegerLiteralConstantType && right instanceof ConeIntegerLiteralConstantType ? (RigidTypeMarker)this.commonSuperTypeBetweenTwoConstantTypes((ConeIntegerLiteralConstantType)left, (ConeIntegerLiteralConstantType)right) : (left instanceof ConeIntegerConstantOperatorType ? left : (right instanceof ConeIntegerConstantOperatorType ? right : null))));
    }

    private final RigidTypeMarker commonSuperTypeBetweenIntegerTypeAndRegularType(ConeIntegerLiteralType integerLiteralType, RigidTypeMarker regularType) {
        RigidTypeMarker rigidTypeMarker = regularType;
        return CollectionsKt.contains((Iterable)integerLiteralType.getPossibleTypes(), (Object)rigidTypeMarker) ? regularType : null;
    }

    private final ConeIntegerLiteralConstantType commonSuperTypeBetweenTwoConstantTypes(ConeIntegerLiteralConstantType left, ConeIntegerLiteralConstantType right) {
        Set possibleTypes = CollectionsKt.intersect((Iterable)left.getPossibleTypes(), (Iterable)right.getPossibleTypes());
        return new ConeIntegerLiteralConstantTypeImpl(left.getValue(), possibleTypes, left.isUnsigned(), left.isMarkedNullable());
    }

    @NotNull
    public final ConeFlexibleType approximateIntegerLiteralBounds(@NotNull ConeFlexibleType $this$approximateIntegerLiteralBounds, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$approximateIntegerLiteralBounds, (String)"<this>");
        ConeKotlinType newLowerBound = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType($this$approximateIntegerLiteralBounds.getLowerBound(), expectedType);
        ConeKotlinType newUpperBound = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType($this$approximateIntegerLiteralBounds.getUpperBound(), expectedType);
        if (newLowerBound != $this$approximateIntegerLiteralBounds.getLowerBound() || newUpperBound != $this$approximateIntegerLiteralBounds.getUpperBound()) {
            return new ConeFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible(newLowerBound), ConeTypeUtilsKt.upperBoundIfFlexible(newUpperBound));
        }
        return $this$approximateIntegerLiteralBounds;
    }

    public static /* synthetic */ ConeFlexibleType approximateIntegerLiteralBounds$default(ConeIntegerLiteralTypeExtensions coneIntegerLiteralTypeExtensions, ConeFlexibleType coneFlexibleType, ConeKotlinType coneKotlinType, int n, Object object) {
        if ((n & 1) != 0) {
            coneKotlinType = null;
        }
        return coneIntegerLiteralTypeExtensions.approximateIntegerLiteralBounds(coneFlexibleType, coneKotlinType);
    }

    @NotNull
    public final ConeClassLikeType withNullabilityAndAttributes(@NotNull ConeClassLikeType $this$withNullabilityAndAttributes, boolean isMarkedNullable, @NotNull ConeAttributes attributes) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$withNullabilityAndAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (isMarkedNullable == $this$withNullabilityAndAttributes.isMarkedNullable() && Intrinsics.areEqual((Object)attributes, (Object)$this$withNullabilityAndAttributes.getAttributes())) {
            return $this$withNullabilityAndAttributes;
        }
        ConeClassLikeType coneClassLikeType2 = $this$withNullabilityAndAttributes;
        if (coneClassLikeType2 instanceof ConeErrorType) {
            coneClassLikeType = $this$withNullabilityAndAttributes;
        } else if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$withNullabilityAndAttributes).getLookupTag(), ((ConeClassLikeTypeImpl)$this$withNullabilityAndAttributes).getTypeArguments(), isMarkedNullable, attributes);
        } else {
            throw new IllegalStateException("sealed".toString());
        }
        return coneClassLikeType;
    }
}

