/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.web.common.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.FirAbstractWebCheckerUtils;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirAbstractNativeRttiChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "webCheckerUtils", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;)V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkGetClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "checkTypeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "checkers.web.common"})
@SourceDebugExtension(value={"SMAP\nFirAbstractNativeRttiChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAbstractNativeRttiChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirAbstractNativeRttiChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,70:1\n43#2:71\n45#2:72\n*S KotlinDebug\n*F\n+ 1 FirAbstractNativeRttiChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirAbstractNativeRttiChecker\n*L\n35#1:71\n56#1:72\n*E\n"})
public abstract class FirAbstractNativeRttiChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    private final FirAbstractWebCheckerUtils webCheckerUtils;

    public FirAbstractNativeRttiChecker(@NotNull FirAbstractWebCheckerUtils webCheckerUtils) {
        Intrinsics.checkNotNullParameter((Object)webCheckerUtils, (String)"webCheckerUtils");
        super(MppCheckerKind.Common);
        this.webCheckerUtils = webCheckerUtils;
    }

    @Override
    public void check(@NotNull FirStatement expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirStatement firStatement = expression;
        if (firStatement instanceof FirGetClassCall) {
            this.checkGetClassCall((FirGetClassCall)expression, context, reporter);
        } else if (firStatement instanceof FirTypeOperatorCall) {
            this.checkTypeOperatorCall((FirTypeOperatorCall)expression, context, reporter);
        }
    }

    private final void checkGetClassCall(FirGetClassCall expression, CheckerContext context, DiagnosticReporter reporter) {
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType(expression.getArgument()), context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        FirCall $this$arguments$iv = expression;
        boolean $i$f$getArguments = false;
        if (!(CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments()) instanceof FirResolvedQualifier)) {
            return;
        }
        if (this.webCheckerUtils.isNativeOrExternalInterface(declarationToCheck, context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirWebCommonErrors.INSTANCE.getEXTERNAL_INTERFACE_AS_CLASS_LITERAL(), (DiagnosticContext)context, null, (int)8, null);
        }
    }

    private final void checkTypeOperatorCall(FirTypeOperatorCall expression, CheckerContext context, DiagnosticReporter reporter) {
        FirTypeRef targetTypeRef = expression.getConversionTypeRef();
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(targetTypeRef, context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        if (!this.webCheckerUtils.isNativeOrExternalInterface(declarationToCheck, context.getSession())) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[expression.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                FirCall $this$argument$iv = expression;
                boolean $i$f$getArgument = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirWebCommonErrors.INSTANCE.getUNCHECKED_CAST_TO_EXTERNAL_INTERFACE(), (Object)FirTypeUtilsKt.getResolvedType((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments())), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), (DiagnosticContext)context, null, (int)32, null);
                break;
            }
            case 3: 
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirWebCommonErrors.INSTANCE.getCANNOT_CHECK_FOR_EXTERNAL_INTERFACE(), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), (DiagnosticContext)context, null, (int)16, null);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.AS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

