/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.RequireKotlinDeprecationInfo;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCallToDeprecatedOverrideOfHidden;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorInfo;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J6\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0017\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001cJ \u0010\u001d\u001a\u00020\u001e*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J?\u0010\u001f\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b\"J*\u0010#\u001a\u00020\u001e*\u00020$2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\f\u001a\u00020\rH\u0002JC\u0010%\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b(J6\u0010)\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010'\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010+\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010,\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010'\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010.\u001a\u0004\u0018\u00010$2\b\u0010 \u001a\u0004\u0018\u00010!2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u000101*\u0002022\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "filteredSourceKinds", "", "Lorg/jetbrains/kotlin/KtFakeSourceElementKind;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportCallToDeprecatedOverrideOfHidden", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "referencedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "DeprecatedOverrideOfHiddenReplacements", "", "", "getDeprecatedOverrideOfHiddenReplacements$checkers", "()Ljava/util/Map;", "getDeprecatedOverrideOfHiddenMessage", "callableName", "getDeprecatedOverrideOfHiddenMessage$checkers", "isDelegatedPropertySelfAccess", "", "reportApiStatusIfNeeded", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "reportApiStatusIfNeeded$checkers", "isTypealiasExpansionOf", "Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "reportApiStatus", "isTypealiasExpansion", "deprecationInfo", "reportApiStatus$checkers", "reportVersionRequirementDeprecation", "Lorg/jetbrains/kotlin/fir/declarations/RequireKotlinDeprecationInfo;", "reportDeprecation", "reportApiNotAvailable", "Lorg/jetbrains/kotlin/fir/declarations/FutureApiDeprecationInfo;", "getWorstDeprecation", "symbol", "classSymbolItIsCalledThrough", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
public final class FirDeprecationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirDeprecationChecker INSTANCE = new FirDeprecationChecker();
    @NotNull
    private static final Set<KtFakeSourceElementKind> filteredSourceKinds;
    @NotNull
    private static final Map<String, String> DeprecatedOverrideOfHiddenReplacements;

    private FirDeprecationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirStatement expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression.getSource();
        if (CollectionsKt.contains((Iterable)filteredSourceKinds, (Object)(ktSourceElement != null ? ktSourceElement.getKind() : null))) {
            return;
        }
        if (expression instanceof FirAnnotation) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression, context)) {
            return;
        }
        FirReference firReference = ReferenceUtilsKt.toReference(expression, context.getSession());
        if (firReference == null) {
            return;
        }
        FirReference calleeReference = firReference;
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(calleeReference);
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference resolvedReference = firResolvedNamedReference;
        FirBasedSymbol<?> referencedSymbol = resolvedReference.getResolvedSymbol();
        if (this.isDelegatedPropertySelfAccess(expression, context, referencedSymbol)) {
            return;
        }
        KtSourceElement ktSourceElement2 = resolvedReference.getSource();
        if (ktSourceElement2 == null) {
            ktSourceElement2 = source = expression.getSource();
        }
        if (expression instanceof FirDelegatedConstructorCall) {
            FirDeprecationInfo firDeprecationInfo = DeprecationUtilsKt.getDeprecation(referencedSymbol, context.getSession(), expression);
            if (firDeprecationInfo == null) {
                return;
            }
            FirDeprecationInfo constructorOnlyDeprecation = firDeprecationInfo;
            boolean isTypealiasExpansion = AbbreviatedTypeAttributeKt.isTypealiasExpansion(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(((FirDelegatedConstructorCall)expression).getConstructedTypeRef()), context.getSession(), null, 2, null));
            this.reportApiStatus$checkers(source, referencedSymbol, isTypealiasExpansion, constructorOnlyDeprecation, reporter, context);
        } else {
            this.reportApiStatusIfNeeded$checkers(source, referencedSymbol, context, reporter, expression);
        }
        this.reportCallToDeprecatedOverrideOfHidden(expression, source, referencedSymbol, reporter, context);
    }

    private final void reportCallToDeprecatedOverrideOfHidden(FirStatement expression, KtSourceElement source, FirBasedSymbol<?> referencedSymbol, DiagnosticReporter reporter, CheckerContext context) {
        if (!(expression instanceof FirQualifiedAccessExpression)) {
            return;
        }
        if (((FirQualifiedAccessExpression)expression).getNonFatalDiagnostics().contains(ConeCallToDeprecatedOverrideOfHidden.INSTANCE)) {
            FirCallableSymbol firCallableSymbol = referencedSymbol instanceof FirSyntheticPropertySymbol ? (FirSyntheticPropertySymbol)referencedSymbol : null;
            FirCallableSymbol unwrappedSymbol = firCallableSymbol != null && (firCallableSymbol = ((FirSyntheticPropertySymbol)firCallableSymbol).getGetterSymbol()) != null && (firCallableSymbol = ((FirSyntheticPropertyAccessorSymbol)firCallableSymbol).getDelegateFunctionSymbol()) != null ? firCallableSymbol : (referencedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)referencedSymbol : null);
            FirCallableSymbol firCallableSymbol2 = unwrappedSymbol;
            String callableName = firCallableSymbol2 != null && (firCallableSymbol2 = firCallableSymbol2.getCallableId()) != null && (firCallableSymbol2 = firCallableSymbol2.getCallableName()) != null ? firCallableSymbol2.asString() : null;
            String message2 = this.getDeprecatedOverrideOfHiddenMessage$checkers(callableName);
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getDEPRECATION(), referencedSymbol, (Object)message2, (DiagnosticContext)context, null, (int)32, null);
        }
    }

    @NotNull
    public final Map<String, String> getDeprecatedOverrideOfHiddenReplacements$checkers() {
        return DeprecatedOverrideOfHiddenReplacements;
    }

    @NotNull
    public final String getDeprecatedOverrideOfHiddenMessage$checkers(@Nullable String callableName) {
        String getFirstOrLastReplacement = DeprecatedOverrideOfHiddenReplacements.get(callableName);
        return getFirstOrLastReplacement != null ? "This declaration will be renamed in a future version of Kotlin. Please consider using the '" + getFirstOrLastReplacement + "' stdlib extension if the collection supports fast random access." : "This declaration is redundant in Kotlin and might be removed soon.";
    }

    private final boolean isDelegatedPropertySelfAccess(FirStatement $this$isDelegatedPropertySelfAccess, CheckerContext context, FirBasedSymbol<?> referencedSymbol) {
        KtSourceElement ktSourceElement = $this$isDelegatedPropertySelfAccess.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            return false;
        }
        List<FirDeclaration> containers = context.getContainingDeclarations();
        int size = containers.size();
        Object fir = referencedSymbol.getFir();
        return Intrinsics.areEqual((Object)CollectionsKt.getOrNull(containers, (int)(size - 1)), fir) || Intrinsics.areEqual((Object)CollectionsKt.getOrNull(containers, (int)(size - 2)), fir);
    }

    public final void reportApiStatusIfNeeded$checkers(@Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @Nullable FirElement callSite) {
        Intrinsics.checkNotNullParameter(referencedSymbol, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeprecationInfo firDeprecationInfo = this.getWorstDeprecation(callSite, referencedSymbol, context);
        if (firDeprecationInfo == null) {
            return;
        }
        FirDeprecationInfo deprecation = firDeprecationInfo;
        boolean isTypealiasExpansion = this.isTypealiasExpansionOf(deprecation, referencedSymbol, callSite, context);
        this.reportApiStatus$checkers(source, referencedSymbol, isTypealiasExpansion, deprecation, reporter, context);
    }

    public static /* synthetic */ void reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker firDeprecationChecker, KtSourceElement ktSourceElement, FirBasedSymbol firBasedSymbol, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirElement firElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            firElement = null;
        }
        firDeprecationChecker.reportApiStatusIfNeeded$checkers(ktSourceElement, firBasedSymbol, checkerContext, diagnosticReporter, firElement);
    }

    private final boolean isTypealiasExpansionOf(FirDeprecationInfo $this$isTypealiasExpansionOf, FirBasedSymbol<?> referencedSymbol, FirElement callSite, CheckerContext context) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = referencedSymbol;
        if (firBasedSymbol instanceof FirConstructorSymbol) {
            FirTypeAliasSymbol firTypeAliasSymbol;
            TypeAliasConstructorInfo<?> typeAliasConstructorInfo = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo((FirConstructorSymbol)referencedSymbol);
            if (typeAliasConstructorInfo != null && (firTypeAliasSymbol = typeAliasConstructorInfo.getTypeAliasSymbol()) != null) {
                FirTypeAliasSymbol it = firTypeAliasSymbol;
                boolean bl2 = false;
                bl = INSTANCE.isTypealiasExpansionOf($this$isTypealiasExpansionOf, it, callSite, context);
            } else {
                bl = false;
            }
        } else if (!(firBasedSymbol instanceof FirTypeAliasSymbol)) {
            bl = false;
        } else {
            FirDeprecationInfo it = DeprecationUtilsKt.getOwnDeprecation(referencedSymbol, context.getSession(), callSite);
            boolean bl3 = false;
            bl = it == null || it.compareTo($this$isTypealiasExpansionOf) < 0;
        }
        return bl;
    }

    public final void reportApiStatus$checkers(@Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol, boolean isTypealiasExpansion, @NotNull FirDeprecationInfo deprecationInfo2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(referencedSymbol, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)deprecationInfo2, (String)"deprecationInfo");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FirDeprecationInfo firDeprecationInfo = deprecationInfo2;
        if (firDeprecationInfo instanceof FutureApiDeprecationInfo) {
            this.reportApiNotAvailable(source, (FutureApiDeprecationInfo)deprecationInfo2, reporter, context);
        } else if (firDeprecationInfo instanceof RequireKotlinDeprecationInfo) {
            this.reportVersionRequirementDeprecation(source, referencedSymbol, (RequireKotlinDeprecationInfo)deprecationInfo2, reporter, context);
        } else {
            this.reportDeprecation(source, referencedSymbol, isTypealiasExpansion, deprecationInfo2, reporter, context);
        }
    }

    private final void reportVersionRequirementDeprecation(KtSourceElement source, FirBasedSymbol<?> referencedSymbol, RequireKotlinDeprecationInfo deprecationInfo2, DiagnosticReporter reporter, CheckerContext context) {
        String string;
        KtDiagnosticFactory4<FirBasedSymbol<?>, VersionRequirement.Version, String, String> diagnostic = WhenMappings.$EnumSwitchMapping$0[deprecationInfo2.getDeprecationLevel().ordinal()] == 1 ? FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION() : FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION_ERROR();
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
        switch (WhenMappings.$EnumSwitchMapping$1[deprecationInfo2.getVersionRequirement().getKind().ordinal()]) {
            case 1: {
                string = KotlinCompilerVersion.VERSION;
                break;
            }
            case 2: {
                string = languageVersionSettings.getLanguageVersion().getVersionString();
                break;
            }
            case 3: {
                string = languageVersionSettings.getApiVersion().getVersionString();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String currentVersionString = string;
        AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)source;
        VersionRequirement.Version version = deprecationInfo2.getVersionRequirement().getVersion();
        String string2 = deprecationInfo2.getMessage(context.getSession());
        if (string2 == null) {
            string2 = "";
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, diagnostic, referencedSymbol, (Object)version, (Object)currentVersionString, (Object)string2, (DiagnosticContext)context, null, (int)128, null);
    }

    private final void reportDeprecation(KtSourceElement source, FirBasedSymbol<?> referencedSymbol, boolean isTypealiasExpansion, FirDeprecationInfo deprecationInfo2, DiagnosticReporter reporter, CheckerContext context) {
        if (!isTypealiasExpansion) {
            KtDiagnosticFactory2<FirBasedSymbol<?>, String> ktDiagnosticFactory2;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo2.getDeprecationLevel().ordinal()]) {
                case 2: 
                case 3: {
                    ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION_ERROR();
                    break;
                }
                case 1: {
                    ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory2;
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)source;
            String string = deprecationInfo2.getMessage(context.getSession());
            if (string == null) {
                string = "";
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, diagnostic, referencedSymbol, (Object)string, (DiagnosticContext)context, null, (int)32, null);
        } else {
            KtDiagnosticFactory3<FirBasedSymbol<?>, FirBasedSymbol<?>, String> ktDiagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo2.getDeprecationLevel().ordinal()]) {
                case 2: 
                case 3: {
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION_ERROR();
                    break;
                }
                case 1: {
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtDiagnosticFactory3<FirBasedSymbol<?>, FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)source;
            String string = deprecationInfo2.getMessage(context.getSession());
            if (string == null) {
                string = "";
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, diagnostic, referencedSymbol, referencedSymbol, (Object)string, (DiagnosticContext)context, null, (int)64, null);
        }
    }

    private final void reportApiNotAvailable(KtSourceElement source, FutureApiDeprecationInfo deprecationInfo2, DiagnosticReporter reporter, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getAPI_NOT_AVAILABLE(), (Object)deprecationInfo2.getSinceVersion(), (Object)context.getLanguageVersionSettings().getApiVersion(), (DiagnosticContext)context, null, (int)32, null);
    }

    private final FirDeprecationInfo getWorstDeprecation(FirElement callSite, FirBasedSymbol<?> symbol, CheckerContext context) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Object[] objectArray = new FirDeprecationInfo[2];
        FirConstructorSymbol firConstructorSymbol = symbol instanceof FirConstructorSymbol ? (FirConstructorSymbol)symbol : null;
        objectArray[0] = firConstructorSymbol != null && (firClassLikeSymbol = this.classSymbolItIsCalledThrough(firConstructorSymbol, context)) != null ? DeprecationUtilsKt.getDeprecation((FirBasedSymbol)firClassLikeSymbol, context.getSession(), callSite) : null;
        objectArray[1] = DeprecationUtilsKt.getDeprecation(symbol, context.getSession(), callSite);
        List deprecationInfos = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (FirDeprecationInfo)CollectionsKt.maxOrNull((Iterable)deprecationInfos);
    }

    private final FirClassLikeSymbol<?> classSymbolItIsCalledThrough(FirConstructorSymbol $this$classSymbolItIsCalledThrough, CheckerContext context) {
        TypeAliasConstructorInfo<?> typeAliasConstructorInfo = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo($this$classSymbolItIsCalledThrough);
        return typeAliasConstructorInfo != null && (typeAliasConstructorInfo = typeAliasConstructorInfo.getTypeAliasSymbol()) != null ? (FirClassLikeSymbol)((Object)typeAliasConstructorInfo) : (FirClassLikeSymbol)FirHelpersKt.toRegularClassSymbol($this$classSymbolItIsCalledThrough.getResolvedReturnTypeRef(), context.getSession());
    }

    static {
        Object[] objectArray = new KtFakeSourceElementKind[]{KtFakeSourceElementKind.PropertyFromParameter.INSTANCE, KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE};
        filteredSourceKinds = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"getFirst", (Object)"first()"), TuplesKt.to((Object)"getLast", (Object)"last()"), TuplesKt.to((Object)"toArray", null)};
        DeprecatedOverrideOfHiddenReplacements = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            try {
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

