/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirContextParametersLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeprecatedDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "onlyLegacyContextReceivers", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextReceiversDeprecatedDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextReceiversDeprecatedDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeprecatedDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1740#2,3:51\n*S KotlinDebug\n*F\n+ 1 FirContextReceiversDeprecatedDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextReceiversDeprecatedDeclarationChecker\n*L\n47#1:51,3\n*E\n"})
public final class FirContextReceiversDeprecatedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextReceiversDeprecatedDeclarationChecker INSTANCE = new FirContextReceiversDeprecatedDeclarationChecker();

    private FirContextReceiversDeprecatedDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters)) {
            return;
        }
        if (declaration instanceof FirCallableDeclaration && !(declaration instanceof FirAnonymousFunction) && this.onlyLegacyContextReceivers(((FirCallableDeclaration)declaration).getContextParameters())) {
            if (declaration instanceof FirConstructor && !(declaration instanceof FirPrimaryConstructor)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirConstructor)declaration).getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getCONTEXT_CLASS_OR_CONSTRUCTOR(), (DiagnosticContext)context, null, (int)8, null);
            } else {
                String message2 = FirContextParametersLanguageVersionSettingsChecker.INSTANCE.getMessage(context.getLanguageVersionSettings());
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirCallableDeclaration)declaration).getSource()), FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED(), (Object)message2, (DiagnosticContext)context, null, (int)16, null);
            }
        }
        if (declaration instanceof FirRegularClass && this.onlyLegacyContextReceivers(((FirRegularClass)declaration).getContextParameters())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirRegularClass)declaration).getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getCONTEXT_CLASS_OR_CONSTRUCTOR(), (DiagnosticContext)context, null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean onlyLegacyContextReceivers(List<? extends FirValueParameter> $this$onlyLegacyContextReceivers) {
        FirValueParameter it;
        if (((Collection)$this$onlyLegacyContextReceivers).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$all$iv = $this$onlyLegacyContextReceivers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (FirValueParameter)element$iv;
            boolean bl2 = false;
        } while (FirValueParameterKindKt.isLegacyContextReceiver(it));
        return false;
    }
}

