/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Collections;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import java.util.function.IntUnaryOperator;

interface IndexedSeqModule {

    public static interface Search {
        public static <T> int binarySearch(IndexedSeq<T> seq, IntUnaryOperator comparison) {
            int low = 0;
            int high = seq.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = comparison.applyAsInt(mid);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }
    }

    public static class Slice {
        static <T> int indexOfSlice(IndexedSeq<T> source, Iterable<? extends T> slice, int from) {
            if (source.isEmpty()) {
                return from == 0 && Collections.isEmpty(slice) ? 0 : -1;
            }
            IndexedSeq<T> _slice = Slice.toIndexedSeq(slice);
            int maxIndex = source.length() - _slice.length();
            return Slice.findSlice(source, _slice, Math.max(from, 0), maxIndex);
        }

        static <T> int lastIndexOfSlice(IndexedSeq<T> source, Iterable<? extends T> slice, int end) {
            if (end < 0) {
                return -1;
            }
            if (source.isEmpty()) {
                return Collections.isEmpty(slice) ? 0 : -1;
            }
            if (Collections.isEmpty(slice)) {
                int len = source.length();
                return len < end ? len : end;
            }
            int index2 = 0;
            int result2 = -1;
            IndexedSeq<T> _slice = Slice.toIndexedSeq(slice);
            int maxIndex = source.length() - _slice.length();
            while (index2 <= maxIndex) {
                int indexOfSlice = Slice.findSlice(source, _slice, index2, maxIndex);
                if (indexOfSlice < 0) {
                    return result2;
                }
                if (indexOfSlice <= end) {
                    result2 = indexOfSlice;
                    index2 = indexOfSlice + 1;
                    continue;
                }
                return result2;
            }
            return result2;
        }

        private static <T> int findSlice(IndexedSeq<T> source, IndexedSeq<T> slice, int index2, int maxIndex) {
            while (index2 <= maxIndex) {
                if (source.startsWith(slice, index2)) {
                    return index2;
                }
                ++index2;
            }
            return -1;
        }

        private static <T> IndexedSeq<T> toIndexedSeq(Iterable<? extends T> iterable) {
            return iterable instanceof IndexedSeq ? (Vector<? extends T>)iterable : Vector.ofAll(iterable);
        }
    }
}

