/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsConnectionUtil;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingToSMTRunnerEventsConvertor
extends GoogleCloudTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestingToSMTRunnerEventsConvertor.class.getName());
    private final Map<String, GoogleCloudTestProxy> myRunningTestsFullNameToProxy = new HashMap<String, GoogleCloudTestProxy>();
    private final Set<AbstractTestProxy> myFailedTestsSet = new HashSet<AbstractTestProxy>();
    private final List<GoogleCloudTestEventsListener> myEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator = null;
    private GoogleCloudTestProxy lastUpdatedTest = null;

    public GoogleCloudTestingToSMTRunnerEventsConvertor(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        this.myTestsRootNode = testsRootNode;
        this.myTestFrameworkName = testFrameworkName;
    }

    @Override
    public void setLocator(@NotNull SMTestLocator customLocator) {
        this.myLocator = customLocator;
    }

    @Override
    public void addEventsListener(@NotNull GoogleCloudTestEventsListener listener) {
        this.myEventsListeners.add(listener);
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(() -> {
            this.myTestsRootNode.setScheduled();
            this.lastUpdatedTest = null;
            this.fireOnTestingStarted(true);
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(() -> this.myTestsRootNode.setTestsReporterAttached());
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = null;
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.hasScheduledOrPendingConfigurations()) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setTerminated();
                } else {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setFinished();
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.onUncapturedOutput(this.prepareFinishString(), ProcessOutputTypes.STDOUT);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.onUncapturedOutput("\nPricing information: https://firebase.google.com/pricing \n", ProcessOutputTypes.STDOUT);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }

            private String prepareFinishString() {
                return CloudTestingUtils.shouldShowProgressTimestamps() ? "Finish\t" + System.currentTimeMillis() + "\n" : "Finish\n";
            }
        });
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
    }

    @Override
    public void onTestStarted(@NotNull GoogleCloudTestStartedEvent testStartedEvent) {
        this.addToInvokeLater(() -> {
            String configuration = testStartedEvent.getConfiguration();
            String className = testStartedEvent.getClassName();
            String testName = testStartedEvent.getName();
            String locationUrl = testStartedEvent.getLocationUrl();
            String fullName = this.getFullTestName(configuration, className, testName);
            if (this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
                this.logProblem("Test [" + fullName + "] has been already started");
                if (GoogleCloudTestResultsConnectionUtil.isInDebugMode()) {
                    return;
                }
            }
            GoogleCloudTestProxy parentSuite = this.findOrCreateChildNode(this.myTestsRootNode, configuration, true);
            parentSuite = this.findOrCreateChildNode(parentSuite, className, true);
            GoogleCloudTestProxy testProxy = new GoogleCloudTestProxy(testName, false, locationUrl);
            if (this.myLocator != null) {
                testProxy.setLocator(this.myLocator);
            }
            this.lastUpdatedTest = testProxy;
            parentSuite.addChild(testProxy);
            this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
            testProxy.setStarted();
            this.fireOnTestStarted(testProxy);
        });
    }

    private String getFullTestName(String configuration, String className, String testName) {
        return configuration + ":" + className + ":" + testName;
    }

    private GoogleCloudTestProxy findOrCreateChildNode(GoogleCloudTestProxy parent, String nodeName, boolean shouldStartIfNotFound) {
        GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)((Object)Iterables.find(parent.getChildren(), this.getNodeNamed(nodeName), null));
        if (testProxy == null) {
            testProxy = new GoogleCloudTestProxy(nodeName, true, null);
            parent.addChild(testProxy);
            if (shouldStartIfNotFound) {
                testProxy.setStarted();
                this.fireOnTestStarted(testProxy);
            }
        }
        return testProxy;
    }

    private Predicate<GoogleCloudTestProxy> getNodeNamed(String nodeName) {
        return testProxy -> testProxy.getName().equals(nodeName);
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        this.addToInvokeLater(() -> {
            throw new RuntimeException("Unsupported event 'onSuiteStarted'");
        });
    }

    @Override
    public void onSetTestRunId(@NotNull SetTestRunIdEvent setTestRunIdEvent) {
        this.myTestsRootNode.setTestRunId(setTestRunIdEvent.getTestRunId());
    }

    @Override
    public void onSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
        this.myTestsRootNode.setScheduledActive();
        for (GoogleCloudTestProxy googleCloudTestProxy : this.myTestsRootNode.getChildren()) {
            googleCloudTestProxy.setScheduledActive();
        }
    }

    @Override
    public void onConfigurationStopped(@NotNull TestConfigurationStoppedEvent configurationStoppedEvent) {
        this.addToInvokeLater(() -> {
            String configurationName = configurationStoppedEvent.getName();
            for (GoogleCloudTestProxy googleCloudTestProxy : this.myTestsRootNode.getChildren()) {
                if (!googleCloudTestProxy.getName().equals(configurationName)) continue;
                List<GoogleCloudTestProxy> suiteTests = googleCloudTestProxy.getAllTests();
                suiteTests.remove((Object)googleCloudTestProxy);
                for (GoogleCloudTestProxy suiteTest : suiteTests) {
                    this.stopTest(suiteTest, configurationStoppedEvent.getStopReason());
                }
                this.stopTest(googleCloudTestProxy, configurationStoppedEvent.getStopReason());
                googleCloudTestProxy.setDuration(configurationStoppedEvent.getTestDuration());
                return;
            }
            throw new IllegalStateException("Could not find configuration: " + configurationName);
        });
    }

    @Override
    public void onConfigurationStarted(@NotNull TestConfigurationStartedEvent configurationStartedEvent) {
        this.addToInvokeLater(() -> {
            String configurationName = configurationStartedEvent.getName();
            GoogleCloudTestProxy newConfiguration = this.findOrCreateChildNode(this.myTestsRootNode, configurationName, false);
            if (this.myLocator != null) {
                newConfiguration.setLocator(this.myLocator);
            }
            newConfiguration.setStarted();
            this.fireOnSuiteStarted(newConfiguration);
            if (!this.myTestsRootNode.isInProgress()) {
                this.myTestsRootNode.setStarted();
                this.fireOnTestingStarted(false);
            }
        });
    }

    @Override
    public void onConfigurationProgress(@NotNull TestConfigurationProgressEvent configurationProgressEvent) {
        this.addToInvokeLater(() -> {
            String configurationName = configurationProgressEvent.getName();
            String progressText = configurationProgressEvent.getText();
            GoogleCloudTestProxy configurationProxy = (GoogleCloudTestProxy)((Object)((Object)Iterables.find(this.myTestsRootNode.getChildren(), this.getNodeNamed(configurationName), null)));
            if (configurationProxy == null) {
                throw new IllegalStateException("Could not report progress for non-existing configuration: " + configurationName);
            }
            configurationProxy.addStdOutput(progressText, ProcessOutputTypes.STDOUT, true);
        });
    }

    @Override
    public void onConfigurationScheduled(@NotNull TestConfigurationScheduledEvent configurationScheduledEvent) {
        this.addToInvokeLater(() -> {
            String configurationName = configurationScheduledEvent.getName();
            String locationUrl = configurationScheduledEvent.getLocationUrl();
            GoogleCloudTestProxy newConfiguration = new GoogleCloudTestProxy(configurationName, true, locationUrl);
            if (this.myLocator != null) {
                newConfiguration.setLocator(this.myLocator);
            }
            this.myTestsRootNode.addChild(newConfiguration);
            newConfiguration.setScheduled();
            this.fireOnSuiteStarted(newConfiguration);
        });
    }

    private void stopTest(GoogleCloudTestProxy test, CloudTestingUtils.ConfigurationStopReason stopReason) {
        switch (stopReason) {
            case FINISHED: {
                test.setFinished();
                break;
            }
            case INFRASTRUCTURE_FAILURE: {
                test.setInfrastructureFailed();
                break;
            }
            case TRIGGERING_ERROR: {
                test.setTriggeringError();
                break;
            }
            case TIMED_OUT: {
                test.setTimeout();
            }
        }
        this.fireOnTestFinished(test);
    }

    @Override
    public void onTestFinished(@NotNull GoogleCloudTestFinishedEvent testFinishedEvent) {
        this.addToInvokeLater(() -> {
            String configuration = testFinishedEvent.getConfiguration();
            String className = testFinishedEvent.getClassName();
            String testName = testFinishedEvent.getName();
            long duration = testFinishedEvent.getDuration() == null ? -1L : testFinishedEvent.getDuration();
            String fullTestName = this.getFullTestName(configuration, className, testName);
            GoogleCloudTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                return;
            }
            this.lastUpdatedTest = testProxy;
            testProxy.setDuration(duration);
            testProxy.setFinished();
            this.myRunningTestsFullNameToProxy.remove(fullTestName);
            this.fireOnTestFinished(testProxy);
        });
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        this.addToInvokeLater(() -> {
            throw new RuntimeException("Unsupported event 'onSuiteFinished'");
        });
    }

    @Override
    public void onConfigurationFinished(@NotNull TestConfigurationFinishedEvent configurationFinishedEvent) {
        this.addToInvokeLater(() -> {
            throw new RuntimeException("Unsupported event 'onConfigurationFinished'");
        });
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        this.addToInvokeLater(() -> {
            GoogleCloudTestProxy currentProxy = this.findCurrentTestOrSuite();
            if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                currentProxy.addStdErr(text, true);
            } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                currentProxy.addSystemOutput(text);
            } else {
                currentProxy.addStdOutput(text, outputType, true);
            }
        });
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.addToInvokeLater(() -> {
            GoogleCloudTestProxy currentProxy = this.findCurrentTestOrSuite();
            currentProxy.addError(localizedMessage, stackTrace, isCritical);
        });
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.addToInvokeLater(() -> this.fireOnCustomProgressTestsCategory(categoryName, testCount));
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(() -> this.fireOnCustomProgressTestStarted());
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(() -> this.fireOnCustomProgressTestFailed());
    }

    @Override
    public void onTestFailure(@NotNull GoogleCloudTestFailedEvent testFailedEvent) {
        this.addToInvokeLater(() -> {
            String configuration = testFailedEvent.getConfiguration();
            String className = testFailedEvent.getClassName();
            String testName = (String)ObjectUtils.assertNotNull((Object)testFailedEvent.getName());
            String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
            String stackTrace = testFailedEvent.getStacktrace();
            boolean isTestError = testFailedEvent.isTestError();
            String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
            String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
            boolean inDebugMode = GoogleCloudTestResultsConnectionUtil.isInDebugMode();
            String fullTestName = this.getFullTestName(configuration, className, testName);
            GoogleCloudTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}, message = {" + localizedMessage + "}, stackTrace = {" + stackTrace + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                if (inDebugMode) {
                    return;
                }
                this.onTestStarted(new GoogleCloudTestStartedEvent(testName, null, configuration, className));
                testProxy = this.getProxyByFullTestName(fullTestName);
            }
            if (testProxy == null) {
                return;
            }
            this.lastUpdatedTest = testProxy;
            if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                if (this.myFailedTestsSet.contains((Object)testProxy)) {
                    this.logProblem("Duplicate failure for test [" + fullTestName + "]: msg = " + localizedMessage + ", stacktrace = " + stackTrace);
                    if (inDebugMode) {
                        return;
                    }
                }
                testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText);
            } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
            } else {
                this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\nActual:\n" + comparisonFailureActualText);
            }
            this.myFailedTestsSet.add(testProxy);
            this.fireOnTestFailed(testProxy);
        });
    }

    @Override
    public void onTestIgnored(@NotNull GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        this.addToInvokeLater(() -> {
            String configuration = testIgnoredEvent.getConfiguration();
            String className = testIgnoredEvent.getClassName();
            String testName = (String)ObjectUtils.assertNotNull((Object)testIgnoredEvent.getName());
            String ignoreComment = testIgnoredEvent.getIgnoreComment();
            if (StringUtil.isEmpty((String)ignoreComment)) {
                ignoreComment = SmRunnerBundle.message((String)"sm.test.runner.states.test.is.ignored", (Object[])new Object[0]);
            }
            String stackTrace = testIgnoredEvent.getStacktrace();
            String fullTestName = this.getFullTestName(configuration, className, testName);
            GoogleCloudTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                boolean debugMode = GoogleCloudTestResultsConnectionUtil.isInDebugMode();
                this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, message = {" + ignoreComment + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                if (debugMode) {
                    return;
                }
                this.onTestStarted(new GoogleCloudTestStartedEvent(testName, null, configuration, className));
                testProxy = this.getProxyByFullTestName(fullTestName);
            }
            if (testProxy == null) {
                return;
            }
            this.lastUpdatedTest = testProxy;
            testProxy.setTestIgnored(ignoreComment, stackTrace);
            this.fireOnTestIgnored(testProxy);
        });
    }

    @Override
    public void onTestOutput(@NotNull GoogleCloudTestOutputEvent testOutputEvent) {
        this.addToInvokeLater(() -> {
            String configuration = testOutputEvent.getConfiguration();
            String className = testOutputEvent.getClassName();
            String testName = testOutputEvent.getName();
            String text = testOutputEvent.getText();
            boolean stdOut = testOutputEvent.getOutputType() == ProcessOutputTypes.STDOUT;
            String fullTestName = this.getFullTestName(configuration, className, testName);
            GoogleCloudTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, isStdOut = " + stdOut + ", text = {" + text + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                return;
            }
            this.lastUpdatedTest = testProxy;
            if (stdOut) {
                testProxy.addStdOutput(text, ProcessOutputTypes.STDOUT, true);
            } else {
                testProxy.addStdErr(text, true);
            }
        });
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.addToInvokeLater(() -> this.fireOnTestsCountInSuite(count));
    }

    @Nullable
    protected GoogleCloudTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    private void fireOnTestingStarted(boolean printTestingStartedTime) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootNode, printTestingStartedTime);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootNode);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnTestStarted(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(() -> {
            Application application;
            this.myEventsListeners.clear();
            if (!(this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                this.logProblem("Not all events were processed! " + this.dumpRunningTestsNames());
            }
            this.myRunningTestsFullNameToProxy.clear();
        });
    }

    private GoogleCloudTestProxy findCurrentTestOrSuite() {
        if (this.lastUpdatedTest != null) {
            return this.lastUpdatedTest;
        }
        return this.myTestsRootNode;
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    private void logProblem(String msg) {
        GoogleCloudTestingToSMTRunnerEventsConvertor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GoogleCloudTestingToSMTRunnerEventsConvertor.logProblem(log, msg, GoogleCloudTestResultsConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text = GoogleCloudTestingToSMTRunnerEventsConvertor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text);
        } else {
            log.warn(text);
        }
    }
}

