/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.tracer.agent;

import com.android.tools.tracer.agent.TraceProfile;
import com.android.tools.tracer.agent.objectweb.asm.AnnotationVisitor;
import com.android.tools.tracer.agent.objectweb.asm.Label;
import com.android.tools.tracer.agent.objectweb.asm.MethodVisitor;
import com.android.tools.tracer.agent.objectweb.asm.Type;
import com.android.tools.tracer.agent.objectweb.asm.commons.AdviceAdapter;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class TraceMethodVisitor
extends AdviceAdapter {
    private final String name;
    private final String className;
    private final String tag;
    private final TraceProfile profile;
    private Label beginLabel;
    private boolean enabled;

    public TraceMethodVisitor(MethodVisitor mv, String className, int access, String name, String desc, TraceProfile profile) {
        super(589824, mv, access, name, desc);
        this.className = className;
        this.name = name;
        this.tag = TraceMethodVisitor.buildTag(className, name, desc);
        this.profile = profile;
        this.enabled = profile.shouldInstrument(className, name);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.enabled = this.enabled || this.profile.shouldInstrument(desc);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visitCode() {
        super.visitCode();
        if (!this.enabled) {
            return;
        }
        if (this.profile.start(this.className, this.name)) {
            this.invoke("start", "()V", new String[0]);
        }
        this.invoke("begin", "(Ljava/lang/String;)V", this.tag);
    }

    @Override
    protected void onMethodEnter() {
        super.onMethodEnter();
        if (!this.enabled) {
            return;
        }
        this.beginLabel = this.newLabel();
        this.visitLabel(this.beginLabel);
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.enabled) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    this.traceEnd();
                }
            }
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.enabled) {
            Label endLabel = this.newLabel();
            this.visitTryCatchBlock(this.beginLabel, endLabel, endLabel, null);
            this.visitLabel(endLabel);
            this.visitFrame(-1, 0, null, 1, new Object[]{"java/lang/Throwable"});
            this.traceEnd();
            super.throwException();
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    private void traceEnd() {
        this.invoke("end", "()V", new String[0]);
        if (this.profile.shouldFlush(this.className, this.name)) {
            this.invoke("flush", "()V", new String[0]);
        }
    }

    private static String buildTag(String className, String method, String desc) {
        String name = TraceMethodVisitor.simplifyClassName(className, 47);
        String returnClass = TraceMethodVisitor.simplifyClassName(Type.getReturnType(desc).getClassName(), 46);
        String args = Stream.of(Type.getArgumentTypes(desc)).map(t -> TraceMethodVisitor.simplifyClassName(t.getClassName(), 46)).collect(Collectors.joining(", "));
        return returnClass + " " + name + "." + method + "(" + args + ")";
    }

    private static String simplifyClassName(String className, int charSeparator) {
        return className.substring(className.lastIndexOf(charSeparator) + 1);
    }

    private void invoke(String method, String desc, String ... args) {
        for (String arg : args) {
            this.visitLdcInsn(arg);
        }
        this.visitMethodInsn(184, "com/android/tools/tracer/agent/Tracer", method, desc, false);
    }
}

