/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlDocument;
import com.android.resources.NamespaceReferenceRewriter;
import com.android.utils.PositionXmlParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XmlLoader {
    private XmlLoader() {
    }

    @NotNull
    public static XmlDocument load(@NotNull KeyResolver<String> selectors, @NotNull PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, @Nullable String displayName, @NotNull File xmlFile, @NotNull InputStream inputStream, @NotNull XmlDocument.Type type, @Nullable String namespace, @NotNull DocumentModel<ManifestModel.NodeTypes> model, boolean rewriteNamespaces) throws IOException, SAXException, ParserConfigurationException {
        Document domDocument = PositionXmlParser.parse((InputStream)inputStream);
        return XmlLoader.load(domDocument, selectors, systemPropertyResolver, displayName, xmlFile, type, namespace, model, rewriteNamespaces);
    }

    @NotNull
    public static XmlDocument load(@NotNull Document domDocument, @NotNull KeyResolver<String> selectors, @NotNull PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, @Nullable String displayName, @NotNull File xmlFile, @NotNull XmlDocument.Type type, @Nullable String namespace, @NotNull DocumentModel<ManifestModel.NodeTypes> model, boolean rewriteNamespaces) throws IOException, SAXException, ParserConfigurationException {
        String namespaceOrPackageName;
        Element rootElement = domDocument.getDocumentElement();
        String string = namespaceOrPackageName = namespace != null ? namespace : rootElement.getAttribute("package");
        if (rewriteNamespaces) {
            new NamespaceReferenceRewriter(namespaceOrPackageName, (t, n) -> namespaceOrPackageName).rewriteManifestNode((Node)rootElement, true);
        }
        return new XmlDocument(new SourceFile(xmlFile, displayName), selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, namespaceOrPackageName, model);
    }

    @NotNull
    public static XmlDocument load(@NotNull KeyResolver<String> selectors, @NotNull PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, @NotNull SourceFile sourceFile, @NotNull String xml, @NotNull XmlDocument.Type type, @Nullable String namespace, @NotNull DocumentModel<ManifestModel.NodeTypes> model) throws IOException, SAXException, ParserConfigurationException {
        Document domDocument = PositionXmlParser.parse((String)xml);
        Element rootElement = domDocument.getDocumentElement();
        @Nullable String namespaceOrPackageName = namespace != null ? namespace : rootElement.getAttribute("package");
        return new XmlDocument(sourceFile, selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, namespaceOrPackageName, model);
    }
}

