/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.android.icu.util.ExtendedCalendar;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import libcore.icu.ICU;
import libcore.icu.LocaleData;
import sun.util.locale.LanguageTag;

public class SimpleDateFormatData {
    private static final ConcurrentHashMap<String, SimpleDateFormatData> CACHE = new ConcurrentHashMap(3);
    private final Locale locale;
    private final boolean usesAsciiSpace;
    private final String fullTimeFormat;
    private final String longTimeFormat;
    private final String mediumTimeFormat;
    private final String shortTimeFormat;
    private final String fullDateFormat;
    private final String longDateFormat;
    private final String mediumDateFormat;
    private final String shortDateFormat;

    private SimpleDateFormatData(Locale locale) {
        this.locale = locale;
        this.usesAsciiSpace = SimpleDateFormatData.isBug266731719Locale(locale);
        ExtendedCalendar calendar = ICU.getExtendedCalendar(locale, "gregorian");
        String tmpFullTimeFormat = this.getDateTimePattern(calendar, -1, 0);
        if (tmpFullTimeFormat != null) {
            tmpFullTimeFormat = tmpFullTimeFormat.replace('v', 'z');
        }
        this.fullTimeFormat = tmpFullTimeFormat;
        this.longTimeFormat = this.getDateTimePattern(calendar, -1, 1);
        this.mediumTimeFormat = this.getDateTimePattern(calendar, -1, 2);
        this.shortTimeFormat = this.getDateTimePattern(calendar, -1, 3);
        this.fullDateFormat = this.getDateTimePattern(calendar, 0, -1);
        this.longDateFormat = this.getDateTimePattern(calendar, 1, -1);
        this.mediumDateFormat = this.getDateTimePattern(calendar, 2, -1);
        this.shortDateFormat = this.getDateTimePattern(calendar, 3, -1);
    }

    public static SimpleDateFormatData getInstance(Locale locale) {
        Objects.requireNonNull(locale, "locale can't be null");
        locale = LocaleData.getCompatibleLocaleForBug159514442(locale);
        String languageTag = locale.toLanguageTag();
        SimpleDateFormatData data = CACHE.get(languageTag);
        if (data != null) {
            return data;
        }
        data = new SimpleDateFormatData(locale);
        SimpleDateFormatData prev = CACHE.putIfAbsent(languageTag, data);
        if (prev != null) {
            return prev;
        }
        return data;
    }

    public static void initializeCacheInZygote() {
        SimpleDateFormatData.getInstance(Locale.ROOT);
        SimpleDateFormatData.getInstance(Locale.US);
        SimpleDateFormatData.getInstance(AndroidLocale.getDefault());
    }

    public String getDateFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortDateFormat;
            }
            case 2: {
                return this.mediumDateFormat;
            }
            case 1: {
                return this.longDateFormat;
            }
            case 0: {
                return this.fullDateFormat;
            }
        }
        throw new AssertionError();
    }

    public String getTimeFormat(int style2) {
        switch (style2) {
            case 3: {
                if (DateFormat.is24Hour == null) {
                    return this.shortTimeFormat;
                }
                return this.getTimePattern(DateFormat.is24Hour, false);
            }
            case 2: {
                if (DateFormat.is24Hour == null) {
                    return this.mediumTimeFormat;
                }
                return this.getTimePattern(DateFormat.is24Hour, true);
            }
            case 1: {
                return this.longTimeFormat;
            }
            case 0: {
                return this.fullTimeFormat;
            }
        }
        throw new AssertionError();
    }

    private String getDateTimePattern(ExtendedCalendar calendar, int dateStyle, int timeStyle) {
        String pattern = ICU.transformIcuDateTimePattern_forJavaText(calendar.getDateTimePattern(dateStyle, timeStyle));
        return this.postProcessPattern(pattern);
    }

    private String getTimePattern(boolean is24Hour, boolean withSecond) {
        String pattern = ICU.getTimePattern(this.locale, is24Hour, withSecond);
        return this.postProcessPattern(pattern);
    }

    private String postProcessPattern(String pattern) {
        if (pattern == null || !this.usesAsciiSpace) {
            return pattern;
        }
        return pattern.replace('\u202f', ' ');
    }

    private static boolean isBug266731719Locale(Locale locale) {
        if (locale == null) {
            return false;
        }
        String language = locale.getLanguage();
        if (language == null) {
            return false;
        }
        if (!"en".equals(language = LanguageTag.canonicalizeLanguage(language))) {
            return false;
        }
        String region = locale.getCountry();
        if (region == null || region.isEmpty()) {
            return true;
        }
        region = LanguageTag.canonicalizeRegion(region);
        return "US".equals(region);
    }
}

