/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.libcore.Flags;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime_Delegate;
import java.lang.ref.FinalizerReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();
    private static final Map<String, String> ABI_TO_INSTRUCTION_SET_MAP = new HashMap<String, String>(16);
    private static final long PREVENT_META_REFLECTION_BLOCKLIST_ACCESS = 142365358L;
    private static final long HIDE_MAXTARGETSDK_P_HIDDEN_APIS = 149997251L;
    private static final long HIDE_MAXTARGETSDK_Q_HIDDEN_APIS = 149994052L;
    private static final long ALLOW_TEST_API_ACCESS = 166236554L;
    static HiddenApiUsageLogger hiddenApiUsageLogger;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int SDK_VERSION_CUR_DEVELOPMENT = 10000;
    private static Consumer<String> nonSdkApiUsageConsumer;
    private int targetSdkVersion = 10000;
    private int notifyNativeInterval;
    private final AtomicInteger allocationCount = new AtomicInteger(0);
    private long[] disabledCompatChanges = new long[0];
    private static final List<Runnable> postCleanupCallbacks;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int CODE_PATH_TYPE_PRIMARY_APK = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int CODE_PATH_TYPE_SPLIT_APK = 2;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int CODE_PATH_TYPE_SECONDARY_DEX = 4;

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setHiddenApiUsageLogger(HiddenApiUsageLogger hiddenApiUsageLogger) {
        VMRuntime.hiddenApiUsageLogger = hiddenApiUsageLogger;
    }

    private static void hiddenApiUsed(int sampledValue, String appPackageName, String signature, int accessType, boolean accessDenied) {
        if (hiddenApiUsageLogger != null) {
            hiddenApiUsageLogger.hiddenApiUsed(sampledValue, appPackageName, signature, accessType, accessDenied);
        }
    }

    private VMRuntime() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public String[] properties() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMRuntime#properties()[Ljava/lang/String;", true, this);
    }

    public String bootClassPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#bootClassPath()Ljava/lang/String;", true, this);
    }

    public String classPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#classPath()Ljava/lang/String;", true, this);
    }

    public String vmVersion() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmVersion()Ljava/lang/String;", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public String vmLibrary() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmLibrary()Ljava/lang/String;", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public String vmInstructionSet() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmInstructionSet()Ljava/lang/String;", true, this);
    }

    @LayoutlibDelegate
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    @FastNative
    public boolean is64Bit() {
        return VMRuntime_Delegate.is64Bit(this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public boolean isCheckJniEnabled() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isCheckJniEnabled()Z", true, this) != 0;
    }

    public float getTargetHeapUtilization() {
        return OverrideMethod.invokeF("dalvik.system.VMRuntime#getTargetHeapUtilization()F", true, this);
    }

    public long getFinalizerTimeoutMs() {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#getFinalizerTimeoutMs()J", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        if (newTarget < 0.1f) {
            newTarget = 0.1f;
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage(maxTargetSdk=0, publicAlternatives="Use the {@code targetSdkVersion} attribute in the {@code uses-sdk} manifest tag instead.")
    public synchronized void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
        this.setTargetSdkVersionNative(this.targetSdkVersion);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public synchronized void setDisabledCompatChanges(long[] disabledCompatChanges) {
        this.disabledCompatChanges = disabledCompatChanges;
        this.setDisabledCompatChangesNative(this.disabledCompatChanges);
    }

    @FastNative
    private static int getSdkVersionNative(int n) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#getSdkVersionNative(I)I", true, null);
    }

    public static int getSdkVersion() {
        return SdkVersionContainer.sdkVersion;
    }

    public static int getSdkExtensionSLevel() {
        return SdkVersionContainer.sdkExtensionS;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public synchronized int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    private void setTargetSdkVersionNative(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setTargetSdkVersionNative(I)V", true, this);
    }

    @FastNative
    private static int getIntSystemProperty(String string2, int n) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#getIntSystemProperty(Ljava/lang/String;I)I", true, null);
    }

    private void setDisabledCompatChangesNative(long[] lArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setDisabledCompatChangesNative([J)V", true, this);
    }

    @Deprecated
    @UnsupportedAppUsage
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    @UnsupportedAppUsage
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void gcSoftReferences() {
    }

    @Deprecated
    @UnsupportedAppUsage
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private void nativeSetTargetHeapUtilization(float f) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#nativeSetTargetHeapUtilization(F)V", true, this);
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void trackExternalFree(long size) {
    }

    @Deprecated
    @UnsupportedAppUsage
    public long getExternalBytesAllocated() {
        return 0L;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void setHiddenApiExemptions(String[] stringArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setHiddenApiExemptions([Ljava/lang/String;)V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void setHiddenApiAccessLogSamplingRate(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setHiddenApiAccessLogSamplingRate(I)V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    @FastNative
    public Object newNonMovableArray(Class<?> clazz, int n) {
        return OverrideMethod.invokeA("dalvik.system.VMRuntime#newNonMovableArray(Ljava/lang/Class;I)Ljava/lang/Object;", true, this);
    }

    @LayoutlibDelegate
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public Object newUnpaddedArray(Class<?> clazz, int n) {
        return VMRuntime_Delegate.newUnpaddedArray(this, clazz, n);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    @FastNative
    public long addressOf(Object object) {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#addressOf(Ljava/lang/Object;)J", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public void clearGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clearGrowthLimit()V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void clampGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clampGrowthLimit()V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FastNative
    public boolean isNativeDebuggable() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isNativeDebuggable()Z", true, this) != 0;
    }

    public boolean isJavaDebuggable() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isJavaDebuggable()Z", true, this) != 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public void registerNativeAllocation(long l) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeAllocation(J)V", true, this);
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public void registerNativeAllocation(int bytes) {
        this.registerNativeAllocation((long)bytes);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public void registerNativeFree(long l) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeFree(J)V", true, this);
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public void registerNativeFree(int bytes) {
        this.registerNativeFree((long)bytes);
    }

    @LayoutlibDelegate
    private static int getNotifyNativeInterval() {
        return VMRuntime_Delegate.getNotifyNativeInterval();
    }

    public void notifyNativeAllocation() {
        int myNotifyNativeInterval = this.notifyNativeInterval;
        if (myNotifyNativeInterval == 0) {
            myNotifyNativeInterval = this.notifyNativeInterval = VMRuntime.getNotifyNativeInterval();
        }
        if (this.allocationCount.addAndGet(1) % myNotifyNativeInterval == 0) {
            this.notifyNativeAllocationsInternal();
        }
    }

    public void notifyNativeAllocationsInternal() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#notifyNativeAllocationsInternal()V", true, this);
    }

    @UnsupportedAppUsage
    public static void runFinalization(long timeout) {
        try {
            FinalizerReference.finalizeAllEnqueued((long)timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void requestConcurrentGC() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#requestConcurrentGC()V", true, this);
    }

    public void requestHeapTrim() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#requestHeapTrim()V", true, this);
    }

    public void trimHeap() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#trimHeap()V", true, this);
    }

    public void startHeapTaskProcessor() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#startHeapTaskProcessor()V", true, this);
    }

    public void stopHeapTaskProcessor() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#stopHeapTaskProcessor()V", true, this);
    }

    public void runHeapTasks() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#runHeapTasks()V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void updateProcessState(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#updateProcessState(I)V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void notifyStartupCompleted() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#notifyStartupCompleted()V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void preloadDexCaches() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#preloadDexCaches()V", true, this);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void registerAppInfo(String string2, String string3, String string4, String[] stringArray, int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerAppInfo(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;I)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static String getInstructionSet(String abi) {
        String instructionSet = ABI_TO_INSTRUCTION_SET_MAP.get(abi);
        if (instructionSet == null) {
            throw new IllegalArgumentException("Unsupported ABI: " + abi);
        }
        return instructionSet;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static boolean is64BitInstructionSet(String instructionSet) {
        return instructionSet != null && instructionSet.contains("64");
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitInstructionSet(VMRuntime.getInstructionSet(abi));
    }

    public static boolean isBootClassPathOnDisk(String string2) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isBootClassPathOnDisk(Ljava/lang/String;)Z", true, null) != 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void bootCompleted() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#bootCompleted()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void resetJitCounters() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#resetJitCounters()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static String getCurrentInstructionSet() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#getCurrentInstructionSet()Ljava/lang/String;", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void registerSensitiveThread() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerSensitiveThread()V", true, null);
    }

    public static void setSystemDaemonThreadPriority() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setSystemDaemonThreadPriority()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setNonSdkApiUsageConsumer(Consumer<String> consumer) {
        nonSdkApiUsageConsumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.post_cleanup_apis")
    public static void addPostCleanupCallback(Runnable runnable) {
        List<Runnable> list = postCleanupCallbacks;
        synchronized (list) {
            postCleanupCallbacks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.post_cleanup_apis")
    public static void removePostCleanupCallback(Runnable runnable) {
        List<Runnable> list = postCleanupCallbacks;
        synchronized (list) {
            postCleanupCallbacks.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostCleanup() {
        List<Runnable> list = postCleanupCallbacks;
        synchronized (list) {
            for (Runnable runnable : postCleanupCallbacks) {
                runnable.run();
            }
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setDedupeHiddenApiWarnings(boolean bl) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setDedupeHiddenApiWarnings(Z)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setProcessPackageName(String string2) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setProcessPackageName(Ljava/lang/String;)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setProcessDataDirectory(String string2) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setProcessDataDirectory(Ljava/lang/String;)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static boolean isValidClassLoaderContext(String string2) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isValidClassLoaderContext(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static DexFile.OptimizationInfo getBaseApkOptimizationInfo() {
        return (DexFile.OptimizationInfo)OverrideMethod.invokeA("dalvik.system.VMRuntime#getBaseApkOptimizationInfo()Ldalvik/system/DexFile$OptimizationInfo;", true, null);
    }

    public static boolean isVTrunkStableFlagEnabled() {
        return Flags.vApis();
    }

    public static boolean isArtTestFlagEnabled() {
        return com.android.art.flags.Flags.test();
    }

    public static long getFullGcCount() {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#getFullGcCount()J", true, null);
    }

    static {
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi-v7a", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86", "x86");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86_64", "x86_64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a", "arm64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a-hwasan", "arm64");
        ABI_TO_INSTRUCTION_SET_MAP.put("riscv64", "riscv64");
        nonSdkApiUsageConsumer = null;
        postCleanupCallbacks = new ArrayList<Runnable>();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface HiddenApiUsageLogger {
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public static final int ACCESS_METHOD_NONE = 0;
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public static final int ACCESS_METHOD_REFLECTION = 1;
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public static final int ACCESS_METHOD_JNI = 2;
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public static final int ACCESS_METHOD_LINKING = 3;

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public void hiddenApiUsed(int var1, String var2, String var3, int var4, boolean var5);
    }

    private static class SdkVersionContainer {
        private static final int sdkVersion = VMRuntime.getSdkVersionNative(0);
        private static final int sdkExtensionS = VMRuntime.getIntSystemProperty("build.version.extensions.s", 0);

        private SdkVersionContainer() {
        }
    }
}

