/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyAction;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewHierarchyActionAndroid
extends ViewHierarchyAction {
    private ViewHierarchyActionAndroid(int actionId, @Nullable CharSequence actionLabel) {
        super(actionId, actionLabel);
    }

    static Builder newBuilder(AccessibilityNodeInfo.AccessibilityAction action) {
        return new Builder(action);
    }

    static Builder newBuilder(AccessibilityHierarchyProtos.ViewHierarchyActionProto actionProto) {
        return new Builder(actionProto);
    }

    static class Builder {
        private final int actionId;
        private final @Nullable CharSequence actionLabel;

        Builder(AccessibilityNodeInfo.AccessibilityAction action) {
            this.actionId = action.getId();
            this.actionLabel = action.getLabel();
        }

        Builder(AccessibilityHierarchyProtos.ViewHierarchyActionProto actionProto) {
            this.actionId = actionProto.getActionId();
            this.actionLabel = actionProto.hasActionLabel() ? actionProto.getActionLabel() : null;
        }

        public ViewHierarchyActionAndroid build() {
            return new ViewHierarchyActionAndroid(this.actionId, this.actionLabel);
        }
    }
}

