/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SpannableStringBuilder
implements CharSequence {
    private static final String SEPARATOR = ", ";
    private final StringBuilder rawTextBuilder = new StringBuilder();
    private @MonotonicNonNull List<Span> spans;

    @CanIgnoreReturnValue
    public SpannableStringBuilder append(@Nullable CharSequence string2) {
        if (!TextUtils.isEmpty(string2)) {
            this.copyAndAppendAdjustedSpans(string2, 0);
            this.append(string2.toString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public SpannableStringBuilder append(@Nullable String string2) {
        if (!TextUtils.isEmpty(string2)) {
            this.rawTextBuilder.append(string2);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public SpannableStringBuilder appendWithSeparator(@Nullable CharSequence string2) {
        if (!TextUtils.isEmpty(string2)) {
            this.copyAndAppendAdjustedSpans(string2, this.needsSeparator() ? SEPARATOR.length() : 0);
            this.appendWithSeparator(string2.toString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public SpannableStringBuilder appendWithSeparator(@Nullable String string2) {
        if (!TextUtils.isEmpty(string2)) {
            if (this.needsSeparator()) {
                this.append(SEPARATOR);
            }
            this.append(string2);
        }
        return this;
    }

    public List<Span> getSpans() {
        return this.spans == null ? ImmutableList.of() : Collections.unmodifiableList(this.spans);
    }

    public SpannableString build() {
        return new SpannableString(this.rawTextBuilder.toString(), this.getSpans());
    }

    @Override
    public int length() {
        return this.rawTextBuilder.length();
    }

    @Override
    public char charAt(int index) {
        return this.rawTextBuilder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.rawTextBuilder.subSequence(start, end);
    }

    private boolean needsSeparator() {
        return this.rawTextBuilder.length() > 0;
    }

    private void copyAndAppendAdjustedSpans(CharSequence string2, int adjustment) {
        if (!(string2 instanceof SpannableString)) {
            return;
        }
        List<Span> spans = ((SpannableString)string2).getSpans();
        if (this.spans == null) {
            this.spans = new ArrayList<Span>();
        }
        for (Span span : spans) {
            Span adjustedSpan = span.copyWithAdjustedPosition(span.getStart() + this.rawTextBuilder.length() + adjustment, span.getEnd() + this.rawTextBuilder.length() + adjustment);
            this.spans.add(adjustedSpan);
        }
    }
}

