/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import android.util.Pair;
import com.android.systemui.monet.CustomDynamicColors;
import com.google.ux.material.libmonet.dynamiccolor.DynamicColor;
import com.google.ux.material.libmonet.dynamiccolor.MaterialDynamicColors;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class DynamicColors {
    public static List<Pair<String, DynamicColor>> getAllDynamicColorsMapped(boolean isExtendedFidelity) {
        MaterialDynamicColors mdc = new MaterialDynamicColors(isExtendedFidelity);
        Supplier[] supplierArray = new Supplier[50];
        supplierArray[0] = mdc::primaryPaletteKeyColor;
        supplierArray[1] = mdc::secondaryPaletteKeyColor;
        supplierArray[2] = mdc::tertiaryPaletteKeyColor;
        supplierArray[3] = mdc::neutralPaletteKeyColor;
        supplierArray[4] = mdc::neutralVariantPaletteKeyColor;
        supplierArray[5] = mdc::background;
        supplierArray[6] = mdc::onBackground;
        supplierArray[7] = mdc::surface;
        supplierArray[8] = mdc::surfaceDim;
        supplierArray[9] = mdc::surfaceBright;
        supplierArray[10] = mdc::surfaceContainerLowest;
        supplierArray[11] = mdc::surfaceContainerLow;
        supplierArray[12] = mdc::surfaceContainer;
        supplierArray[13] = mdc::surfaceContainerHigh;
        supplierArray[14] = mdc::surfaceContainerHighest;
        supplierArray[15] = mdc::onSurface;
        supplierArray[16] = mdc::surfaceVariant;
        supplierArray[17] = mdc::onSurfaceVariant;
        supplierArray[18] = mdc::inverseSurface;
        supplierArray[19] = mdc::inverseOnSurface;
        supplierArray[20] = mdc::outline;
        supplierArray[21] = mdc::outlineVariant;
        supplierArray[22] = mdc::shadow;
        supplierArray[23] = mdc::scrim;
        supplierArray[24] = mdc::surfaceTint;
        supplierArray[25] = mdc::primary;
        supplierArray[26] = mdc::onPrimary;
        supplierArray[27] = mdc::primaryContainer;
        supplierArray[28] = mdc::onPrimaryContainer;
        supplierArray[29] = mdc::inversePrimary;
        supplierArray[30] = mdc::secondary;
        supplierArray[31] = mdc::onSecondary;
        supplierArray[32] = mdc::secondaryContainer;
        supplierArray[33] = mdc::onSecondaryContainer;
        supplierArray[34] = mdc::tertiary;
        supplierArray[35] = mdc::onTertiary;
        supplierArray[36] = mdc::tertiaryContainer;
        supplierArray[37] = mdc::onTertiaryContainer;
        supplierArray[38] = mdc::error;
        supplierArray[39] = mdc::onError;
        supplierArray[40] = mdc::errorContainer;
        supplierArray[41] = mdc::onErrorContainer;
        supplierArray[42] = mdc::controlActivated;
        supplierArray[43] = mdc::controlNormal;
        supplierArray[44] = mdc::controlHighlight;
        supplierArray[45] = mdc::textPrimaryInverse;
        supplierArray[46] = mdc::textSecondaryAndTertiaryInverse;
        supplierArray[47] = mdc::textPrimaryInverseDisableOnly;
        supplierArray[48] = mdc::textSecondaryAndTertiaryInverseDisabled;
        supplierArray[49] = mdc::textHintInverse;
        Supplier[] allColors = supplierArray;
        List<Pair<String, DynamicColor>> list = DynamicColors.generateSysUINames(allColors);
        return list;
    }

    public static List<Pair<String, DynamicColor>> getFixedColorsMapped(boolean isExtendedFidelity) {
        MaterialDynamicColors mdc = new MaterialDynamicColors(isExtendedFidelity);
        Supplier[] supplierArray = new Supplier[12];
        supplierArray[0] = mdc::primaryFixed;
        supplierArray[1] = mdc::primaryFixedDim;
        supplierArray[2] = mdc::onPrimaryFixed;
        supplierArray[3] = mdc::onPrimaryFixedVariant;
        supplierArray[4] = mdc::secondaryFixed;
        supplierArray[5] = mdc::secondaryFixedDim;
        supplierArray[6] = mdc::onSecondaryFixed;
        supplierArray[7] = mdc::onSecondaryFixedVariant;
        supplierArray[8] = mdc::tertiaryFixed;
        supplierArray[9] = mdc::tertiaryFixedDim;
        supplierArray[10] = mdc::onTertiaryFixed;
        supplierArray[11] = mdc::onTertiaryFixedVariant;
        Supplier[] allColors = supplierArray;
        List<Pair<String, DynamicColor>> list = DynamicColors.generateSysUINames(allColors);
        return list;
    }

    public static List<Pair<String, DynamicColor>> getCustomColorsMapped(boolean isExtendedFidelity) {
        CustomDynamicColors customMdc = new CustomDynamicColors(isExtendedFidelity);
        List<Pair<String, DynamicColor>> list = DynamicColors.generateSysUINames(customMdc.allColors);
        return list;
    }

    private static List<Pair<String, DynamicColor>> generateSysUINames(Supplier<DynamicColor>[] allColors) {
        ArrayList<Pair<String, DynamicColor>> list = new ArrayList<Pair<String, DynamicColor>>();
        for (Supplier<DynamicColor> supplier : allColors) {
            DynamicColor dynamicColor = supplier.get();
            String name = dynamicColor.name;
            String paletteMark = "palette_key_color";
            if (name.contains("_" + paletteMark)) {
                name = paletteMark + "_" + name.replace("_" + paletteMark, "");
            }
            list.add(new Pair<String, DynamicColor>(name, dynamicColor));
        }
        list.sort(Comparator.comparing(pair -> (String)pair.first));
        return list;
    }
}

