/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import com.google.ux.material.libmonet.dynamiccolor.ContrastCurve;
import com.google.ux.material.libmonet.dynamiccolor.DynamicColor;
import com.google.ux.material.libmonet.dynamiccolor.MaterialDynamicColors;
import com.google.ux.material.libmonet.dynamiccolor.ToneDeltaPair;
import com.google.ux.material.libmonet.dynamiccolor.TonePolarity;
import java.util.function.Supplier;

public class CustomDynamicColors {
    private final MaterialDynamicColors mMdc;
    public final Supplier<DynamicColor>[] allColors;

    public CustomDynamicColors(boolean isExtendedFidelity) {
        this.mMdc = new MaterialDynamicColors(isExtendedFidelity);
        this.allColors = new Supplier[]{this::widgetBackground, this::clockHour, this::clockMinute, this::clockSecond, this::weatherTemp, this::themeApp, this::onThemeApp, this::themeAppRing, this::themeNotif, this::brandA, this::brandB, this::brandC, this::brandD, this::underSurface, this::shadeActive, this::onShadeActive, this::onShadeActiveVariant, this::shadeInactive, this::onShadeInactive, this::onShadeInactiveVariant, this::shadeDisabled, this::overviewBackground};
    }

    public DynamicColor widgetBackground() {
        return new DynamicColor("widget_background", s -> s.primaryPalette, s -> s.isDark ? 20.0 : 95.0, true, null, null, null, null);
    }

    public DynamicColor clockHour() {
        return new DynamicColor("clock_hour", s -> s.secondaryPalette, s -> s.isDark ? 60.0 : 30.0, false, s -> this.widgetBackground(), null, new ContrastCurve(4.0, 4.0, 5.0, 15.0), s -> new ToneDeltaPair(this.clockHour(), this.clockMinute(), 10.0, TonePolarity.DARKER, false));
    }

    public DynamicColor clockMinute() {
        return new DynamicColor("clock_minute", s -> s.primaryPalette, s -> s.isDark ? 90.0 : 40.0, false, s -> this.widgetBackground(), null, new ContrastCurve(6.5, 6.5, 10.0, 15.0), null);
    }

    public DynamicColor clockSecond() {
        return new DynamicColor("clock_second", s -> s.tertiaryPalette, s -> s.isDark ? 90.0 : 40.0, false, s -> this.widgetBackground(), null, new ContrastCurve(5.0, 5.0, 70.0, 11.0), null);
    }

    public DynamicColor weatherTemp() {
        return new DynamicColor("weather_temp", s -> s.primaryPalette, s -> s.isDark ? 80.0 : 55.0, false, s -> this.widgetBackground(), null, new ContrastCurve(5.0, 5.0, 70.0, 11.0), null);
    }

    public DynamicColor themeApp() {
        return new DynamicColor("theme_app", s -> s.primaryPalette, s -> s.isDark ? 30.0 : 90.0, true, null, null, null, null);
    }

    public DynamicColor onThemeApp() {
        return new DynamicColor("on_theme_app", s -> s.primaryPalette, s -> s.isDark ? 80.0 : 40.0, false, s -> this.themeApp(), null, new ContrastCurve(3.0, 3.0, 7.0, 10.0), null);
    }

    public DynamicColor themeAppRing() {
        return new DynamicColor("theme_app_ring", s -> s.primaryPalette, s -> 70.0, true, null, null, new ContrastCurve(1.0, 1.0, 1.0, 1.0), null);
    }

    public DynamicColor themeNotif() {
        return new DynamicColor("theme_notif", s -> s.tertiaryPalette, s -> s.isDark ? 90.0 : 80.0, false, s -> this.themeAppRing(), null, new ContrastCurve(1.0, 1.0, 1.0, 1.0), s -> new ToneDeltaPair(this.themeNotif(), this.themeAppRing(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor brandA() {
        return new DynamicColor("brand_a", s -> s.primaryPalette, s -> s.isDark ? 80.0 : 40.0, true, s -> this.mMdc.surfaceContainerLow(), null, new ContrastCurve(3.0, 3.0, 7.0, 17.0), s -> new ToneDeltaPair(this.brandA(), this.brandB(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor brandB() {
        return new DynamicColor("brand_b", s -> s.secondaryPalette, s -> s.isDark ? 98.0 : 70.0, true, s -> this.mMdc.surfaceContainerLow(), null, new ContrastCurve(3.0, 3.0, 3.0, 6.0), s -> new ToneDeltaPair(this.brandB(), this.brandC(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor brandC() {
        return new DynamicColor("brand_c", s -> s.primaryPalette, s -> s.isDark ? 60.0 : 50.0, false, s -> this.mMdc.surfaceContainerLow(), null, new ContrastCurve(3.0, 3.0, 4.0, 9.0), s -> new ToneDeltaPair(this.brandC(), this.brandD(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor brandD() {
        return new DynamicColor("brand_d", s -> s.tertiaryPalette, s -> s.isDark ? 90.0 : 59.0, false, s -> this.mMdc.surfaceContainerLow(), null, new ContrastCurve(3.0, 3.0, 4.0, 13.0), s -> new ToneDeltaPair(this.brandD(), this.brandA(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor underSurface() {
        return new DynamicColor("under_surface", s -> s.primaryPalette, s -> 0.0, true, null, null, null, null);
    }

    public DynamicColor shadeActive() {
        return new DynamicColor("shade_active", s -> s.primaryPalette, s -> 90.0, true, s -> this.underSurface(), null, new ContrastCurve(3.0, 3.0, 4.5, 7.0), s -> new ToneDeltaPair(this.shadeActive(), this.shadeInactive(), 30.0, TonePolarity.LIGHTER, false));
    }

    public DynamicColor onShadeActive() {
        return new DynamicColor("on_shade_active", s -> s.primaryPalette, s -> 10.0, false, s -> this.shadeActive(), null, new ContrastCurve(4.5, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.onShadeActive(), this.onShadeActiveVariant(), 20.0, TonePolarity.NEARER, false));
    }

    public DynamicColor onShadeActiveVariant() {
        return new DynamicColor("on_shade_active_variant", s -> s.primaryPalette, s -> 30.0, false, s -> this.shadeActive(), null, new ContrastCurve(4.5, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.onShadeActiveVariant(), this.onShadeActive(), 20.0, TonePolarity.NEARER, false));
    }

    public DynamicColor shadeInactive() {
        return new DynamicColor("shade_inactive", s -> s.neutralPalette, s -> 20.0, true, s -> this.underSurface(), null, new ContrastCurve(1.0, 1.0, 1.0, 1.0), s -> new ToneDeltaPair(this.shadeInactive(), this.shadeDisabled(), 15.0, TonePolarity.LIGHTER, false));
    }

    public DynamicColor onShadeInactive() {
        return new DynamicColor("on_shade_inactive", s -> s.neutralVariantPalette, s -> 90.0, false, s -> this.shadeInactive(), null, new ContrastCurve(4.5, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.onShadeInactive(), this.onShadeInactiveVariant(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor onShadeInactiveVariant() {
        return new DynamicColor("on_shade_inactive_variant", s -> s.neutralVariantPalette, s -> 80.0, false, s -> this.shadeInactive(), null, new ContrastCurve(4.5, 4.5, 7.0, 11.0), s -> new ToneDeltaPair(this.onShadeInactive(), this.onShadeInactiveVariant(), 10.0, TonePolarity.NEARER, false));
    }

    public DynamicColor shadeDisabled() {
        return new DynamicColor("shade_disabled", s -> s.neutralPalette, s -> 4.0, false, s -> this.underSurface(), null, new ContrastCurve(1.0, 1.0, 1.0, 1.0), null);
    }

    public DynamicColor overviewBackground() {
        return new DynamicColor("overview_background", s -> s.neutralVariantPalette, s -> s.isDark ? 35.0 : 80.0, true, null, null, null, null);
    }
}

