/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.ondevicepersonalization.internal.util.ByteArrayParceledListSlice;
import java.util.ArrayList;
import java.util.List;

public class ByteArrayParceledSlice
implements Parcelable {
    private static final int MAX_SLICE_SIZE = IBinder.getSuggestedMaxIpcSizeBytes() - 32;
    @NonNull
    private final ByteArrayParceledListSlice mContents;
    public static final Parcelable.Creator<ByteArrayParceledSlice> CREATOR = new Parcelable.Creator<ByteArrayParceledSlice>(){

        @Override
        public ByteArrayParceledSlice createFromParcel(Parcel in) {
            return new ByteArrayParceledSlice(in);
        }

        public ByteArrayParceledSlice[] newArray(int size) {
            return new ByteArrayParceledSlice[size];
        }
    };

    public ByteArrayParceledSlice(@Nullable byte[] input) {
        if (input != null) {
            int numSlices = (input.length + MAX_SLICE_SIZE - 1) / MAX_SLICE_SIZE;
            ArrayList<byte[]> slices = new ArrayList<byte[]>(numSlices);
            for (int i = 0; i < numSlices; ++i) {
                int startOffset = i * MAX_SLICE_SIZE;
                int count = Math.min(MAX_SLICE_SIZE, input.length - startOffset);
                byte[] slice = new byte[count];
                System.arraycopy(input, startOffset, slice, 0, count);
                slices.add(slice);
            }
            this.mContents = new ByteArrayParceledListSlice((List<byte[]>)slices);
        } else {
            this.mContents = null;
        }
    }

    @Nullable
    public byte[] getByteArray() {
        if (this.mContents == null) {
            return null;
        }
        List<byte[]> slices = this.mContents.getList();
        if (slices == null) {
            return null;
        }
        int totalCount = 0;
        for (int i = 0; i < slices.size(); ++i) {
            totalCount += slices.get(i).length;
        }
        byte[] result = new byte[totalCount];
        int offset = 0;
        for (int i = 0; i < slices.size(); ++i) {
            System.arraycopy(slices.get(i), 0, result, offset, slices.get(i).length);
            offset += slices.get(i).length;
        }
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mContents, flags);
    }

    private ByteArrayParceledSlice(Parcel in) {
        this.mContents = in.readParcelable(null, ByteArrayParceledListSlice.class);
    }
}

