/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.jsoup.parser;

import com.android.layoutlib.jsoup.nodes.Document;
import com.android.layoutlib.jsoup.nodes.Element;
import com.android.layoutlib.jsoup.nodes.Node;
import com.android.layoutlib.jsoup.parser.HtmlTreeBuilder;
import com.android.layoutlib.jsoup.parser.ParseError;
import com.android.layoutlib.jsoup.parser.ParseErrorList;
import com.android.layoutlib.jsoup.parser.TreeBuilder;
import com.android.layoutlib.jsoup.parser.XmlTreeBuilder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int DEFAULT_MAX_ERRORS = 0;
    private TreeBuilder treeBuilder;
    private int maxErrors = 0;
    private ParseErrorList errors;

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
    }

    public Document parseInput(String html, String baseUri) {
        this.errors = this.isTrackErrors() ? ParseErrorList.tracking(this.maxErrors) : ParseErrorList.noTracking();
        Document doc = this.treeBuilder.parse(html, baseUri, this.errors);
        return doc;
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public Parser setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        return this;
    }

    public boolean isTrackErrors() {
        return this.maxErrors > 0;
    }

    public Parser setTrackErrors(int maxErrors) {
        this.maxErrors = maxErrors;
        return this;
    }

    public List<ParseError> getErrors() {
        return this.errors;
    }

    public static Document parse(String html, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return ((TreeBuilder)treeBuilder).parse(html, baseUri, ParseErrorList.noTracking());
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(fragmentHtml, context, baseUri, ParseErrorList.noTracking());
    }

    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        Node[] nodes;
        Document doc = Document.createShell(baseUri);
        Element body = doc.body();
        List<Node> nodeList = Parser.parseFragment(bodyHtml, body, baseUri);
        for (Node node : nodes = nodeList.toArray(new Node[nodeList.size()])) {
            body.appendChild(node);
        }
        return doc;
    }

    public static Document parseBodyFragmentRelaxed(String bodyHtml, String baseUri) {
        return Parser.parse(bodyHtml, baseUri);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

