/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.AttachInfo_Accessor;
import android.view.InsetsFrameProvider;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.bars.AppCompatActionBar;
import com.android.layoutlib.bridge.bars.BridgeActionBar;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.FrameworkActionBar;
import com.android.layoutlib.bridge.bars.NavigationBar;
import com.android.layoutlib.bridge.bars.NavigationHandle;
import com.android.layoutlib.bridge.bars.StatusBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.DisplayCutoutView;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.util.InsetUtil;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Layout
extends FrameLayout {
    private static final String ATTR_WINDOW_FLOATING = "windowIsFloating";
    private static final String ATTR_WINDOW_BACKGROUND = "windowBackground";
    private static final String ATTR_WINDOW_FULL_SCREEN = "windowFullscreen";
    private static final String ATTR_NAV_BAR_HEIGHT = "navigation_bar_height";
    private static final String ATTR_NAV_BAR_WIDTH = "navigation_bar_width";
    private static final String ATTR_STATUS_BAR_HEIGHT = "status_bar_height";
    private static final String ATTR_WINDOW_ACTION_BAR = "windowActionBar";
    private static final String ATTR_ACTION_BAR_SIZE = "actionBarSize";
    private static final String ATTR_WINDOW_NO_TITLE = "windowNoTitle";
    private static final String ATTR_WINDOW_TITLE_SIZE = "windowTitleSize";
    private static final String ATTR_WINDOW_TRANSLUCENT_STATUS = "windowTranslucentStatus";
    private static final String ATTR_WINDOW_TRANSLUCENT_NAV = "windowTranslucentNavigation";
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_NAV_BAR_SIZE = 48;
    private static final String ID_NAV_BAR = "navBar";
    private static final String ID_STATUS_BAR = "statusBar";
    private static final String ID_APP_COMPAT_ACTION_BAR = "appCompatActionBar";
    private static final String ID_FRAMEWORK_BAR = "frameworkBar";
    private static final String ID_PREFIX = "android_layoutlib_";
    private final List<InsetsFrameProvider> mInsetsFrameProviders = new ArrayList<InsetsFrameProvider>();
    private Builder mBuilder;
    private final RelativeLayout mAppUiRoot;
    private FrameLayout mContentRoot;

    public Layout(@NonNull Builder builder) {
        super(builder.mContext);
        View view;
        BridgeActionBar bar;
        this.mBuilder = builder;
        View frameworkActionBar = null;
        View appCompatActionBar = null;
        TitleBar titleBar = null;
        StatusBar statusBar = null;
        View navBar = null;
        if (builder.mWindowBackground != null) {
            Drawable d = ResourceHelper.getDrawable(builder.mWindowBackground, builder.mContext, builder.mContext.getTheme());
            this.setBackground(d);
        }
        int simulatedPlatformVersion = this.getParams().getSimulatedPlatformVersion();
        HardwareConfig hwConfig = this.getParams().getHardwareConfig();
        Density density = hwConfig.getDensity();
        boolean isRtl = Bridge.isLocaleRtl(this.getParams().getLocale());
        this.setLayoutDirection(isRtl ? 1 : 0);
        if (this.mBuilder.hasNavBar()) {
            navBar = this.createNavBar(this.getContext(), this.mBuilder.useGestureNav(), density, isRtl, this.getParams().isRtlSupported(), this.mBuilder.mIsEdgeToEdge, simulatedPlatformVersion, false);
        }
        if (builder.hasStatusBar()) {
            statusBar = this.createStatusBar(this.getContext(), density, isRtl, this.getParams().isRtlSupported(), this.mBuilder.mIsEdgeToEdge, simulatedPlatformVersion);
        }
        if (this.mBuilder.hasAppCompatActionBar()) {
            bar = this.createActionBar(this.getContext(), this.getParams(), true, navBar, statusBar);
            this.mContentRoot = bar.getContentRoot();
            appCompatActionBar = bar.getRootView();
        }
        if (this.mBuilder.hasTitleBar()) {
            titleBar = this.createTitleBar(this.getContext(), this.getParams().getAppLabel(), simulatedPlatformVersion, navBar, statusBar);
        } else if (this.mBuilder.hasFrameworkActionBar()) {
            bar = this.createActionBar(this.getContext(), this.getParams(), false, navBar, statusBar);
            if (this.mContentRoot == null) {
                this.mContentRoot = bar.getContentRoot();
            }
            frameworkActionBar = bar.getRootView();
        }
        this.mAppUiRoot = new RelativeLayout(builder.mContext);
        View[] viewArray = new View[3];
        viewArray[0] = titleBar;
        if (this.mContentRoot == null) {
            this.mContentRoot = this.createContentFrame(navBar, statusBar);
            view = this.mContentRoot;
        } else {
            view = frameworkActionBar;
        }
        viewArray[1] = view;
        viewArray[2] = appCompatActionBar;
        this.addAppUiViews(viewArray);
        this.addView(this.mAppUiRoot);
        ViewGroup sysUiRoot = this.buildSysUi(statusBar, navBar, hwConfig.getOrientation() == ScreenOrientation.LANDSCAPE);
        if (sysUiRoot != null) {
            this.addView((View)sysUiRoot, -1, -1);
        }
        this.mBuilder = null;
    }

    @Nullable
    private ViewGroup buildSysUi(@Nullable StatusBar statusBar, @Nullable View navBar, boolean rotated) {
        if (statusBar == null && navBar == null && !this.mBuilder.mShowCutout) {
            return null;
        }
        FrameLayout sysUiRoot = new FrameLayout(this.mContext);
        if (navBar != null && statusBar != null) {
            if (!this.mBuilder.useGestureNav() && this.mBuilder.mNavBarOrientation == 1) {
                LinearLayout insideLayout = new LinearLayout(this.mContext);
                insideLayout.setOrientation(0);
                FrameLayout statusBarContainer = new FrameLayout(this.mContext);
                statusBarContainer.addView(statusBar);
                insideLayout.addView((View)statusBarContainer, new LinearLayout.LayoutParams(-2, -1, 1.0f));
                insideLayout.addView(navBar);
                sysUiRoot.addView((View)insideLayout, -1, -1);
            } else {
                sysUiRoot.addView(statusBar);
                sysUiRoot.addView(navBar);
            }
        } else if (navBar == null) {
            sysUiRoot.addView(statusBar);
        } else {
            sysUiRoot.addView(navBar);
        }
        if (this.mBuilder.mShowCutout) {
            sysUiRoot.addView((View)new DisplayCutoutView((Context)this.mBuilder.mContext, rotated ? 0 : 1), -1, -1);
        }
        return sysUiRoot;
    }

    @Override
    public boolean getChildVisibleRect(View child, Rect r, Point offset, boolean forceParentCheck) {
        return r.intersect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean getGlobalVisibleRect(Rect r, Point globalOffset) {
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width > 0 && height > 0) {
            r.set(0, 0, width, height);
            if (globalOffset != null) {
                globalOffset.set(-this.mScrollX, -this.mScrollY);
            }
            return true;
        }
        return false;
    }

    @NonNull
    private FrameLayout createContentFrame(@Nullable View navBar, @Nullable StatusBar statusBar) {
        FrameLayout contentRoot = new FrameLayout(this.getContext());
        RelativeLayout.LayoutParams params = this.createAppUiLayoutParams(-1, -1);
        if (navBar != null && this.mBuilder.hasSolidNavBar()) {
            if (this.mBuilder.isNavBarVertical()) {
                params.bottomMargin = navBar.getLayoutParams().height;
            } else {
                params.rightMargin = navBar.getLayoutParams().width;
            }
        }
        if (!this.mBuilder.mIsEdgeToEdge) {
            int below = -1;
            if (this.mBuilder.mAppCompatActionBarSize > 0) {
                below = this.getId(ID_APP_COMPAT_ACTION_BAR);
            } else if (this.mBuilder.hasFrameworkActionBar() || this.mBuilder.hasTitleBar()) {
                below = this.getId(ID_FRAMEWORK_BAR);
            } else if (statusBar != null && this.mBuilder.hasSolidStatusBar()) {
                params.topMargin = statusBar.getLayoutParams().height;
            }
            if (below != -1) {
                params.addRule(3, below);
            }
        }
        contentRoot.setLayoutParams(params);
        contentRoot.setId(0x1020002);
        return contentRoot;
    }

    @NonNull
    private RelativeLayout.LayoutParams createAppUiLayoutParams(int width, int height) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        if (width > 0) {
            width = (int)TypedValue.applyDimension(1, width, metrics);
        }
        if (height > 0) {
            height = (int)TypedValue.applyDimension(1, height, metrics);
        }
        return new RelativeLayout.LayoutParams(width, height);
    }

    @NonNull
    public FrameLayout getContentRoot() {
        return this.mContentRoot;
    }

    @NonNull
    private SessionParams getParams() {
        return this.mBuilder.mParams;
    }

    @Override
    @NonNull
    public BridgeContext getContext() {
        return (BridgeContext)super.getContext();
    }

    @NonNull
    public List<InsetsFrameProvider> getInsetsFrameProviders() {
        return this.mInsetsFrameProviders;
    }

    @NonNull
    private StatusBar createStatusBar(BridgeContext context, Density density, boolean isRtl, boolean isRtlSupported, boolean isEdgeToEdge, int simulatedPlatformVersion) {
        StatusBar statusBar = new StatusBar(context, density, isRtl, isRtlSupported, isEdgeToEdge, simulatedPlatformVersion);
        statusBar.setId(this.getId(ID_STATUS_BAR));
        WindowManager.LayoutParams layoutParams = statusBar.getBarLayoutParams();
        this.mInsetsFrameProviders.addAll(Arrays.asList(layoutParams.providedInsets));
        FrameLayout.LayoutParams lparams = new FrameLayout.LayoutParams(layoutParams);
        lparams.gravity = layoutParams.gravity;
        statusBar.setLayoutParams(lparams);
        return statusBar;
    }

    private BridgeActionBar createActionBar(@NonNull BridgeContext context, @NonNull SessionParams params, boolean appCompatActionBar, @Nullable View navBar, @Nullable StatusBar statusBar) {
        String id2;
        BridgeActionBar actionBar;
        boolean isMenu = "menu".equals(params.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG));
        int heightRule = appCompatActionBar || !this.mBuilder.hasAppCompatActionBar() ? -1 : -2;
        RelativeLayout.LayoutParams layoutParams = this.createAppUiLayoutParams(-1, heightRule);
        if (navBar != null && this.mBuilder.hasSolidNavBar()) {
            if (this.mBuilder.isNavBarVertical()) {
                layoutParams.rightMargin = navBar.getLayoutParams().width;
            } else if (appCompatActionBar || !this.mBuilder.hasAppCompatActionBar()) {
                layoutParams.bottomMargin = navBar.getLayoutParams().height;
            }
        }
        if (appCompatActionBar && !isMenu) {
            actionBar = new AppCompatActionBar(context, params);
            id2 = ID_APP_COMPAT_ACTION_BAR;
            if (this.mBuilder.hasTitleBar() || this.mBuilder.hasFrameworkActionBar()) {
                layoutParams.addRule(3, this.getId(ID_FRAMEWORK_BAR));
            } else if (statusBar != null && this.mBuilder.hasSolidStatusBar()) {
                layoutParams.topMargin = statusBar.getLayoutParams().height;
            }
        } else {
            actionBar = new FrameworkActionBar(context, params);
            id2 = ID_FRAMEWORK_BAR;
            if (statusBar != null && this.mBuilder.hasSolidStatusBar()) {
                layoutParams.topMargin = statusBar.getLayoutParams().height;
            }
        }
        actionBar.getRootView().setLayoutParams(layoutParams);
        actionBar.getRootView().setId(this.getId(id2));
        actionBar.createMenuPopup();
        return actionBar;
    }

    @NonNull
    private TitleBar createTitleBar(BridgeContext context, String title, int simulatedPlatformVersion, @Nullable View navBar, @Nullable StatusBar statusBar) {
        TitleBar titleBar = new TitleBar(context, title, simulatedPlatformVersion);
        RelativeLayout.LayoutParams params = this.createAppUiLayoutParams(-1, this.mBuilder.mTitleBarSize);
        if (statusBar != null && this.mBuilder.hasSolidStatusBar()) {
            params.topMargin = statusBar.getLayoutParams().height;
        }
        if (navBar != null && this.mBuilder.isNavBarVertical() && this.mBuilder.hasSolidNavBar()) {
            params.rightMargin = navBar.getLayoutParams().width;
        }
        titleBar.setLayoutParams(params);
        titleBar.setId(this.getId(ID_FRAMEWORK_BAR));
        return titleBar;
    }

    @NonNull
    private View createNavBar(BridgeContext context, boolean useGestureNav, Density density, boolean isRtl, boolean isRtlSupported, boolean isEdgeToEdge, int simulatedPlatformVersion, boolean isQuickStepEnabled) {
        View navBar;
        int rotation = 0;
        boolean bl = isQuickStepEnabled = isQuickStepEnabled && (simulatedPlatformVersion == 0 || simulatedPlatformVersion >= 28);
        if (useGestureNav) {
            navBar = new NavigationHandle(context);
        } else {
            navBar = new NavigationBar(context, density, this.mBuilder.mNavBarOrientation, isRtl, isRtlSupported, isEdgeToEdge, simulatedPlatformVersion, isQuickStepEnabled);
            if (this.mBuilder.mNavBarOrientation == 1) {
                rotation = 1;
            }
        }
        WindowManager.LayoutParams layoutParams = InsetUtil.getNavBarLayoutParamsForRotation(this.mBuilder.mContext, navBar, rotation);
        this.mInsetsFrameProviders.addAll(Arrays.asList(layoutParams.providedInsets));
        FrameLayout.LayoutParams lparams = new FrameLayout.LayoutParams(layoutParams);
        lparams.gravity = layoutParams.gravity;
        navBar.setLayoutParams(lparams);
        navBar.setId(this.getId(ID_NAV_BAR));
        return navBar;
    }

    private void addAppUiViews(View ... views) {
        for (View view : views) {
            if (view == null) continue;
            this.mAppUiRoot.addView(view);
        }
    }

    private int getId(String name) {
        return Bridge.getResourceId(ResourceType.ID, ID_PREFIX + name);
    }

    @Override
    public void requestFitSystemWindows() {
        ViewRootImpl root = AttachInfo_Accessor.getRootView(this);
        if (root != null) {
            ViewRootImpl_Accessor.dispatchApplyInsets(root, this);
        }
    }

    static class Builder {
        @NonNull
        private final SessionParams mParams;
        @NonNull
        private final BridgeContext mContext;
        private final RenderResources mResources;
        private final boolean mWindowIsFloating;
        private ResourceValue mWindowBackground;
        private int mStatusBarSize;
        private int mNavBarSize;
        private int mNavBarOrientation;
        private int mAppCompatActionBarSize;
        private int mFrameworkActionBarSize;
        private int mTitleBarSize;
        private boolean mTranslucentStatus;
        private boolean mTranslucentNav;
        private boolean mUseGestureNav;
        private boolean mIsEdgeToEdge;
        private boolean mShowCutout;

        public Builder(@NonNull SessionParams params, @NonNull BridgeContext context) {
            this.mParams = params;
            this.mContext = context;
            this.mResources = this.mParams.getResources();
            this.mWindowIsFloating = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_FLOATING, true);
            this.findBackground();
            if (!this.mParams.isForceNoDecor()) {
                this.mIsEdgeToEdge = Config.isGreaterOrEqual(this.mParams.getSimulatedPlatformVersion(), 35) || Boolean.TRUE.equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_EDGE_TO_EDGE));
                this.mShowCutout = Boolean.TRUE.equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_SHOW_CUTOUT));
                this.findStatusBar();
                this.findFrameworkBar();
                this.findAppCompatActionBar();
                this.findNavBar();
            }
        }

        private void findBackground() {
            if (!this.mParams.isTransparentBackground()) {
                this.mWindowBackground = this.mResources.findItemInTheme(BridgeContext.createFrameworkAttrReference(Layout.ATTR_WINDOW_BACKGROUND));
                this.mWindowBackground = this.mResources.resolveResValue(this.mWindowBackground);
            }
        }

        private void findStatusBar() {
            boolean windowFullScreen = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_FULL_SCREEN, false);
            if (!windowFullScreen && !this.mWindowIsFloating) {
                this.mStatusBarSize = this.getFrameworkAttrDimension(Layout.ATTR_STATUS_BAR_HEIGHT, 25);
                this.mTranslucentStatus = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_TRANSLUCENT_STATUS, false);
            }
        }

        private void findAppCompatActionBar() {
            if (this.mWindowIsFloating || !this.mContext.isAppCompatTheme()) {
                return;
            }
            boolean windowNoTitle = ResourceHelper.getBooleanThemeValue(this.mResources, this.mContext.createAppCompatAttrReference(Layout.ATTR_WINDOW_NO_TITLE), false);
            boolean windowActionBar = ResourceHelper.getBooleanThemeValue(this.mResources, this.mContext.createAppCompatAttrReference(Layout.ATTR_WINDOW_ACTION_BAR), true);
            if (!windowNoTitle && windowActionBar) {
                this.mAppCompatActionBarSize = this.getDimension(this.mContext.createAppCompatAttrReference(Layout.ATTR_ACTION_BAR_SIZE), 25);
            }
        }

        private void findFrameworkBar() {
            if (this.mWindowIsFloating) {
                return;
            }
            boolean frameworkWindowNoTitle = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_NO_TITLE, false);
            boolean isMenu = "menu".equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG));
            boolean windowActionBar = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_ACTION_BAR, true);
            if (!frameworkWindowNoTitle || isMenu) {
                if (isMenu || windowActionBar) {
                    this.mFrameworkActionBarSize = this.getFrameworkAttrDimension(Layout.ATTR_ACTION_BAR_SIZE, 25);
                } else {
                    this.mTitleBarSize = this.getDimension(this.mContext.createAppCompatAttrReference(Layout.ATTR_WINDOW_TITLE_SIZE), 25);
                }
            }
        }

        private void findNavBar() {
            if (this.hasSoftwareButtons() && !this.mWindowIsFloating) {
                this.mUseGestureNav = Boolean.TRUE.equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_USE_GESTURE_NAV));
                HardwareConfig hwConfig = this.mParams.getHardwareConfig();
                boolean barOnBottom = true;
                if (hwConfig.getOrientation() == ScreenOrientation.LANDSCAPE && !this.mUseGestureNav) {
                    int shortSize = hwConfig.getScreenHeight();
                    int shortSizeDp = shortSize * 160 / hwConfig.getDensity().getDpiValue();
                    barOnBottom = shortSizeDp >= 600;
                }
                this.mNavBarOrientation = barOnBottom ? 0 : 1;
                this.mNavBarSize = this.getFrameworkAttrDimension(barOnBottom ? Layout.ATTR_NAV_BAR_HEIGHT : Layout.ATTR_NAV_BAR_WIDTH, 48);
                this.mTranslucentNav = ResourceHelper.getBooleanThemeFrameworkAttrValue(this.mResources, Layout.ATTR_WINDOW_TRANSLUCENT_NAV, false);
            }
        }

        private int getDimension(@NonNull ResourceReference attrRef, int defaultValue) {
            TypedValue typedValue;
            ResourceValue value = this.mResources.findItemInTheme(attrRef);
            if ((value = this.mResources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue(attrRef.getName(), value.getValue(), true)) != null) {
                return (int)typedValue.getDimension(this.mContext.getMetrics());
            }
            return defaultValue;
        }

        private int getFrameworkAttrDimension(@NonNull String attr2, int defaultValue) {
            return this.getDimension(BridgeContext.createFrameworkAttrReference(attr2), defaultValue);
        }

        private boolean hasSoftwareButtons() {
            return this.mParams.getHardwareConfig().hasSoftwareButtons();
        }

        private boolean hasSolidNavBar() {
            return this.hasNavBar() && !this.mTranslucentNav && !this.mIsEdgeToEdge;
        }

        private boolean hasSolidStatusBar() {
            return this.hasStatusBar() && !this.mTranslucentStatus && !this.mIsEdgeToEdge;
        }

        private boolean hasNavBar() {
            return Config.showOnScreenNavBar(this.mParams.getSimulatedPlatformVersion()) && this.hasSoftwareButtons() && this.mNavBarSize > 0;
        }

        private boolean useGestureNav() {
            return this.mUseGestureNav;
        }

        private boolean hasTitleBar() {
            return this.mTitleBarSize > 0;
        }

        private boolean hasStatusBar() {
            return this.mStatusBarSize > 0;
        }

        private boolean hasAppCompatActionBar() {
            return this.mAppCompatActionBarSize > 0;
        }

        private boolean isNavBarVertical() {
            return this.hasNavBar() && this.mNavBarOrientation == 1;
        }

        private boolean hasFrameworkActionBar() {
            return this.mFrameworkActionBarSize > 0;
        }

        private boolean hasNotch() {
            return !this.mParams.isForceNoDecor();
        }
    }
}

