/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities.easing;

import android.annotation.NonNull;
import android.annotation.Nullable;

public class MonotonicSpline {
    private static final String TAG = "MonotonicCurveFit";
    private float[] mT;
    private float[] mY;
    private float[] mTangent;
    private boolean mExtrapolate = true;
    float[] mSlopeTemp;

    public MonotonicSpline(@Nullable float[] time, @NonNull float[] y) {
        int i;
        if (time == null) {
            time = new float[y.length];
            for (int i2 = 0; i2 < time.length; ++i2) {
                time[i2] = (float)i2 / (float)(time.length - 1);
            }
        }
        this.mT = time;
        this.mY = y;
        int n = time.length;
        boolean dim = true;
        this.mSlopeTemp = new float[1];
        float[] slope = new float[n - 1];
        float[] tangent = new float[n];
        for (i = 0; i < n - 1; ++i) {
            float dt = time[i + 1] - time[i];
            slope[i] = (y[i + 1] - y[i]) / dt;
            tangent[i] = i == 0 ? slope[i] : (slope[i - 1] + slope[i]) * 0.5f;
        }
        tangent[n - 1] = slope[n - 2];
        for (i = 0; i < n - 1; ++i) {
            if ((double)slope[i] == 0.0) {
                tangent[i] = 0.0f;
                tangent[i + 1] = 0.0f;
                continue;
            }
            float a = tangent[i] / slope[i];
            float b = tangent[i + 1] / slope[i];
            float h = (float)Math.hypot(a, b);
            if (!((double)h > 9.0)) continue;
            float t = 3.0f / h;
            tangent[i] = t * a * slope[i];
            tangent[i + 1] = t * b * slope[i];
        }
        this.mTangent = tangent;
    }

    public float[] getArray() {
        return this.mY;
    }

    public float getPos(float t) {
        int n = this.mT.length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                float slopeTemp = this.getSlope(this.mT[0]);
                float v = this.mY[0] + (t - this.mT[0]) * slopeTemp;
                return v;
            }
            if (t >= this.mT[n - 1]) {
                float slopeTemp = this.getSlope(this.mT[n - 1]);
                float v = this.mY[n - 1] + (t - this.mT[n - 1]) * slopeTemp;
                return v;
            }
        } else {
            if (t <= this.mT[0]) {
                float v = this.mY[0];
                return v;
            }
            if (t >= this.mT[n - 1]) {
                float v = this.mY[n - 1];
                return v;
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            float v;
            if (t == this.mT[i]) {
                v = this.mY[i];
            }
            if (!(t < this.mT[i + 1])) continue;
            float h = this.mT[i + 1] - this.mT[i];
            float x = (t - this.mT[i]) / h;
            float y1 = this.mY[i];
            float y2 = this.mY[i + 1];
            float t1 = this.mTangent[i];
            float t2 = this.mTangent[i + 1];
            v = MonotonicSpline.interpolate(h, x, y1, y2, t1, t2);
            return v;
        }
        return 0.0f;
    }

    public float getSlope(float t) {
        int n = this.mT.length;
        float v = 0.0f;
        if (t <= this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        int i = 0;
        if (i < n - 1 && t <= this.mT[i + 1]) {
            float h = this.mT[i + 1] - this.mT[i];
            float x = (t - this.mT[i]) / h;
            float y1 = this.mY[i];
            float y2 = this.mY[i + 1];
            float t1 = this.mTangent[i];
            float t2 = this.mTangent[i + 1];
            v = MonotonicSpline.diff(h, x, y1, y2, t1, t2) / h;
        }
        return v;
    }

    public float[] getTimePoints() {
        return this.mT;
    }

    private static float interpolate(float h, float x, float y1, float y2, float t1, float t2) {
        float x2 = x * x;
        float x3 = x2 * x;
        return -2.0f * x3 * y2 + 3.0f * x2 * y2 + 2.0f * x3 * y1 - 3.0f * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - 2.0f * h * t1 * x2 + h * t1 * x;
    }

    private static float diff(float h, float x, float y1, float y2, float t1, float t2) {
        float x2 = x * x;
        return -6.0f * x2 * y2 + 6.0f * x * y2 + 6.0f * x2 * y1 - 6.0f * x * y1 + 3.0f * h * t2 * x2 + 3.0f * h * t1 * x2 - 2.0f * h * t2 * x - 4.0f * h * t1 * x + h * t1;
    }
}

