/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase4;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class RoundedClipRectModifierOperation
extends DrawBase4
implements ModifierOperation,
DecoratorComponent {
    public static final int OP_CODE = 54;
    public static final String CLASS_NAME = "RoundedClipRectModifierOperation";
    float mWidth;
    float mHeight;

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase4.Maker m = RoundedClipRectModifierOperation::new;
        RoundedClipRectModifierOperation.read(m, buffer, operations);
    }

    public static int id() {
        return 54;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4) {
        RoundedClipRectModifierOperation.apply(buffer, v1, v2, v3, v4);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Modifier Operations", RoundedClipRectModifierOperation.id(), CLASS_NAME).description("clip with rectangle").field(1, "topStart", "The topStart radius of the rectangle to intersect with the current clip").field(1, "topEnd", "The topEnd radius of the rectangle to intersect with the current clip").field(1, "bottomStart", "The bottomStart radius of the rectangle to intersect with the current clip").field(1, "bottomEnd", "The bottomEnd radius of the rectangle to intersect with the current clip");
    }

    public RoundedClipRectModifierOperation(float topStart, float topEnd, float bottomStart, float bottomEnd) {
        super(topStart, topEnd, bottomStart, bottomEnd);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.roundedClipRect(this.mWidth, this.mHeight, this.mX1, this.mY1, this.mX2, this.mY2);
    }

    @Override
    public void layout(@NonNull RemoteContext context, Component component, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "ROUNDED_CLIP_RECT = [" + this.mWidth + ", " + this.mHeight + ", " + this.mX1 + ", " + this.mY1 + ", " + this.mX2 + ", " + this.mY2 + "]");
    }

    public static void apply(@NonNull WireBuffer buffer, float topStart, float topEnd, float bottomStart, float bottomEnd) {
        RoundedClipRectModifierOperation.write(buffer, 54, topStart, topEnd, bottomStart, bottomEnd);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "topStart", "topEnd", "bottomStart", "bottomEnd").addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("width", Float.valueOf(this.mWidth)).add("height", Float.valueOf(this.mHeight));
    }
}

