/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.ScrollDelegate;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DecoratorModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class MarqueeModifierOperation
extends DecoratorModifierOperation
implements ScrollDelegate {
    private static final int OP_CODE = 228;
    public static final String CLASS_NAME = "MarqueeModifierOperation";
    int mIterations;
    int mAnimationMode;
    float mRepeatDelayMillis;
    float mInitialDelayMillis;
    float mSpacing;
    float mVelocity;
    private float mComponentWidth;
    private float mComponentHeight;
    private float mContentWidth;
    private float mContentHeight;
    private long mLastTime = 0L;
    private long mStartTime = 0L;
    private float mScrollX = 0.0f;

    public MarqueeModifierOperation(int iterations, int animationMode, float repeatDelayMillis, float initialDelayMillis, float spacing, float velocity) {
        this.mIterations = iterations;
        this.mAnimationMode = animationMode;
        this.mRepeatDelayMillis = repeatDelayMillis;
        this.mInitialDelayMillis = initialDelayMillis;
        this.mSpacing = spacing;
        this.mVelocity = velocity;
    }

    public void setContentWidth(float value) {
        this.mContentWidth = value;
    }

    public void setContentHeight(float value) {
        this.mContentHeight = value;
    }

    @Override
    public float getScrollX(float currentValue) {
        return this.mScrollX;
    }

    @Override
    public float getScrollY(float currentValue) {
        return 0.0f;
    }

    @Override
    public boolean handlesHorizontalScroll() {
        return true;
    }

    @Override
    public boolean handlesVerticalScroll() {
        return false;
    }

    @Override
    public void reset() {
        this.mLastTime = 0L;
        this.mScrollX = 0.0f;
    }

    @Override
    public void write(WireBuffer buffer) {
        MarqueeModifierOperation.apply(buffer, this.mIterations, this.mAnimationMode, this.mRepeatDelayMillis, this.mInitialDelayMillis, this.mSpacing, this.mVelocity);
    }

    @Override
    public void serializeToString(int indent, StringSerializer serializer) {
        serializer.append(indent, "MARQUEE = [" + this.mIterations + "]");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
        long currentTime = System_Delegate.currentTimeMillis();
        if (this.mLastTime == 0L) {
            this.mLastTime = currentTime;
            this.mStartTime = this.mLastTime + (long)this.mInitialDelayMillis;
            context.needsRepaint();
        }
        if (this.mContentWidth > this.mComponentWidth && (float)(currentTime - this.mStartTime) > this.mInitialDelayMillis) {
            float offset;
            float density = context.getContext().getDensity();
            float delta = this.mContentWidth - this.mComponentWidth;
            float duration = delta / (density * this.mVelocity);
            float elapsed = (float)(System_Delegate.currentTimeMillis() - this.mStartTime) / 1000.0f;
            elapsed = elapsed % duration / duration;
            this.mScrollX = offset = (1.0f + (float)Math.sin((double)(elapsed * 2.0f) * Math.PI - 1.5707963267948966)) / 2.0f * -delta;
            context.needsRepaint();
        }
    }

    public String toString() {
        return "MarqueeModifierOperation(" + this.mIterations + ")";
    }

    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 228;
    }

    public static void apply(WireBuffer buffer, int iterations, int animationMode, float repeatDelayMillis, float initialDelayMillis, float spacing, float velocity) {
        buffer.start(228);
        buffer.writeInt(iterations);
        buffer.writeInt(animationMode);
        buffer.writeFloat(repeatDelayMillis);
        buffer.writeFloat(initialDelayMillis);
        buffer.writeFloat(spacing);
        buffer.writeFloat(velocity);
    }

    public static void read(WireBuffer buffer, List<Operation> operations) {
        int iterations = buffer.readInt();
        int animationMode = buffer.readInt();
        float repeatDelayMillis = buffer.readFloat();
        float initialDelayMillis = buffer.readFloat();
        float spacing = buffer.readFloat();
        float velocity = buffer.readFloat();
        operations.add(new MarqueeModifierOperation(iterations, animationMode, repeatDelayMillis, initialDelayMillis, spacing, velocity));
    }

    public static void documentation(DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 228, CLASS_NAME).description("specify a Marquee Modifier").field(1, "value", "");
    }

    @Override
    public void layout(RemoteContext context, Component component, float width, float height) {
        this.mComponentWidth = width;
        this.mComponentHeight = height;
        if (component instanceof LayoutComponent) {
            LayoutComponent layoutComponent = (LayoutComponent)component;
            this.setContentWidth(layoutComponent.minIntrinsicWidth(context));
            this.setContentHeight(layoutComponent.minIntrinsicHeight(context));
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("iterations", this.mIterations).add("animationMode", this.mAnimationMode).add("repeatDelayMillis", Float.valueOf(this.mRepeatDelayMillis)).add("initialDelayMillis", Float.valueOf(this.mInitialDelayMillis)).add("spacing", Float.valueOf(this.mSpacing)).add("velocity", Float.valueOf(this.mVelocity));
    }
}

