/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DimensionInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class HeightInModifierOperation
extends DimensionInModifierOperation {
    private static final int OP_CODE = 232;
    public static final String CLASS_NAME = "HeightInModifierOperation";

    public HeightInModifierOperation(float min, float max) {
        super(232, min, max);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        HeightInModifierOperation.apply(buffer, this.getMin(), this.getMax());
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        float v1 = buffer.readFloat();
        float v2 = buffer.readFloat();
        operations.add(new HeightInModifierOperation(v1, v2));
    }

    public static int id() {
        return 232;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", 232, CLASS_NAME).description("Add additional constraints to the height").field(1, "min", "The minimum height, -1 if not applied").field(1, "max", "The maximum height, -1 if not applied");
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1) {
        buffer.start(232);
        buffer.writeFloat(x1);
        buffer.writeFloat(y1);
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "HEIGHT_IN = [" + this.getMin() + ", " + this.getMax() + "]");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("min", this.mV1, this.mValue1).add("max", this.mV2, this.mValue2);
    }
}

