/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class TextLookupInt
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 153;
    private static final String CLASS_NAME = "TextFromINT";
    public int mTextId;
    public int mDataSetId;
    public int mOutIndex;
    public int mIndex;
    public static final int MAX_STRING_SIZE = 4000;

    public TextLookupInt(int textId, int dataSetId, int indexId) {
        this.mTextId = textId;
        this.mDataSetId = dataSetId;
        this.mOutIndex = this.mIndex = indexId;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextLookupInt.apply(buffer, this.mTextId, this.mDataSetId, this.mIndex);
    }

    @NonNull
    public String toString() {
        return "TextLookupInt[" + Utils.idString(this.mTextId) + "] = " + Utils.idString(this.mDataSetId) + " " + this.mIndex;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutIndex = context.getInteger(this.mIndex);
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        context.listensTo(this.mIndex, this);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 153;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, int dataSet, int indexId) {
        buffer.start(153);
        buffer.writeInt(textId);
        buffer.writeInt(dataSet);
        buffer.writeInt(indexId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textId = buffer.readInt();
        int dataSetId = buffer.readInt();
        int indexId = buffer.readInt();
        operations.add(new TextLookupInt(textId, dataSetId, indexId));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 153, CLASS_NAME).description("Look up an array and turn into a text object").field(0, "textId", "id of the text generated").field(0, "dataSetId", "id to the array/list to turn int a string").field(0, "index", "index of the element to return");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        int id2 = context.getCollectionsAccess().getId(this.mDataSetId, this.mOutIndex);
        context.loadText(this.mTextId, context.getText(id2));
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextId).add("dataSetId", this.mDataSetId).add("indexId", this.mIndex, this.mOutIndex);
    }
}

