/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class FloatConstant
extends Operation
implements Serializable {
    private static final int OP_CODE = 80;
    private static final String CLASS_NAME = "FloatConstant";
    public int mId;
    public float mValue;

    public FloatConstant(int id2, float value) {
        this.mId = id2;
        this.mValue = value;
    }

    public void update(FloatConstant from) {
        this.mValue = from.mValue;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        FloatConstant.apply(buffer, this.mId, this.mValue);
    }

    @NonNull
    public String toString() {
        return "FloatConstant[" + this.mId + "] = " + this.mValue;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 80;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, float value) {
        buffer.start(80);
        buffer.writeInt(id2);
        buffer.writeFloat(value);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        float value = buffer.readFloat();
        operations.add(new FloatConstant(id2, value));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 80, CLASS_NAME).description("A float and its associated id").field(0, "id", "id of float").field(1, "value", "32-bit float value");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.loadFloat(this.mId, this.mValue);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("value", Float.valueOf(this.mValue));
    }
}

