/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase4;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawOval
extends DrawBase4 {
    private static final int OP_CODE = 56;
    private static final String CLASS_NAME = "DrawOval";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase4.Maker m = DrawOval::new;
        DrawOval.read(m, buffer, operations);
    }

    public static int id() {
        return 56;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 56, CLASS_NAME).description("Draw the specified oval").field(1, "left", "The left side of the oval").field(1, "top", "The top of the oval").field(1, "right", "The right side of the oval").field(1, "bottom", "The bottom of the oval");
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4) {
        DrawOval.apply(buffer, v1, v2, v3, v4);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawOval.apply(buffer, this.mX1, this.mY1, this.mX2, this.mY2);
    }

    public DrawOval(float left, float top, float right, float bottom) {
        super(left, top, right, bottom);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawOval(this.mX1, this.mY1, this.mX2, this.mY2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2, float y2) {
        DrawOval.write(buffer, 56, x1, y1, x2, y2);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "left", "top", "right", "bottom").addType(CLASS_NAME);
    }
}

