/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.ArrayAccess;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.List;

public class DataListFloat
extends Operation
implements VariableSupport,
ArrayAccess,
Serializable {
    private static final int OP_CODE = 147;
    private static final String CLASS_NAME = "IdListData";
    public final int mId;
    @NonNull
    private float[] mValues;
    private static final int MAX_FLOAT_ARRAY = 2000;

    public DataListFloat(int id2, @NonNull float[] values) {
        this.mId = id2;
        this.mValues = values;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        context.addCollection(this.mId, this);
        for (float value : this.mValues) {
            if (!Utils.isVariable(value)) continue;
            context.listensTo(Utils.idFromNan(value), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DataListFloat.apply(buffer, this.mId, this.mValues);
    }

    @NonNull
    public String toString() {
        return "DataListFloat[" + Utils.idString(this.mId) + "] " + Arrays.toString(this.mValues);
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull float[] values) {
        buffer.start(147);
        buffer.writeInt(id2);
        buffer.writeInt(values.length);
        for (int i = 0; i < values.length; ++i) {
            buffer.writeFloat(values[i]);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int len = buffer.readInt();
        if (len > 2000) {
            throw new RuntimeException(len + " map entries more than max = " + 2000);
        }
        float[] values = new float[len];
        for (int i = 0; i < values.length; ++i) {
            values[i] = buffer.readFloat();
        }
        DataListFloat data = new DataListFloat(id2, values);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 147, CLASS_NAME).description("a list of Floats").field(0, "id", "id the array (2xxxxx)").field(0, "length", "number of floats").field(10, "values", "length", "array of floats");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.addCollection(this.mId, this);
    }

    @Override
    public float getFloatValue(int index) {
        return this.mValues[index];
    }

    @Override
    @NonNull
    public float[] getFloats() {
        return this.mValues;
    }

    @Override
    public int getLength() {
        return this.mValues.length;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("values", List.of(this.mValues));
    }

    public void update(DataListFloat lc) {
        this.mValues = lc.mValues;
    }
}

