/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.accessibility;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.PointF;
import android.os.Bundle;
import android.util.IntArray;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.widget.ExploreByTouchHelper;
import com.android.internal.widget.remotecompose.accessibility.AndroidPlatformSemanticNodeApplier;
import com.android.internal.widget.remotecompose.accessibility.CoreDocumentAccessibility;
import com.android.internal.widget.remotecompose.accessibility.RemoteComposeDocumentAccessibility;
import com.android.internal.widget.remotecompose.accessibility.SemanticNodeApplier;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.RemoteContextAware;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.semantics.AccessibilitySemantics;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import java.util.List;

public class PlatformRemoteComposeTouchHelper
extends ExploreByTouchHelper {
    private final RemoteComposeDocumentAccessibility mRemoteDocA11y;
    private final SemanticNodeApplier<AccessibilityNodeInfo> mApplier;
    private final View mHost;

    public PlatformRemoteComposeTouchHelper(View host, RemoteComposeDocumentAccessibility remoteDocA11y, SemanticNodeApplier<AccessibilityNodeInfo> applier) {
        super(host);
        this.mRemoteDocA11y = remoteDocA11y;
        this.mApplier = applier;
        this.mHost = host;
    }

    public static PlatformRemoteComposeTouchHelper forRemoteComposePlayer(View player, @NonNull CoreDocument coreDocument) {
        return new PlatformRemoteComposeTouchHelper(player, new CoreDocumentAccessibility(coreDocument, ((RemoteContextAware)((Object)player)).getRemoteContext()), new AndroidPlatformSemanticNodeApplier(player));
    }

    @Override
    protected int getVirtualViewAt(float x, float y) {
        Integer root = this.mRemoteDocA11y.getComponentIdAt(new PointF(x, y));
        if (root == null) {
            return Integer.MIN_VALUE;
        }
        return root;
    }

    @Override
    protected void getVisibleVirtualViews(IntArray virtualViewIds) {
        Component rootComponent = this.mRemoteDocA11y.findComponentById(RemoteComposeDocumentAccessibility.RootId);
        if (rootComponent == null || !this.mRemoteDocA11y.semanticModifiersForComponent(rootComponent).isEmpty()) {
            virtualViewIds.add(RemoteComposeDocumentAccessibility.RootId);
        }
        List<Integer> children = this.mRemoteDocA11y.semanticallyRelevantChildComponents(rootComponent, false);
        for (int child : children) {
            virtualViewIds.add(child);
        }
    }

    @Override
    public void onPopulateNodeForVirtualView(int virtualViewId, @NonNull AccessibilityNodeInfo node) {
        Component component = this.mRemoteDocA11y.findComponentById(virtualViewId);
        AccessibleComponent.Mode mergeMode = this.mRemoteDocA11y.mergeMode(component);
        node.setEnabled(true);
        if (mergeMode == AccessibleComponent.Mode.MERGE) {
            List<Integer> childViews = this.mRemoteDocA11y.semanticallyRelevantChildComponents(component, true);
            for (Integer childView : childViews) {
                this.onPopulateNodeForVirtualView(childView, node);
            }
        }
        List<AccessibilitySemantics> semantics = this.mRemoteDocA11y.semanticModifiersForComponent(component);
        this.mApplier.applyComponent(this.mRemoteDocA11y, node, component, semantics);
        if (mergeMode == AccessibleComponent.Mode.SET) {
            List<Integer> childViews = this.mRemoteDocA11y.semanticallyRelevantChildComponents(component, false);
            this.mApplier.addChildren(node, childViews);
        }
    }

    @Override
    protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
    }

    @Override
    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, @Nullable Bundle arguments) {
        Component component = this.mRemoteDocA11y.findComponentById(virtualViewId);
        if (component != null) {
            boolean performed = this.mRemoteDocA11y.performAction(component, action, arguments);
            if (performed) {
                this.mHost.invalidate();
                this.invalidateRoot();
            }
            return performed;
        }
        return false;
    }
}

