/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Notification;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.RemotableViewMethod;
import android.widget.ProgressBar;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.NotificationProgressDrawable;
import com.android.internal.widget.NotificationProgressModel;
import com.android.layoutlib.androidx.annotation.ColorInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

@RemoteViews.RemoteView
public class NotificationProgressBar
extends ProgressBar
implements NotificationProgressDrawable.BoundsChangeListener {
    private static final String TAG = "NotificationProgressBar";
    private static final boolean DEBUG = false;
    private static final float FADED_OPACITY = 0.5f;
    private Animatable2.AnimationCallback mIndeterminateAnimationCallback = null;
    private NotificationProgressDrawable mNotificationProgressDrawable;
    private final Rect mProgressDrawableBounds = new Rect();
    private NotificationProgressModel mProgressModel;
    @Nullable
    private List<Part> mParts = null;
    @Nullable
    private List<NotificationProgressDrawable.DrawablePart> mProgressDrawableParts = null;
    private final float mSegMinWidth;
    private final float mSegSegGap;
    private final float mSegPointGap;
    @Nullable
    private Drawable mTracker = null;
    private boolean mHasTrackerIcon = false;
    private final int mTrackerHeight;
    private int mTrackerDrawWidth = 0;
    private int mTrackerPos;
    private final Matrix mMatrix = new Matrix();
    private Matrix mTrackerDrawMatrix = null;
    private float mProgressFraction = 0.0f;
    private float mAdjustedProgressFraction = 0.0f;
    private boolean mTrackerPosIsDirty = false;

    public NotificationProgressBar(Context context) {
        this(context, null);
    }

    public NotificationProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010077);
    }

    public NotificationProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NotificationProgressBar, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.NotificationProgressBar, attrs, a, defStyleAttr, defStyleRes);
        try {
            this.mNotificationProgressDrawable = this.getNotificationProgressDrawable();
            this.mNotificationProgressDrawable.setBoundsChangeListener(this);
        }
        catch (IllegalStateException ex) {
            Log.e(TAG, "Can't get NotificationProgressDrawable", ex);
        }
        this.mSegMinWidth = a.getDimension(0, 0.0f);
        this.mSegSegGap = a.getDimension(2, 0.0f);
        this.mSegPointGap = a.getDimension(1, 0.0f);
        Drawable tracker = a.getDrawable(3);
        this.setTracker(tracker);
        this.mTrackerHeight = a.getDimensionPixelSize(4, 0);
    }

    @Override
    public void setIndeterminateDrawable(Drawable d) {
        Drawable oldDrawable = this.getIndeterminateDrawable();
        if (oldDrawable != d) {
            if (this.mIndeterminateAnimationCallback != null) {
                ((AnimatedVectorDrawable)oldDrawable).unregisterAnimationCallback(this.mIndeterminateAnimationCallback);
                this.mIndeterminateAnimationCallback = null;
            }
            if (d instanceof AnimatedVectorDrawable) {
                this.mIndeterminateAnimationCallback = new Animatable2.AnimationCallback(){

                    @Override
                    public void onAnimationEnd(Drawable drawable2) {
                        super.onAnimationEnd(drawable2);
                        if (NotificationProgressBar.this.shouldLoopIndeterminateAnimation()) {
                            ((AnimatedVectorDrawable)drawable2).start();
                        }
                    }
                };
                ((AnimatedVectorDrawable)d).registerAnimationCallback(this.mIndeterminateAnimationCallback);
            }
        }
        super.setIndeterminateDrawable(d);
    }

    private boolean shouldLoopIndeterminateAnimation() {
        return this.isIndeterminate() && this.isAttachedToWindow() && this.isAggregatedVisible();
    }

    @RemotableViewMethod
    public void setProgressModel(@Nullable Bundle bundle) {
        Preconditions.checkArgument(bundle != null, "Bundle shouldn't be null");
        this.mProgressModel = NotificationProgressModel.fromBundle(bundle);
        boolean isIndeterminate = this.mProgressModel.isIndeterminate();
        this.setIndeterminate(isIndeterminate);
        if (isIndeterminate) {
            int indeterminateColor = this.mProgressModel.getIndeterminateColor();
            this.setIndeterminateTintList(ColorStateList.valueOf(indeterminateColor));
        } else {
            int progress = this.mProgressModel.getProgress();
            int progressMax = this.mProgressModel.getProgressMax();
            this.mParts = NotificationProgressBar.processModelAndConvertToViewParts(this.mProgressModel.getSegments(), this.mProgressModel.getPoints(), progress, progressMax);
            this.setMax(progressMax);
            this.setProgress(progress);
            if (this.mNotificationProgressDrawable != null && this.mNotificationProgressDrawable.getBounds().width() != 0) {
                this.updateDrawableParts();
            }
        }
    }

    @NonNull
    private NotificationProgressDrawable getNotificationProgressDrawable() {
        Drawable d = this.getProgressDrawable();
        if (d == null) {
            throw new IllegalStateException("getProgressDrawable() returns null");
        }
        if (!(d instanceof LayerDrawable)) {
            throw new IllegalStateException("getProgressDrawable() doesn't return a LayerDrawable");
        }
        Drawable layer = ((LayerDrawable)d).findDrawableByLayerId(0x1020000);
        if (!(layer instanceof NotificationProgressDrawable)) {
            throw new IllegalStateException("Couldn't get NotificationProgressDrawable, retrieved drawable is: " + (layer != null ? layer.toString() : null));
        }
        return (NotificationProgressDrawable)layer;
    }

    @RemotableViewMethod(asyncImpl="setProgressTrackerIconAsync")
    public void setProgressTrackerIcon(@Nullable Icon icon) {
        Drawable progressTrackerDrawable = icon != null ? icon.loadDrawable(this.getContext()) : null;
        this.setTracker(progressTrackerDrawable);
    }

    public Runnable setProgressTrackerIconAsync(@Nullable Icon icon) {
        Drawable progressTrackerDrawable = icon != null ? icon.loadDrawable(this.getContext()) : null;
        return () -> this.setTracker(progressTrackerDrawable);
    }

    private void setTracker(@Nullable Drawable tracker) {
        boolean hasTrackerIcon;
        if (tracker == this.mTracker) {
            return;
        }
        if (this.mTracker != null) {
            this.mTracker.setCallback(null);
        }
        if (tracker != null) {
            tracker.setCallback(this);
            if (this.getMirrorForRtl()) {
                tracker.setAutoMirrored(true);
            }
            if (this.canResolveLayoutDirection()) {
                tracker.setLayoutDirection(this.getLayoutDirection());
            }
        }
        boolean trackerSizeChanged = NotificationProgressBar.trackerSizeChanged(tracker, this.mTracker);
        this.mTracker = tracker;
        boolean bl = hasTrackerIcon = this.mTracker != null;
        if (this.mHasTrackerIcon != hasTrackerIcon) {
            this.mHasTrackerIcon = hasTrackerIcon;
            if (this.mNotificationProgressDrawable != null && this.mNotificationProgressDrawable.getBounds().width() != 0 && this.mProgressModel.isStyledByProgress()) {
                this.updateDrawableParts();
            }
        }
        this.configureTrackerBounds();
        this.updateTrackerAndBarPos(this.getWidth(), this.getHeight());
        if (trackerSizeChanged) {
            this.requestLayout();
        }
        this.invalidate();
        if (tracker != null && tracker.isStateful()) {
            tracker.setState(this.getDrawableState());
        }
    }

    private static boolean trackerSizeChanged(@Nullable Drawable newTracker, @Nullable Drawable oldTracker) {
        if (newTracker == null && oldTracker == null) {
            return false;
        }
        if (newTracker == null && oldTracker != null) {
            return true;
        }
        if (newTracker != null && oldTracker == null) {
            return true;
        }
        return newTracker.getIntrinsicWidth() != oldTracker.getIntrinsicWidth() || newTracker.getIntrinsicHeight() != oldTracker.getIntrinsicHeight();
    }

    private void configureTrackerBounds() {
        float scale;
        this.mTrackerDrawMatrix = null;
        this.mTrackerDrawWidth = 0;
        if (this.mTracker == null) {
            return;
        }
        if (this.mTrackerHeight <= 0) {
            this.mTrackerDrawWidth = this.mTracker.getIntrinsicWidth();
            return;
        }
        int dWidth = this.mTracker.getIntrinsicWidth();
        int dHeight = this.mTracker.getIntrinsicHeight();
        if (dWidth <= 0 || dHeight <= 0) {
            return;
        }
        int maxDWidth = dHeight * 2;
        int maxDHeight = dWidth * 2;
        this.mTrackerDrawMatrix = this.mMatrix;
        float dx = 0.0f;
        float dy = 0.0f;
        if (dWidth > maxDWidth) {
            scale = (float)this.mTrackerHeight / (float)dHeight;
            dx = ((float)maxDWidth * scale - (float)dWidth * scale) * 0.5f;
            this.mTrackerDrawWidth = (int)((float)maxDWidth * scale);
        } else if (dHeight > maxDHeight) {
            scale = (float)this.mTrackerHeight * 0.5f / (float)dWidth;
            dy = ((float)maxDHeight * scale - (float)dHeight * scale) * 0.5f;
            this.mTrackerDrawWidth = this.mTrackerHeight / 2;
        } else {
            scale = (float)this.mTrackerHeight / (float)dHeight;
            this.mTrackerDrawWidth = (int)((float)dWidth * scale);
        }
        this.mTrackerDrawMatrix.setScale(scale, scale);
        this.mTrackerDrawMatrix.postTranslate(Math.round(dx), Math.round(dy));
    }

    @Override
    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.onMaybeVisualProgressChanged();
    }

    @Override
    public void setProgress(int progress, boolean animate) {
        super.setProgress(progress, false);
        this.onMaybeVisualProgressChanged();
    }

    @Override
    public synchronized void setMin(int min) {
        super.setMin(min);
        this.onMaybeVisualProgressChanged();
    }

    @Override
    public synchronized void setMax(int max) {
        super.setMax(max);
        this.onMaybeVisualProgressChanged();
    }

    private void onMaybeVisualProgressChanged() {
        float progressFraction = this.getProgressFraction();
        if (this.mProgressFraction == progressFraction) {
            return;
        }
        this.mProgressFraction = progressFraction;
        this.mTrackerPosIsDirty = true;
        this.invalidate();
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.mTracker || super.verifyDrawable(who);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mTracker != null) {
            this.mTracker.jumpToCurrentState();
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable tracker = this.mTracker;
        if (tracker != null && tracker.isStateful() && tracker.setState(this.getDrawableState())) {
            this.invalidateDrawable(tracker);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mTracker != null) {
            this.mTracker.setHotspot(x, y);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateTrackerAndBarPos(w, h);
    }

    @Override
    public void onDrawableBoundsChanged() {
        Rect progressDrawableBounds = this.mNotificationProgressDrawable.getBounds();
        if (this.mProgressDrawableBounds.equals(progressDrawableBounds)) {
            return;
        }
        if (this.mProgressDrawableBounds.width() != progressDrawableBounds.width()) {
            this.updateDrawableParts();
        }
        this.mProgressDrawableBounds.set(progressDrawableBounds);
    }

    private void updateDrawableParts() {
        if (this.mNotificationProgressDrawable == null) {
            return;
        }
        if (this.mParts == null) {
            return;
        }
        float width = this.mNotificationProgressDrawable.getBounds().width();
        if (width == 0.0f) {
            if (this.mProgressDrawableParts != null) {
                this.mProgressDrawableParts.clear();
                this.mNotificationProgressDrawable.setParts(this.mProgressDrawableParts);
            }
            return;
        }
        float pointRadius = this.mNotificationProgressDrawable.getPointRadius();
        this.mProgressDrawableParts = NotificationProgressBar.processPartsAndConvertToDrawableParts(this.mParts, width, this.mSegSegGap, this.mSegPointGap, pointRadius, this.mHasTrackerIcon, this.mTrackerDrawWidth);
        float progressFraction = this.getProgressFraction();
        boolean isStyledByProgress = this.mProgressModel.isStyledByProgress();
        float progressGap = this.mHasTrackerIcon ? 0.0f : this.mSegSegGap;
        Pair<List<NotificationProgressDrawable.DrawablePart>, Float> p = null;
        try {
            p = NotificationProgressBar.maybeStretchAndRescaleSegments(this.mParts, this.mProgressDrawableParts, this.mSegMinWidth, pointRadius, progressFraction, isStyledByProgress, progressGap);
        }
        catch (NotEnoughWidthToFitAllPartsException ex) {
            Log.w(TAG, "Failed to stretch and rescale segments", ex);
        }
        List<Notification.ProgressStyle.Segment> fallbackSegments = null;
        if (p == null && this.mProgressModel.getSegments().size() > 1) {
            Log.w(TAG, "Falling back to single segment");
            try {
                fallbackSegments = List.of(new Notification.ProgressStyle.Segment(this.getMax()).setColor(this.mProgressModel.getSegmentsFallbackColor() == 0 ? this.mProgressModel.getSegments().getFirst().getColor() : this.mProgressModel.getSegmentsFallbackColor()));
                p = NotificationProgressBar.processModelAndConvertToFinalDrawableParts(fallbackSegments, this.mProgressModel.getPoints(), this.mProgressModel.getProgress(), this.getMax(), width, this.mSegSegGap, this.mSegPointGap, pointRadius, this.mHasTrackerIcon, this.mSegMinWidth, isStyledByProgress, this.mTrackerDrawWidth);
            }
            catch (NotEnoughWidthToFitAllPartsException ex) {
                Log.w(TAG, "Failed to stretch and rescale segments with single segment fallback", ex);
            }
        }
        if (p == null && !this.mProgressModel.getPoints().isEmpty()) {
            Log.w(TAG, "Falling back to single segment and no points");
            if (fallbackSegments == null) {
                fallbackSegments = List.of(new Notification.ProgressStyle.Segment(this.getMax()).setColor(this.mProgressModel.getSegmentsFallbackColor() == 0 ? this.mProgressModel.getSegments().getFirst().getColor() : this.mProgressModel.getSegmentsFallbackColor()));
            }
            try {
                p = NotificationProgressBar.processModelAndConvertToFinalDrawableParts(fallbackSegments, Collections.emptyList(), this.mProgressModel.getProgress(), this.getMax(), width, this.mSegSegGap, this.mSegPointGap, pointRadius, this.mHasTrackerIcon, this.mSegMinWidth, isStyledByProgress, this.mTrackerDrawWidth);
            }
            catch (NotEnoughWidthToFitAllPartsException ex) {
                Log.w(TAG, "Failed to stretch and rescale segments with single segments and no points", ex);
            }
        }
        if (p == null) {
            Log.w(TAG, "Falling back to no stretching and rescaling");
            p = NotificationProgressBar.maybeSplitDrawableSegmentsByProgress(this.mParts, this.mProgressDrawableParts, progressFraction, isStyledByProgress, progressGap);
        }
        ((NotificationProgressDrawable.DrawablePart)((List)p.first).getFirst()).setStart(0.0f);
        ((NotificationProgressDrawable.DrawablePart)((List)p.first).getLast()).setEnd(width);
        this.mNotificationProgressDrawable.setParts((List)p.first);
        this.mAdjustedProgressFraction = (((Float)p.second).floatValue() - (float)this.mTrackerDrawWidth / 2.0f) / (width - (float)this.mTrackerDrawWidth);
        this.mNotificationProgressDrawable.updateEndDotColor(this.getEndDotColor(fallbackSegments));
    }

    private int getEndDotColor(List<Notification.ProgressStyle.Segment> fallbackSegments) {
        if (!this.mProgressModel.isStyledByProgress()) {
            return 0;
        }
        if (this.mProgressModel.getProgress() == this.mProgressModel.getProgressMax()) {
            return 0;
        }
        return fallbackSegments == null ? this.mProgressModel.getSegments().getLast().getColor() : fallbackSegments.getLast().getColor();
    }

    private void updateTrackerAndBarPos(int w, int h) {
        int trackerOffsetY;
        int barOffsetY;
        int offsetHeight;
        int trackerHeight;
        int paddedHeight = h - this.mPaddingTop - this.mPaddingBottom;
        Drawable bar = this.getCurrentDrawable();
        Drawable tracker = this.mTracker;
        int barHeight = Math.min(this.getMaxHeight(), paddedHeight);
        int n = tracker == null ? 0 : (trackerHeight = this.mTrackerHeight <= 0 ? tracker.getIntrinsicHeight() : this.mTrackerHeight);
        if (trackerHeight > barHeight) {
            offsetHeight = (paddedHeight - trackerHeight) / 2;
            barOffsetY = offsetHeight + (trackerHeight - barHeight) / 2;
            trackerOffsetY = offsetHeight;
        } else {
            barOffsetY = offsetHeight = (paddedHeight - barHeight) / 2;
            trackerOffsetY = offsetHeight + (barHeight - trackerHeight) / 2;
        }
        if (bar != null) {
            int barWidth = w - this.mPaddingRight - this.mPaddingLeft;
            bar.setBounds(0, barOffsetY, barWidth, barOffsetY + barHeight);
        }
        if (tracker != null) {
            this.setTrackerPos(w, tracker, this.mAdjustedProgressFraction, trackerOffsetY);
        }
    }

    private float getProgressFraction() {
        int min = this.getMin();
        int max = this.getMax();
        int range = max - min;
        return NotificationProgressBar.getProgressFraction(range, this.getProgress() - min);
    }

    private static float getProgressFraction(int progressMax, int progress) {
        return progressMax > 0 ? (float)progress / (float)progressMax : 0.0f;
    }

    private void setTrackerPos(int w, Drawable tracker, float progressFraction, int offsetY) {
        int bottom;
        int top;
        int available = w - this.mPaddingLeft - this.mPaddingRight;
        int trackerWidth = tracker.getIntrinsicWidth();
        int trackerHeight = tracker.getIntrinsicHeight();
        int trackerPos = (int)(progressFraction * (float)(available -= this.mTrackerDrawWidth) + 0.5f);
        if (offsetY == Integer.MIN_VALUE) {
            Rect oldBounds = tracker.getBounds();
            top = oldBounds.top;
            bottom = oldBounds.bottom;
        } else {
            top = offsetY;
            bottom = offsetY + trackerHeight;
        }
        this.mTrackerPos = this.isLayoutRtl() && this.getMirrorForRtl() ? available - trackerPos : trackerPos;
        boolean left = false;
        int right = 0 + trackerWidth;
        Drawable background = this.getBackground();
        if (background != null) {
            int bkgOffsetX = this.mPaddingLeft;
            int bkgOffsetY = this.mPaddingTop;
            background.setHotspotBounds(0 + bkgOffsetX, top + bkgOffsetY, right + bkgOffsetX, bottom + bkgOffsetY);
        }
        tracker.setBounds(0, top, right, bottom);
        this.mTrackerPosIsDirty = false;
    }

    @Override
    public void onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mTracker != null) {
            this.mTracker.setLayoutDirection(layoutDirection);
        }
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isIndeterminate()) {
            return;
        }
        this.drawTracker(canvas);
    }

    private void drawTracker(Canvas canvas) {
        if (this.mTracker == null) {
            return;
        }
        if (this.mTrackerPosIsDirty) {
            this.setTrackerPos(this.getWidth(), this.mTracker, this.mAdjustedProgressFraction, Integer.MIN_VALUE);
        }
        int saveCount = canvas.save();
        canvas.translate(this.mPaddingLeft + this.mTrackerPos, this.mPaddingTop);
        if (this.mTrackerHeight > 0) {
            canvas.clipRect(0, 0, this.mTrackerDrawWidth, this.mTrackerHeight);
        }
        if (this.mTrackerDrawMatrix != null) {
            canvas.concat(this.mTrackerDrawMatrix);
        }
        this.mTracker.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int trackerHeight = this.mTracker == null ? 0 : this.mTracker.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.getMinWidth(), Math.min(this.getMaxWidth(), d.getIntrinsicWidth()));
            dh = Math.max(this.getMinHeight(), Math.min(this.getMaxHeight(), d.getIntrinsicHeight()));
            dh = Math.max(trackerHeight, dh);
        }
        this.setMeasuredDimension(NotificationProgressBar.resolveSizeAndState(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec, 0), NotificationProgressBar.resolveSizeAndState(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec, 0));
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return NotificationProgressBar.class.getName();
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        Drawable tracker = this.mTracker;
        if (tracker != null) {
            this.setTrackerPos(this.getWidth(), tracker, this.mAdjustedProgressFraction, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    @VisibleForTesting
    public static List<Part> processModelAndConvertToViewParts(List<Notification.ProgressStyle.Segment> segments, List<Notification.ProgressStyle.Point> points, int progress, int progressMax) {
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("List of segments shouldn't be empty");
        }
        int totalLength = segments.stream().mapToInt(Notification.ProgressStyle.Segment::getLength).sum();
        if (progressMax != totalLength) {
            throw new IllegalArgumentException("Invalid progressMax : " + progressMax);
        }
        for (Notification.ProgressStyle.Segment segment : segments) {
            int length = segment.getLength();
            if (length > 0) continue;
            throw new IllegalArgumentException("Invalid segment length : " + length);
        }
        if (progress < 0 || progress > progressMax) {
            throw new IllegalArgumentException("Invalid progress : " + progress);
        }
        for (Notification.ProgressStyle.Point point2 : points) {
            int pos = point2.getPosition();
            if (pos >= 0 && pos <= progressMax) continue;
            throw new IllegalArgumentException("Invalid Point position : " + pos);
        }
        points.removeIf(point -> {
            int pos = point.getPosition();
            if (pos == 0) {
                Log.w(TAG, "Dropping point at start");
                return true;
            }
            if (pos == progressMax) {
                Log.w(TAG, "Dropping point at end");
                return true;
            }
            return false;
        });
        Map<Integer, Notification.ProgressStyle.Segment> startToSegmentMap = NotificationProgressBar.generateStartToSegmentMap(segments);
        Map<Integer, Notification.ProgressStyle.Point> positionToPointMap = NotificationProgressBar.generatePositionToPointMap(points);
        SortedSet<Integer> sortedPos = NotificationProgressBar.generateSortedPositionSet(startToSegmentMap, positionToPointMap);
        Map<Integer, Notification.ProgressStyle.Segment> startToSplitSegmentMap = NotificationProgressBar.splitSegmentsByPoints(startToSegmentMap, sortedPos, progressMax);
        return NotificationProgressBar.convertToViewParts(startToSplitSegmentMap, positionToPointMap, sortedPos, progressMax);
    }

    private static Map<Integer, Notification.ProgressStyle.Segment> splitSegmentsByPoints(Map<Integer, Notification.ProgressStyle.Segment> startToSegmentMap, SortedSet<Integer> sortedPos, int progressMax) {
        int prevSegStart = 0;
        for (Integer pos : sortedPos) {
            if (pos == 0 || pos == progressMax) continue;
            if (startToSegmentMap.containsKey(pos)) {
                prevSegStart = pos;
                continue;
            }
            Notification.ProgressStyle.Segment prevSeg = startToSegmentMap.get(prevSegStart);
            Notification.ProgressStyle.Segment leftSeg = new Notification.ProgressStyle.Segment(pos - prevSegStart).setColor(prevSeg.getColor());
            Notification.ProgressStyle.Segment rightSeg = new Notification.ProgressStyle.Segment(prevSegStart + prevSeg.getLength() - pos).setColor(prevSeg.getColor());
            startToSegmentMap.put(prevSegStart, leftSeg);
            startToSegmentMap.put(pos, rightSeg);
            prevSegStart = pos;
        }
        return startToSegmentMap;
    }

    private static List<Part> convertToViewParts(Map<Integer, Notification.ProgressStyle.Segment> startToSegmentMap, Map<Integer, Notification.ProgressStyle.Point> positionToPointMap, SortedSet<Integer> sortedPos, int progressMax) {
        ArrayList<Part> parts = new ArrayList<Part>();
        for (Integer pos : sortedPos) {
            if (positionToPointMap.containsKey(pos)) {
                Notification.ProgressStyle.Point point = positionToPointMap.get(pos);
                parts.add(new Point(point.getColor()));
            }
            if (!startToSegmentMap.containsKey(pos)) continue;
            Notification.ProgressStyle.Segment seg = startToSegmentMap.get(pos);
            parts.add(new Segment((float)seg.getLength() / (float)progressMax, seg.getColor()));
        }
        return parts;
    }

    @ColorInt
    private static int maybeGetFadedColor(@ColorInt int color2, boolean fade) {
        if (!fade) {
            return color2;
        }
        return NotificationProgressBar.getFadedColor(color2);
    }

    @ColorInt
    static int getFadedColor(@ColorInt int color2) {
        return Color.argb((int)((float)Color.alpha(color2) * 0.5f + 0.5f), Color.red(color2), Color.green(color2), Color.blue(color2));
    }

    private static Map<Integer, Notification.ProgressStyle.Segment> generateStartToSegmentMap(List<Notification.ProgressStyle.Segment> segments) {
        HashMap<Integer, Notification.ProgressStyle.Segment> startToSegmentMap = new HashMap<Integer, Notification.ProgressStyle.Segment>();
        int currentStart = 0;
        for (Notification.ProgressStyle.Segment segment : segments) {
            startToSegmentMap.put(currentStart, segment);
            currentStart += segment.getLength();
        }
        return startToSegmentMap;
    }

    private static Map<Integer, Notification.ProgressStyle.Point> generatePositionToPointMap(List<Notification.ProgressStyle.Point> points) {
        HashMap<Integer, Notification.ProgressStyle.Point> positionToPointMap = new HashMap<Integer, Notification.ProgressStyle.Point>();
        for (Notification.ProgressStyle.Point point : points) {
            positionToPointMap.put(point.getPosition(), point);
        }
        return positionToPointMap;
    }

    private static SortedSet<Integer> generateSortedPositionSet(Map<Integer, Notification.ProgressStyle.Segment> startToSegmentMap, Map<Integer, Notification.ProgressStyle.Point> positionToPointMap) {
        TreeSet<Integer> sortedPos = new TreeSet<Integer>(startToSegmentMap.keySet());
        sortedPos.addAll(positionToPointMap.keySet());
        return sortedPos;
    }

    @VisibleForTesting
    public static List<NotificationProgressDrawable.DrawablePart> processPartsAndConvertToDrawableParts(List<Part> parts, float totalWidth, float segSegGap, float segPointGap, float pointRadius, boolean hasTrackerIcon, int trackerDrawWidth) {
        ArrayList<NotificationProgressDrawable.DrawablePart> drawableParts = new ArrayList<NotificationProgressDrawable.DrawablePart>();
        float available = totalWidth - (float)trackerDrawWidth;
        float x = (float)trackerDrawWidth / 2.0f;
        int nParts = parts.size();
        for (int iPart = 0; iPart < nParts; ++iPart) {
            Part nextPart;
            Part part = parts.get(iPart);
            Part prevPart = iPart == 0 ? null : parts.get(iPart - 1);
            Part part2 = nextPart = iPart + 1 == nParts ? null : parts.get(iPart + 1);
            if (part instanceof Segment) {
                Segment segment = (Segment)part;
                float segWidth = segment.mFraction * available;
                float startOffset = NotificationProgressBar.getSegStartOffset(prevPart, pointRadius, segPointGap);
                float start = x + startOffset;
                float endOffset = NotificationProgressBar.getSegEndOffset(segment, nextPart, pointRadius, segPointGap, segSegGap, hasTrackerIcon);
                float end = x + segWidth - endOffset;
                drawableParts.add(new NotificationProgressDrawable.DrawableSegment(start, end, segment.mColor, segment.mFaded));
                segment.mStart = x;
                segment.mEnd = x + segWidth;
                x += segWidth;
                continue;
            }
            if (!(part instanceof Point)) continue;
            Point point = (Point)part;
            float pointWidth = 2.0f * pointRadius;
            float start = x - pointRadius;
            float end = x + pointRadius;
            drawableParts.add(new NotificationProgressDrawable.DrawablePoint(start, end, point.mColor));
        }
        return drawableParts;
    }

    private static float getSegStartOffset(Part prevPart, float pointRadius, float segPointGap) {
        if (!(prevPart instanceof Point)) {
            return 0.0f;
        }
        return pointRadius + segPointGap;
    }

    private static float getSegEndOffset(Segment seg, Part nextPart, float pointRadius, float segPointGap, float segSegGap, boolean hasTrackerIcon) {
        if (nextPart == null) {
            return 0.0f;
        }
        if (nextPart instanceof Segment) {
            Segment nextSeg = (Segment)nextPart;
            if (!seg.mFaded && nextSeg.mFaded) {
                return hasTrackerIcon ? 0.0f : segSegGap;
            }
            return segSegGap;
        }
        return segPointGap + pointRadius;
    }

    @VisibleForTesting
    public static Pair<List<NotificationProgressDrawable.DrawablePart>, Float> maybeStretchAndRescaleSegments(List<Part> parts, List<NotificationProgressDrawable.DrawablePart> drawableParts, float segmentMinWidth, float pointRadius, float progressFraction, boolean isStyledByProgress, float progressGap) throws NotEnoughWidthToFitAllPartsException {
        List<NotificationProgressDrawable.DrawableSegment> drawableSegments = drawableParts.stream().filter(NotificationProgressDrawable.DrawableSegment.class::isInstance).map(NotificationProgressDrawable.DrawableSegment.class::cast).toList();
        float totalExcessWidth = 0.0f;
        float totalPositiveExcessWidth = 0.0f;
        for (NotificationProgressDrawable.DrawableSegment drawableSegment : drawableSegments) {
            float excessWidth = drawableSegment.getWidth() - segmentMinWidth;
            totalExcessWidth += excessWidth;
            if (!(excessWidth > 0.0f)) continue;
            totalPositiveExcessWidth += excessWidth;
        }
        if (totalExcessWidth == totalPositiveExcessWidth) {
            return NotificationProgressBar.maybeSplitDrawableSegmentsByProgress(parts, drawableParts, progressFraction, isStyledByProgress, progressGap);
        }
        if (totalExcessWidth < 0.0f) {
            throw new NotEnoughWidthToFitAllPartsException("Not enough width to satisfy the minimum width for segments.");
        }
        int nParts = drawableParts.size();
        float startOffset = 0.0f;
        for (int iPart = 0; iPart < nParts; ++iPart) {
            NotificationProgressDrawable.DrawablePart drawablePart = drawableParts.get(iPart);
            if (drawablePart instanceof NotificationProgressDrawable.DrawableSegment) {
                NotificationProgressDrawable.DrawableSegment drawableSegment = (NotificationProgressDrawable.DrawableSegment)drawablePart;
                float origDrawableSegmentWidth = drawableSegment.getWidth();
                float drawableSegmentWidth = segmentMinWidth;
                if (origDrawableSegmentWidth > segmentMinWidth) {
                    drawableSegmentWidth += totalExcessWidth * (origDrawableSegmentWidth - segmentMinWidth) / totalPositiveExcessWidth;
                }
                float widthDiff = drawableSegmentWidth - drawableSegment.getWidth();
                drawableSegment.setStart(drawableSegment.getStart() + startOffset);
                drawableSegment.setEnd(drawableSegment.getStart() + origDrawableSegmentWidth + widthDiff);
                Segment segment = (Segment)parts.get(iPart);
                float origSegmentWidth = segment.getWidth();
                segment.mStart += startOffset;
                segment.mEnd = segment.mStart + origSegmentWidth + widthDiff;
                startOffset += widthDiff;
                continue;
            }
            if (!(drawablePart instanceof NotificationProgressDrawable.DrawablePoint)) continue;
            NotificationProgressDrawable.DrawablePoint drawablePoint = (NotificationProgressDrawable.DrawablePoint)drawablePart;
            drawablePoint.setStart(drawablePoint.getStart() + startOffset);
            drawablePoint.setEnd(drawablePoint.getStart() + 2.0f * pointRadius);
        }
        return NotificationProgressBar.maybeSplitDrawableSegmentsByProgress(parts, drawableParts, progressFraction, isStyledByProgress, progressGap);
    }

    private static Pair<List<NotificationProgressDrawable.DrawablePart>, Float> maybeSplitDrawableSegmentsByProgress(List<Part> parts, List<NotificationProgressDrawable.DrawablePart> drawableParts, float progressFraction, boolean isStyledByProgress, float progressGap) {
        if (progressFraction == 1.0f) {
            return new Pair<List<NotificationProgressDrawable.DrawablePart>, Float>(drawableParts, Float.valueOf(drawableParts.getLast().getEnd()));
        }
        int iPartFirstSegmentToStyle = -1;
        int iPartSegmentToSplit = -1;
        float rescaledProgressX = 0.0f;
        float startFraction = 0.0f;
        int nParts = parts.size();
        for (int iPart = 0; iPart < nParts; ++iPart) {
            Part part = parts.get(iPart);
            if (!(part instanceof Segment)) continue;
            Segment segment = (Segment)part;
            if (startFraction == progressFraction) {
                iPartFirstSegmentToStyle = iPart;
                rescaledProgressX = segment.mStart;
                break;
            }
            if (startFraction < progressFraction && progressFraction < startFraction + segment.mFraction) {
                iPartSegmentToSplit = iPart;
                rescaledProgressX = segment.mStart + (progressFraction - startFraction) / segment.mFraction * segment.getWidth();
                break;
            }
            startFraction += segment.mFraction;
        }
        if (!isStyledByProgress) {
            return new Pair<List<NotificationProgressDrawable.DrawablePart>, Float>(drawableParts, Float.valueOf(rescaledProgressX));
        }
        ArrayList<NotificationProgressDrawable.DrawablePart> splitDrawableParts = new ArrayList<NotificationProgressDrawable.DrawablePart>();
        boolean styleRemainingParts = false;
        for (int iPart = 0; iPart < nParts; ++iPart) {
            int color2;
            NotificationProgressDrawable.DrawablePart drawablePart = drawableParts.get(iPart);
            if (drawablePart instanceof NotificationProgressDrawable.DrawablePoint) {
                NotificationProgressDrawable.DrawablePoint drawablePoint = (NotificationProgressDrawable.DrawablePoint)drawablePart;
                color2 = NotificationProgressBar.maybeGetFadedColor(drawablePoint.getColor(), styleRemainingParts);
                splitDrawableParts.add(new NotificationProgressDrawable.DrawablePoint(drawablePoint.getStart(), drawablePoint.getEnd(), color2));
            }
            if (iPart == iPartFirstSegmentToStyle) {
                styleRemainingParts = true;
            }
            if (!(drawablePart instanceof NotificationProgressDrawable.DrawableSegment)) continue;
            NotificationProgressDrawable.DrawableSegment drawableSegment = (NotificationProgressDrawable.DrawableSegment)drawablePart;
            if (iPart == iPartSegmentToSplit) {
                if (rescaledProgressX <= drawableSegment.getStart()) {
                    styleRemainingParts = true;
                    color2 = NotificationProgressBar.maybeGetFadedColor(drawableSegment.getColor(), true);
                    splitDrawableParts.add(new NotificationProgressDrawable.DrawableSegment(drawableSegment.getStart(), drawableSegment.getEnd(), color2, true));
                    continue;
                }
                if (drawableSegment.getStart() < rescaledProgressX && rescaledProgressX < drawableSegment.getEnd()) {
                    splitDrawableParts.add(new NotificationProgressDrawable.DrawableSegment(drawableSegment.getStart(), rescaledProgressX - progressGap, drawableSegment.getColor()));
                    color2 = NotificationProgressBar.maybeGetFadedColor(drawableSegment.getColor(), true);
                    splitDrawableParts.add(new NotificationProgressDrawable.DrawableSegment(rescaledProgressX, drawableSegment.getEnd(), color2, true));
                    styleRemainingParts = true;
                    continue;
                }
                splitDrawableParts.add(new NotificationProgressDrawable.DrawableSegment(drawableSegment.getStart(), drawableSegment.getEnd(), drawableSegment.getColor()));
                styleRemainingParts = true;
                continue;
            }
            color2 = NotificationProgressBar.maybeGetFadedColor(drawableSegment.getColor(), styleRemainingParts);
            splitDrawableParts.add(new NotificationProgressDrawable.DrawableSegment(drawableSegment.getStart(), drawableSegment.getEnd(), color2, styleRemainingParts));
        }
        return new Pair<List<NotificationProgressDrawable.DrawablePart>, Float>(splitDrawableParts, Float.valueOf(rescaledProgressX));
    }

    @VisibleForTesting
    public static Pair<List<NotificationProgressDrawable.DrawablePart>, Float> processModelAndConvertToFinalDrawableParts(List<Notification.ProgressStyle.Segment> segments, List<Notification.ProgressStyle.Point> points, int progress, int progressMax, float totalWidth, float segSegGap, float segPointGap, float pointRadius, boolean hasTrackerIcon, float segmentMinWidth, boolean isStyledByProgress, int trackerDrawWidth) throws NotEnoughWidthToFitAllPartsException {
        List<Part> parts = NotificationProgressBar.processModelAndConvertToViewParts(segments, points, progress, progressMax);
        List<NotificationProgressDrawable.DrawablePart> drawableParts = NotificationProgressBar.processPartsAndConvertToDrawableParts(parts, totalWidth, segSegGap, segPointGap, pointRadius, hasTrackerIcon, trackerDrawWidth);
        return NotificationProgressBar.maybeStretchAndRescaleSegments(parts, drawableParts, segmentMinWidth, pointRadius, NotificationProgressBar.getProgressFraction(progressMax, progress), isStyledByProgress, hasTrackerIcon ? 0.0f : segSegGap);
    }

    public static class NotEnoughWidthToFitAllPartsException
    extends Exception {
        public NotEnoughWidthToFitAllPartsException(String message) {
            super(message);
        }
    }

    public static class Point
    implements Part {
        @ColorInt
        private final int mColor;

        public Point(@ColorInt int color2) {
            this.mColor = color2;
        }

        public String toString() {
            return "Point(color=" + this.mColor + ")";
        }

        public boolean equals(@com.android.layoutlib.androidx.annotation.Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Point that = (Point)other;
            return this.mColor == that.mColor;
        }

        public int hashCode() {
            return Objects.hash(this.mColor);
        }
    }

    public static class Segment
    implements Part {
        private final float mFraction;
        @ColorInt
        private final int mColor;
        private final boolean mFaded;
        private float mStart;
        private float mEnd;

        public Segment(float fraction2, @ColorInt int color2) {
            this(fraction2, color2, false);
        }

        public Segment(float fraction2, @ColorInt int color2, boolean faded) {
            this.mFraction = fraction2;
            this.mColor = color2;
            this.mFaded = faded;
        }

        public float getWidth() {
            return this.mEnd - this.mStart;
        }

        public String toString() {
            return "Segment(fraction=" + this.mFraction + ", color=" + this.mColor + ", faded=" + this.mFaded + "), mStart = " + this.mStart + ", mEnd = " + this.mEnd;
        }

        public boolean equals(@com.android.layoutlib.androidx.annotation.Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Segment that = (Segment)other;
            if (Float.compare(this.mFraction, that.mFraction) != 0) {
                return false;
            }
            if (this.mColor != that.mColor) {
                return false;
            }
            return this.mFaded == that.mFaded;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mFraction), this.mColor, this.mFaded);
        }
    }

    public static interface Part {
    }
}

