/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.app.Flags;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.layoutlib.bridge.android.AndroidLocale;

@RemoteViews.RemoteView
public class NotificationExpandButton
extends FrameLayout {
    private Drawable mPillDrawable;
    private TextView mNumberView;
    private ImageView mIconView;
    private LinearLayout mPillView;
    private boolean mExpanded;
    private int mNumber;
    private int mDefaultPillColor;
    private int mDefaultTextColor;
    private int mHighlightPillColor;
    private int mHighlightTextColor;

    public NotificationExpandButton(Context context) {
        this(context, null, 0, 0);
    }

    public NotificationExpandButton(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public NotificationExpandButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationExpandButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPillView = (LinearLayout)this.findViewById(16909045);
        LayerDrawable layeredPill = (LayerDrawable)this.mPillView.getBackground();
        this.mPillDrawable = layeredPill.findDrawableByLayerId(16909046);
        this.mNumberView = (TextView)this.findViewById(16909044);
        this.mIconView = (ImageView)this.findViewById(16909043);
    }

    @Override
    public void getBoundsOnScreen(Rect outRect, boolean clipToParent) {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null && parent.getId() == 16909047) {
            parent.getBoundsOnScreen(outRect, clipToParent);
        } else {
            super.getBoundsOnScreen(outRect, clipToParent);
        }
    }

    @Override
    public boolean pointInView(float localX, float localY, float slop) {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null && parent.getId() == 16909047) {
            return true;
        }
        return super.pointInView(localX, localY, slop);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(Button.class.getName());
    }

    @RemotableViewMethod
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
        this.updateExpandedState();
    }

    @RemotableViewMethod
    public void setStartPadding(int startPadding) {
        this.setPaddingRelative(startPadding, this.getPaddingTop(), this.getPaddingEnd(), this.getPaddingBottom());
    }

    private void updateExpandedState() {
        int contentDescriptionId;
        int drawableId;
        if (this.mExpanded) {
            drawableId = Flags.notificationsRedesignTemplates() ? 17302917 : 17302519;
            contentDescriptionId = 17040312;
        } else {
            drawableId = Flags.notificationsRedesignTemplates() ? 17302918 : 17302579;
            contentDescriptionId = 17040311;
        }
        this.setContentDescription(this.mContext.getText(contentDescriptionId));
        this.mIconView.setImageDrawable(this.getContext().getDrawable(drawableId));
        if (!Flags.notificationsRedesignTemplates()) {
            this.updateNumber();
        }
    }

    private void updateNumber() {
        if (this.shouldShowNumber()) {
            String text = this.mNumber >= 100 ? this.getResources().getString(17042009, 99) : String.format(AndroidLocale.getDefault(), "%d", this.mNumber);
            this.mNumberView.setText(text);
            this.mNumberView.setVisibility(0);
        } else {
            this.mNumberView.setVisibility(8);
        }
        this.updateColors();
        this.updatePadding();
    }

    private void updatePadding() {
        if (!Flags.notificationsRedesignTemplates()) {
            return;
        }
        int reducedPadding = this.getResources().getDimensionPixelSize(17105538);
        int normalPadding = this.getResources().getDimensionPixelSize(17105534);
        this.mPillView.setPaddingRelative(normalPadding, this.mPillView.getPaddingTop(), this.shouldShowNumber() ? reducedPadding : normalPadding, this.mPillView.getPaddingBottom());
    }

    private void updateColors() {
        if (this.shouldShowNumber()) {
            if (this.mHighlightPillColor != 0) {
                this.mPillDrawable.setTintList(ColorStateList.valueOf(this.mHighlightPillColor));
            }
            this.mIconView.setColorFilter(this.mHighlightTextColor);
            if (this.mHighlightTextColor != 0) {
                this.mNumberView.setTextColor(this.mHighlightTextColor);
            }
        } else {
            if (this.mDefaultPillColor != 0) {
                this.mPillDrawable.setTintList(ColorStateList.valueOf(this.mDefaultPillColor));
            }
            this.mIconView.setColorFilter(this.mDefaultTextColor);
            if (this.mDefaultTextColor != 0) {
                this.mNumberView.setTextColor(this.mDefaultTextColor);
            }
        }
    }

    private boolean shouldShowNumber() {
        if (Flags.notificationsRedesignTemplates()) {
            return this.mNumber > 1;
        }
        return !this.mExpanded && this.mNumber > 1;
    }

    @RemotableViewMethod
    public void setDefaultTextColor(int color2) {
        this.mDefaultTextColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setDefaultPillColor(int color2) {
        this.mDefaultPillColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setHighlightTextColor(int color2) {
        this.mHighlightTextColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setHighlightPillColor(int color2) {
        this.mHighlightPillColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setNumber(int number) {
        if (this.mNumber != number) {
            this.mNumber = number;
            this.updateNumber();
        }
    }
}

