/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class NotificationCloseButton
extends ImageView {
    private int mBackgroundColor;
    private int mForegroundColor;
    private Drawable mPillDrawable;

    public NotificationCloseButton(Context context) {
        this(context, null, 0, 0);
    }

    public NotificationCloseButton(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public NotificationCloseButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationCloseButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setContentDescription(this.mContext.getText(17039855));
        LayerDrawable layeredPill = (LayerDrawable)this.getBackground();
        this.mPillDrawable = layeredPill.findDrawableByLayerId(16908935);
        boolean notificationCloseButtonSupported = Resources.getSystem().getBoolean(0x1110200);
        this.setVisibility(notificationCloseButtonSupported ? 0 : 8);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(Button.class.getName());
    }

    private void updateColors() {
        if (this.mBackgroundColor != 0) {
            this.mPillDrawable.setTintList(ColorStateList.valueOf(this.mBackgroundColor));
        }
        if (this.mForegroundColor != 0) {
            this.setImageTintList(ColorStateList.valueOf(this.mForegroundColor));
        }
    }

    @RemotableViewMethod
    public void setForegroundColor(int color2) {
        this.mForegroundColor = color2;
        this.updateColors();
    }

    @Override
    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.updateColors();
    }
}

