/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import libcore.util.HexEncoding;

public class LockscreenCredential
implements Parcelable,
AutoCloseable {
    private final int mType;
    private byte[] mCredential;
    private final boolean mHasInvalidChars;
    public static final Parcelable.Creator<LockscreenCredential> CREATOR = new Parcelable.Creator<LockscreenCredential>(){

        @Override
        public LockscreenCredential createFromParcel(Parcel source) {
            return new LockscreenCredential(source.readInt(), source.createByteArray(), source.readBoolean());
        }

        public LockscreenCredential[] newArray(int size) {
            return new LockscreenCredential[size];
        }
    };

    private LockscreenCredential(int type, byte[] credential, boolean hasInvalidChars) {
        Objects.requireNonNull(credential);
        if (type == -1) {
            Preconditions.checkArgument(credential.length == 0);
        } else {
            Preconditions.checkArgument(type == 3 || type == 4 || type == 1);
        }
        this.mType = type;
        this.mCredential = credential;
        this.mHasInvalidChars = hasInvalidChars;
    }

    private LockscreenCredential(int type, CharSequence credential) {
        this(type, LockscreenCredential.charsToBytesTruncating(credential), LockscreenCredential.hasInvalidChars(credential));
    }

    public static LockscreenCredential createNone() {
        return new LockscreenCredential(-1, new byte[0], false);
    }

    public static LockscreenCredential createPattern(@NonNull List<LockPatternView.Cell> pattern) {
        return new LockscreenCredential(1, LockPatternUtils.patternToByteArray(pattern), false);
    }

    public static LockscreenCredential createPassword(@NonNull CharSequence password) {
        return new LockscreenCredential(4, password);
    }

    public static LockscreenCredential createUnifiedProfilePassword(@NonNull byte[] password) {
        return new LockscreenCredential(4, LockscreenCredential.copyOfArrayNonMovable(password), false);
    }

    public static LockscreenCredential createPin(@NonNull CharSequence pin) {
        return new LockscreenCredential(3, pin);
    }

    public static LockscreenCredential createPasswordOrNone(@Nullable CharSequence password) {
        if (TextUtils.isEmpty(password)) {
            return LockscreenCredential.createNone();
        }
        return LockscreenCredential.createPassword(password);
    }

    public static LockscreenCredential createPinOrNone(@Nullable CharSequence pin) {
        if (TextUtils.isEmpty(pin)) {
            return LockscreenCredential.createNone();
        }
        return LockscreenCredential.createPin(pin);
    }

    private void ensureNotZeroized() {
        Preconditions.checkState(this.mCredential != null, "Credential is already zeroized");
    }

    public int getType() {
        this.ensureNotZeroized();
        return this.mType;
    }

    public byte[] getCredential() {
        this.ensureNotZeroized();
        return this.mCredential;
    }

    public boolean isNone() {
        this.ensureNotZeroized();
        return this.mType == -1;
    }

    public boolean isPattern() {
        this.ensureNotZeroized();
        return this.mType == 1;
    }

    public boolean isPin() {
        this.ensureNotZeroized();
        return this.mType == 3;
    }

    public boolean isPassword() {
        this.ensureNotZeroized();
        return this.mType == 4;
    }

    public int size() {
        this.ensureNotZeroized();
        return this.mCredential.length;
    }

    public boolean hasInvalidChars() {
        this.ensureNotZeroized();
        return this.mHasInvalidChars;
    }

    public LockscreenCredential duplicate() {
        return new LockscreenCredential(this.mType, this.mCredential != null ? LockscreenCredential.copyOfArrayNonMovable(this.mCredential) : null, this.mHasInvalidChars);
    }

    public void zeroize() {
        if (this.mCredential != null) {
            LockPatternUtils.zeroize(this.mCredential);
            this.mCredential = null;
        }
    }

    private static byte[] copyOfArrayNonMovable(byte[] array2) {
        byte[] copy = LockPatternUtils.newNonMovableByteArray(array2.length);
        System.arraycopy(array2, 0, copy, 0, array2.length);
        return copy;
    }

    public void validateBasicRequirements() {
        if (this.mHasInvalidChars) {
            throw new IllegalArgumentException("credential contains invalid characters");
        }
        switch (this.getType()) {
            case 1: {
                if (this.size() >= 4) break;
                throw new IllegalArgumentException("pattern must be at least 4 dots long.");
            }
            case 3: {
                if (this.size() >= 4) break;
                throw new IllegalArgumentException("PIN must be at least 4 digits long.");
            }
            case 4: {
                if (this.size() >= 4) break;
                throw new IllegalArgumentException("password must be at least 4 characters long.");
            }
        }
    }

    public boolean checkAgainstStoredType(int storedCredentialType) {
        if (storedCredentialType == 2) {
            return this.getType() == 4 || this.getType() == 3;
        }
        return this.getType() == storedCredentialType;
    }

    public String passwordToHistoryHash(byte[] salt, byte[] hashFactor) {
        return LockscreenCredential.passwordToHistoryHash(this.mCredential, salt, hashFactor);
    }

    public static String passwordToHistoryHash(byte[] passwordToHash, byte[] salt, byte[] hashFactor) {
        if (passwordToHash == null || passwordToHash.length == 0 || hashFactor == null || salt == null) {
            return null;
        }
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(hashFactor);
            sha256.update(passwordToHash);
            sha256.update(salt);
            return HexEncoding.encodeToString(sha256.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Missing digest algorithm: ", e);
        }
    }

    @Deprecated
    public static String legacyPasswordToHash(byte[] password, byte[] salt) {
        if (password == null || password.length == 0 || salt == null) {
            return null;
        }
        try {
            byte[] saltedPassword = ArrayUtils.concat(password, salt);
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            LockPatternUtils.zeroize(saltedPassword);
            return HexEncoding.encodeToString(ArrayUtils.concat(sha1, md5));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Missing digest algorithm: ", e);
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeByteArray(this.mCredential);
        dest.writeBoolean(this.mHasInvalidChars);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void close() {
        this.zeroize();
    }

    public void finalize() {
        this.zeroize();
    }

    public int hashCode() {
        return Objects.hash(this.mType, Arrays.hashCode(this.mCredential), this.mHasInvalidChars);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LockscreenCredential)) {
            return false;
        }
        LockscreenCredential other = (LockscreenCredential)o;
        return this.mType == other.mType && Arrays.equals(this.mCredential, other.mCredential) && this.mHasInvalidChars == other.mHasInvalidChars;
    }

    private static boolean hasInvalidChars(CharSequence chars) {
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c >= ' ' && c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private static byte[] charsToBytesTruncating(CharSequence chars) {
        byte[] bytes = LockPatternUtils.newNonMovableByteArray(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            bytes[i] = (byte)chars.charAt(i);
        }
        return bytes;
    }
}

