/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.R;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Flags;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.RippleDrawable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.style.ImageSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.widget.Button;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class EmphasizedNotificationButton
extends Button {
    private final RippleDrawable mRipple = (RippleDrawable)this.getBackground();
    private final GradientDrawable mBackground;
    private boolean mPriority;
    private int mInitialDrawablePadding;
    private int mIconSize;
    private Drawable mIconToGlue;
    private CharSequence mLabelToGlue;
    private int mGluedLayoutDirection = -1;
    private boolean mGluePending;
    private static final String IMAGE_SPAN_TEXT = "\ufffd";
    private static final String SPACER_SPAN_TEXT = "\u00a0";
    private static final String LEFT_TO_RIGHT_ISOLATE = "\u2066";
    private static final String RIGHT_TO_LEFT_ISOLATE = "\u2067";
    private static final String FIRST_STRONG_ISOLATE = "\u2068";
    private static final String POP_DIRECTIONAL_ISOLATE = "\u2069";
    private static final String TAG = "EmphasizedNotificationButton";

    public EmphasizedNotificationButton(Context context) {
        this(context, null);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mRipple.mutate();
        DrawableWrapper inset = (DrawableWrapper)this.mRipple.getDrawable(0);
        this.mBackground = (GradientDrawable)inset.getDrawable();
        this.mIconSize = this.mContext.getResources().getDimensionPixelSize(17105563);
        try (TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);){
            this.mInitialDrawablePadding = typedArray.getDimensionPixelSize(52, 0);
        }
        Log.v(TAG, "iconSize = " + this.mIconSize + "px, initialDrawablePadding = " + this.mInitialDrawablePadding + "px");
    }

    @RemotableViewMethod
    public void setRippleColor(ColorStateList color2) {
        this.mRipple.setColor(color2);
        this.invalidate();
    }

    @RemotableViewMethod
    public void setButtonBackground(ColorStateList color2) {
        this.mBackground.setColor(color2);
        this.invalidate();
    }

    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(@Nullable Icon icon) {
        Drawable drawable2 = icon == null ? null : icon.loadDrawable(this.mContext);
        this.setImageDrawable(drawable2);
    }

    @RemotableViewMethod
    public Runnable setImageIconAsync(@Nullable Icon icon) {
        Drawable drawable2 = icon == null ? null : icon.loadDrawable(this.mContext);
        return () -> this.setImageDrawable(drawable2);
    }

    private void setImageDrawable(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            this.prepareIcon(drawable2);
        }
        this.setCompoundDrawablesRelative(drawable2, null, null, null);
    }

    @RemotableViewMethod(asyncImpl="glueIconAsync")
    public void glueIcon(@Nullable Icon icon) {
        Drawable drawable2 = icon == null ? null : icon.loadDrawable(this.mContext);
        this.setIconToGlue(drawable2);
    }

    @RemotableViewMethod
    public Runnable glueIconAsync(@Nullable Icon icon) {
        Drawable drawable2 = icon == null ? null : icon.loadDrawable(this.mContext);
        return () -> this.setIconToGlue(drawable2);
    }

    private void setIconToGlue(@Nullable Drawable icon) {
        if (!Flags.evenlyDividedCallStyleActionLayout()) {
            Log.e(TAG, "glueIcon: new action layout disabled; doing nothing");
            return;
        }
        if (icon != null) {
            this.prepareIcon(icon);
        }
        this.mIconToGlue = icon;
        this.mGluePending = true;
        this.glueIconAndLabelIfNeeded();
    }

    private void prepareIcon(@NonNull Drawable drawable2) {
        drawable2.mutate();
        drawable2.setTintList(this.getTextColors());
        drawable2.setTintBlendMode(BlendMode.SRC_IN);
        drawable2.setBounds(0, 0, this.mIconSize, this.mIconSize);
    }

    @RemotableViewMethod(asyncImpl="glueLabelAsync")
    public void glueLabel(@Nullable CharSequence label) {
        this.setLabelToGlue(label);
    }

    @RemotableViewMethod
    public Runnable glueLabelAsync(@Nullable CharSequence label) {
        return () -> this.setLabelToGlue(label);
    }

    private void setLabelToGlue(@Nullable CharSequence label) {
        if (!Flags.evenlyDividedCallStyleActionLayout()) {
            Log.e(TAG, "glueLabel: new action layout disabled; doing nothing");
            return;
        }
        this.mLabelToGlue = label;
        this.mGluePending = true;
        this.glueIconAndLabelIfNeeded();
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean alreadyGlued;
        super.onRtlPropertiesChanged(layoutDirection);
        Log.v(TAG, "onRtlPropertiesChanged: layoutDirection = " + layoutDirection + ", gluedLayoutDirection = " + this.mGluedLayoutDirection);
        boolean bl = alreadyGlued = this.mGluedLayoutDirection != -1;
        if (alreadyGlued && layoutDirection != this.mGluedLayoutDirection) {
            Log.d(TAG, "onRtlPropertiesChanged: layout direction changed; regluing");
            this.mGluePending = true;
        }
        this.glueIconAndLabelIfNeeded();
    }

    private void glueIconAndLabelIfNeeded() {
        if (!this.mGluePending) {
            Log.v(TAG, "glueIconAndLabelIfNeeded: glue not pending; doing nothing");
            return;
        }
        if (!Flags.evenlyDividedCallStyleActionLayout()) {
            Log.e(TAG, "glueIconAndLabelIfNeeded: new action layout disabled; doing nothing");
            return;
        }
        if (!this.isLayoutDirectionResolved()) {
            Log.v(TAG, "glueIconAndLabelIfNeeded: layout direction not resolved; doing nothing");
            return;
        }
        int layoutDirection = this.getLayoutDirection();
        if (layoutDirection != 0 && layoutDirection != 1) {
            Log.e(TAG, "glueIconAndLabelIfNeeded: resolved layout direction neither LTR nor RTL; doing nothing");
            return;
        }
        this.glueIconAndLabel(layoutDirection);
        this.mGluePending = false;
        this.mGluedLayoutDirection = layoutDirection;
    }

    private void glueIconAndLabel(int layoutDirection) {
        if (this.mIconToGlue == null && this.mLabelToGlue == null) {
            Log.d(TAG, "glueIconAndLabel: null icon and label, setting text to empty string");
            this.setText("");
            return;
        }
        if (this.mIconToGlue == null) {
            Log.d(TAG, "glueIconAndLabel: null icon, setting text to label");
            this.setText(this.mLabelToGlue);
            return;
        }
        if (this.mLabelToGlue == null) {
            Log.d(TAG, "glueIconAndLabel: null label, setting text to ImageSpan with icon");
            SpannableStringBuilder builder = new SpannableStringBuilder();
            this.appendSpan(builder, IMAGE_SPAN_TEXT, new ImageSpan(this.mIconToGlue, 2));
            this.setText(builder);
            return;
        }
        boolean rtlLayout = layoutDirection == 1;
        Log.d(TAG, "glueIconAndLabel: icon = " + this.mIconToGlue + ", iconSize = " + this.mIconSize + "px, initialDrawablePadding = " + this.mInitialDrawablePadding + "px, labelToGlue.length = " + this.mLabelToGlue.length() + ", rtlLayout = " + rtlLayout);
        this.logIfTextDirectionNotFirstStrong();
        SpannableStringBuilder builder = new SpannableStringBuilder();
        builder.append(rtlLayout ? RIGHT_TO_LEFT_ISOLATE : LEFT_TO_RIGHT_ISOLATE);
        this.appendSpan(builder, IMAGE_SPAN_TEXT, new ImageSpan(this.mIconToGlue, 2));
        this.appendSpan(builder, SPACER_SPAN_TEXT, new SpacerSpan(this.mInitialDrawablePadding));
        builder.append(FIRST_STRONG_ISOLATE);
        this.appendSpan(builder, this.mLabelToGlue, new CenterBesideImageSpan(this.mIconSize));
        builder.append(POP_DIRECTIONAL_ISOLATE);
        builder.append(POP_DIRECTIONAL_ISOLATE);
        this.setText(builder);
    }

    private void logIfTextDirectionNotFirstStrong() {
        int textDirection;
        if (!this.isTextDirectionResolved()) {
            Log.e(TAG, "glueIconAndLabel: text direction not resolved; letting View assume FIRST STRONG");
        }
        if ((textDirection = this.getTextDirection()) != 1) {
            Log.w(TAG, "glueIconAndLabel: expected text direction TEXT_DIRECTION_FIRST_STRONG but found " + textDirection + "; will use a FIRST STRONG ISOLATE regardless");
        }
    }

    private void appendSpan(SpannableStringBuilder builder, CharSequence text, Object span) {
        int spanStart = builder.length();
        builder.append(text);
        int spanEnd = builder.length();
        builder.setSpan(span, spanStart, spanEnd, 0);
    }

    @RemotableViewMethod
    public void setIsPriority(boolean priority) {
        this.mPriority = priority;
    }

    public boolean isPriority() {
        return this.mPriority;
    }

    private static class SpacerSpan
    extends ReplacementSpan {
        private int mWidth;
        private static final String TAG = "SpacerSpan";

        SpacerSpan(int width) {
            this.mWidth = width;
            Log.d(TAG, "width = " + this.mWidth + "px");
        }

        @Override
        public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fontMetrics) {
            Log.v(TAG, "getSize returning " + this.mWidth + "px");
            return this.mWidth;
        }

        @Override
        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Log.v(TAG, "drawing nothing");
        }
    }

    private static class CenterBesideImageSpan
    extends MetricAffectingSpan {
        private int mImageHeight;
        private boolean mMeasured;
        private int mBaselineShiftOffset;
        private static final String TAG = "CenterBesideImageSpan";

        CenterBesideImageSpan(int imageHeight) {
            this.mImageHeight = imageHeight;
            Log.d(TAG, "imageHeight = " + this.mImageHeight + "px");
        }

        @Override
        public void updateMeasureState(@NonNull TextPaint textPaint) {
            int textHeight = (int)(-textPaint.ascent());
            this.mBaselineShiftOffset = textHeight < this.mImageHeight ? -(this.mImageHeight - textHeight) / 2 : 0;
            this.mMeasured = true;
            Log.d(TAG, "updateMeasureState: imageHeight = " + this.mImageHeight + "px, textHeight = " + textHeight + "px, baselineShiftOffset = " + this.mBaselineShiftOffset + "px");
            textPaint.baselineShift += this.mBaselineShiftOffset;
        }

        @Override
        public void updateDrawState(TextPaint textPaint) {
            if (textPaint == null) {
                Log.e(TAG, "updateDrawState: textPaint is null; doing nothing");
                return;
            }
            if (!this.mMeasured) {
                Log.e(TAG, "updateDrawState: called without measure; doing nothing");
                return;
            }
            Log.v(TAG, "updateDrawState: baselineShiftOffset = " + this.mBaselineShiftOffset + "px");
            textPaint.baselineShift += this.mBaselineShiftOffset;
        }
    }
}

